/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.broker;

import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.broker.IdpUsernamePasswordForm;
import org.keycloak.authentication.authenticators.browser.UsernamePasswordFormFactory;
import org.keycloak.models.KeycloakSession;

public class IdpUsernamePasswordFormFactory
extends UsernamePasswordFormFactory {
    public static final String PROVIDER_ID = "idp-username-password-form";

    @Override
    public Authenticator create(KeycloakSession session) {
        return new IdpUsernamePasswordForm(session);
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public String getHelpText() {
        return "Validates a password from login form. Username may be already known from identity provider authentication";
    }

    @Override
    public String getDisplayType() {
        return "Username Password Form for identity provider reauthentication";
    }
}

