/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.CountingOutputStream;
import org.jboss.logmanager.handlers.FileHandler;
import org.jboss.logmanager.handlers.SecurityActions;
import org.jboss.logmanager.handlers.SuffixRotator;

public class SizeRotatingFileHandler
extends FileHandler {
    private final AccessControlContext acc = AccessController.getContext();
    private long rotateSize = 0xA00000L;
    private int maxBackupIndex = 1;
    private CountingOutputStream outputStream;
    private boolean rotateOnBoot;
    private SuffixRotator suffixRotator = SuffixRotator.EMPTY;

    public SizeRotatingFileHandler() {
    }

    public SizeRotatingFileHandler(File file) throws FileNotFoundException {
        super(file);
    }

    public SizeRotatingFileHandler(File file, boolean append) throws FileNotFoundException {
        super(file, append);
    }

    public SizeRotatingFileHandler(String fileName) throws FileNotFoundException {
        super(fileName);
    }

    public SizeRotatingFileHandler(String fileName, boolean append) throws FileNotFoundException {
        super(fileName, append);
    }

    public SizeRotatingFileHandler(long rotateSize, int maxBackupIndex) {
        this.rotateSize = rotateSize;
        this.maxBackupIndex = maxBackupIndex;
    }

    public SizeRotatingFileHandler(File file, long rotateSize, int maxBackupIndex) throws FileNotFoundException {
        super(file);
        this.rotateSize = rotateSize;
        this.maxBackupIndex = maxBackupIndex;
    }

    public SizeRotatingFileHandler(File file, boolean append, long rotateSize, int maxBackupIndex) throws FileNotFoundException {
        super(file, append);
        this.rotateSize = rotateSize;
        this.maxBackupIndex = maxBackupIndex;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.lock.lock();
        try {
            this.outputStream = outputStream == null ? null : new CountingOutputStream(outputStream);
            super.setOutputStream(this.outputStream);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setFile(File file) throws FileNotFoundException {
        SizeRotatingFileHandler.checkAccess();
        this.lock.lock();
        try {
            if (this.rotateOnBoot && this.maxBackupIndex > 0 && file != null && file.exists() && file.length() > 0L) {
                this.setFileInternal(null, false);
                this.suffixRotator.rotate(this.getErrorManager(), file.toPath(), this.maxBackupIndex);
            }
            this.setFileInternal(file, false);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRotateOnBoot() {
        this.lock.lock();
        try {
            boolean bl = this.rotateOnBoot;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRotateOnBoot(boolean rotateOnBoot) {
        SizeRotatingFileHandler.checkAccess();
        this.lock.lock();
        try {
            this.rotateOnBoot = rotateOnBoot;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRotateSize(long rotateSize) {
        SizeRotatingFileHandler.checkAccess();
        this.lock.lock();
        try {
            this.rotateSize = rotateSize;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMaxBackupIndex(int maxBackupIndex) {
        SizeRotatingFileHandler.checkAccess();
        this.lock.lock();
        try {
            this.maxBackupIndex = maxBackupIndex;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getSuffix() {
        if (this.suffixRotator == SuffixRotator.EMPTY) {
            return null;
        }
        return this.suffixRotator.toString();
    }

    public void setSuffix(String suffix) {
        SizeRotatingFileHandler.checkAccess();
        this.lock.lock();
        try {
            this.suffixRotator = SuffixRotator.parse(this.acc, suffix);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void preWrite(ExtLogRecord record) {
        long currentSize;
        int maxBackupIndex = this.maxBackupIndex;
        long l = currentSize = this.outputStream == null ? Long.MIN_VALUE : this.outputStream.currentSize;
        if (currentSize > this.rotateSize && maxBackupIndex > 0) {
            try {
                File file = this.getFile();
                if (file == null) {
                    return;
                }
                this.setFileInternal(null, true);
                this.suffixRotator.rotate(SecurityActions.getErrorManager(this.acc, this), file.toPath(), maxBackupIndex);
                this.setFileInternal(file, true);
            }
            catch (IOException e) {
                this.reportError("Unable to rotate log file", e, 4);
            }
        }
    }

    private void setFileInternal(File file, boolean doPrivileged) throws FileNotFoundException {
        if (System.getSecurityManager() == null || !doPrivileged) {
            super.setFile(file);
            if (this.outputStream != null) {
                this.outputStream.currentSize = file == null ? 0L : file.length();
            }
        } else {
            AccessController.doPrivileged(() -> {
                try {
                    super.setFile(file);
                    if (this.outputStream != null) {
                        this.outputStream.currentSize = file == null ? 0L : file.length();
                    }
                }
                catch (FileNotFoundException e) {
                    throw new UncheckedIOException(e);
                }
                return null;
            }, this.acc);
        }
    }
}

