/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;

public class GrantTypeCondition
extends AbstractClientPolicyConditionProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(GrantTypeCondition.class);

    public GrantTypeCondition(KeycloakSession session) {
        super(session);
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "client-scopes";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: {
                if (this.isGrantMatching((AuthorizationRequestContext)context)) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
            case TOKEN_REFRESH: {
                if (this.isGrantMatching("refresh_token")) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
            case RESOURCE_OWNER_PASSWORD_CREDENTIALS_REQUEST: {
                if (this.isGrantMatching("password")) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
            case SERVICE_ACCOUNT_TOKEN_REQUEST: {
                if (this.isGrantMatching("client_credentials")) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
            case TOKEN_EXCHANGE_REQUEST: {
                if (this.isGrantMatching("urn:ietf:params:oauth:grant-type:token-exchange")) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
            case DEVICE_TOKEN_REQUEST: {
                if (this.isGrantMatching("urn:ietf:params:oauth:grant-type:device_code")) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
            case JWT_AUTHORIZATION_GRANT: {
                if (this.isGrantMatching("urn:ietf:params:oauth:grant-type:jwt-bearer")) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private boolean isGrantMatching(AuthorizationRequestContext request) {
        if (request == null) {
            return false;
        }
        try {
            OIDCResponseType parsedResponseType = OIDCResponseType.parse(request.getAuthorizationEndpointRequest().getResponseType());
            if (parsedResponseType.hasResponseType("code")) {
                return this.isGrantMatching("authorization_code");
            }
            if (parsedResponseType.isImplicitFlow()) {
                return this.isGrantMatching("implicit");
            }
            if (parsedResponseType.isImplicitOrHybridFlow()) {
                return this.isGrantMatching("authorization_code") || this.isGrantMatching("implicit");
            }
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean isGrantMatching(String grantType) {
        return ((Configuration)this.configuration).getGrantTypes() != null && ((Configuration)this.configuration).getGrantTypes().contains(grantType);
    }

    public static class Configuration
    extends ClientPolicyConditionConfigurationRepresentation {
        @JsonProperty(value="grant_types")
        protected List<String> grantTypes;

        public List<String> getGrantTypes() {
            return this.grantTypes;
        }

        public void setGrantTypes(List<String> grantTypes) {
            this.grantTypes = grantTypes;
        }
    }
}

