/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health.checks;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

public class ThreadHealthCheck
implements HealthCheck {
    long maxThreadCount;
    private static final String THREAD_COUNT = "thread count";
    private static final String PEAK_THREAD_COUNT = "peak thread count";
    private static final String DAEMON_THREAD_COUNT = "daemon thread count";
    private static final String STARTED_THREAD_COUNT = "started thread count";
    private static final String DEADLOCKED_THREAD_COUNT = "deadlocked thread count";
    private static final String MONITOR_DEADLOCKED_THREAD_COUNT = "monitor deadlocked thread count";
    private static final String UNAVAILABLE = "Unavailable";

    public ThreadHealthCheck(long maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }

    public HealthCheckResponse call() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        HealthCheckResponseBuilder responseBuilder = HealthCheckResponse.named((String)"threads").withData("max thread count", this.maxThreadCount);
        this.addThreadCount(responseBuilder, threadMXBean);
        this.addPeakThreadCount(responseBuilder, threadMXBean);
        this.addDaemonThreadCount(responseBuilder, threadMXBean);
        this.addTotalStartedThreadCount(responseBuilder, threadMXBean);
        this.addDeadlockedThreads(responseBuilder, threadMXBean);
        this.addMonitorDeadlockedThreads(responseBuilder, threadMXBean);
        this.addStatus(responseBuilder, threadMXBean);
        return responseBuilder.build();
    }

    private void addStatus(HealthCheckResponseBuilder responseBuilder, ThreadMXBean threadMXBean) {
        int threadCount = -1;
        try {
            threadCount = threadMXBean.getThreadCount();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (threadCount > 0 && this.maxThreadCount > 0L) {
            boolean status = (long)threadCount < this.maxThreadCount;
            responseBuilder.status(status);
        } else {
            responseBuilder.up();
        }
    }

    private void addThreadCount(HealthCheckResponseBuilder responseBuilder, ThreadMXBean threadMXBean) {
        try {
            responseBuilder.withData(THREAD_COUNT, (long)threadMXBean.getThreadCount());
        }
        catch (Throwable t) {
            responseBuilder.withData(THREAD_COUNT, UNAVAILABLE);
        }
    }

    private void addPeakThreadCount(HealthCheckResponseBuilder responseBuilder, ThreadMXBean threadMXBean) {
        try {
            responseBuilder.withData(PEAK_THREAD_COUNT, (long)threadMXBean.getPeakThreadCount());
        }
        catch (Throwable t) {
            responseBuilder.withData(PEAK_THREAD_COUNT, UNAVAILABLE);
        }
    }

    private void addDaemonThreadCount(HealthCheckResponseBuilder responseBuilder, ThreadMXBean threadMXBean) {
        try {
            responseBuilder.withData(DAEMON_THREAD_COUNT, (long)threadMXBean.getDaemonThreadCount());
        }
        catch (Throwable t) {
            responseBuilder.withData(DAEMON_THREAD_COUNT, UNAVAILABLE);
        }
    }

    private void addTotalStartedThreadCount(HealthCheckResponseBuilder responseBuilder, ThreadMXBean threadMXBean) {
        try {
            responseBuilder.withData(STARTED_THREAD_COUNT, threadMXBean.getTotalStartedThreadCount());
        }
        catch (Throwable t) {
            responseBuilder.withData(STARTED_THREAD_COUNT, UNAVAILABLE);
        }
    }

    private void addDeadlockedThreads(HealthCheckResponseBuilder responseBuilder, ThreadMXBean threadMXBean) {
        try {
            long[] deadlockedThreads = threadMXBean.findDeadlockedThreads();
            responseBuilder.withData(DEADLOCKED_THREAD_COUNT, (long)this.getNumberOfThreads(deadlockedThreads));
        }
        catch (Throwable t) {
            responseBuilder.withData(DEADLOCKED_THREAD_COUNT, UNAVAILABLE);
        }
    }

    private void addMonitorDeadlockedThreads(HealthCheckResponseBuilder responseBuilder, ThreadMXBean threadMXBean) {
        try {
            long[] monitorDeadlockedThreads = threadMXBean.findMonitorDeadlockedThreads();
            responseBuilder.withData(MONITOR_DEADLOCKED_THREAD_COUNT, (long)this.getNumberOfThreads(monitorDeadlockedThreads));
        }
        catch (Throwable t) {
            responseBuilder.withData(MONITOR_DEADLOCKED_THREAD_COUNT, UNAVAILABLE);
        }
    }

    private int getNumberOfThreads(long[] ids) {
        if (ids == null) {
            return 0;
        }
        return ids.length;
    }
}

