/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.internal.jdwp;

import java.io.IOException;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Map;
import shadow.bundletool.com.android.ddmlib.AdbCommandRejectedException;
import shadow.bundletool.com.android.ddmlib.TimeoutException;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.JdwpClientManager;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.JdwpClientManagerId;

public class JdwpClientManagerFactory {
    private Map<JdwpClientManagerId, JdwpClientManager> myConnections = new HashMap<JdwpClientManagerId, JdwpClientManager>();
    Selector selector;

    public JdwpClientManagerFactory(Selector selector) {
        this.selector = selector;
    }

    public JdwpClientManager getConnection(String deviceId, int pid) {
        return this.myConnections.getOrDefault(new JdwpClientManagerId(deviceId, pid), null);
    }

    public JdwpClientManager createConnection(JdwpClientManagerId id5) throws AdbCommandRejectedException, TimeoutException, IOException {
        JdwpClientManager connection = this.myConnections.get(id5);
        if (connection == null) {
            connection = new JdwpClientManager(id5, this.selector);
            connection.addShutdownListener(() -> this.myConnections.remove(id5));
            this.myConnections.put(id5, connection);
        }
        return connection;
    }
}

