/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import org.stringtemplate.v4.AttributeRenderer;

public class StringRenderer
implements AttributeRenderer {
    public String toString(Object o15, String formatString, Locale locale) {
        String s15 = (String)o15;
        if (formatString == null) {
            return s15;
        }
        if (formatString.equals("upper")) {
            return s15.toUpperCase(locale);
        }
        if (formatString.equals("lower")) {
            return s15.toLowerCase(locale);
        }
        if (formatString.equals("cap")) {
            return s15.length() > 0 ? Character.toUpperCase(s15.charAt(0)) + s15.substring(1) : s15;
        }
        if (formatString.equals("url-encode")) {
            try {
                return URLEncoder.encode(s15, "UTF-8");
            }
            catch (UnsupportedEncodingException ex4) {
                // empty catch block
            }
        }
        if (formatString.equals("xml-encode")) {
            return StringRenderer.escapeHTML(s15);
        }
        return String.format(locale, formatString, s15);
    }

    public static String escapeHTML(String s15) {
        if (s15 == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(s15.length());
        int len = s15.length();
        block6: for (int i15 = 0; i15 < len; ++i15) {
            char c15 = s15.charAt(i15);
            switch (c15) {
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    buf.append(c15);
                    continue block6;
                }
                default: {
                    boolean aboveASCII;
                    boolean control = c15 < ' ';
                    boolean bl4 = aboveASCII = c15 > '~';
                    if (control || aboveASCII) {
                        buf.append("&#");
                        buf.append((int)c15);
                        buf.append(";");
                        continue block6;
                    }
                    buf.append(c15);
                }
            }
        }
        return buf.toString();
    }
}

