/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import org.fife.ui.rtextarea.FontUtil;

public class RtfGenerator {
    private Color mainBG;
    private List<Font> fontList;
    private List<Color> colorList;
    private StringBuilder document;
    private boolean lastWasControlWord;
    private int lastFontIndex;
    private int lastFGIndex;
    private boolean lastBold;
    private boolean lastItalic;
    private int lastFontSize;
    private int screenRes;
    private static final int DEFAULT_FONT_SIZE = 12;

    public RtfGenerator(Color mainBG) {
        this.mainBG = mainBG;
        this.fontList = new ArrayList<Font>(1);
        this.colorList = new ArrayList<Color>(1);
        this.document = new StringBuilder();
        this.reset();
    }

    public void appendNewline() {
        this.document.append("\\line");
        this.document.append('\n');
        this.lastWasControlWord = false;
    }

    public void appendToDoc(String text, Font f15, Color fg5, Color bg5) {
        this.appendToDoc(text, f15, fg5, bg5, false);
    }

    public void appendToDocNoFG(String text, Font f15, Color bg5, boolean underline) {
        this.appendToDoc(text, f15, null, bg5, underline, false);
    }

    public void appendToDoc(String text, Font f15, Color fg5, Color bg5, boolean underline) {
        this.appendToDoc(text, f15, fg5, bg5, underline, true);
    }

    public void appendToDoc(String text, Font f15, Color fg5, Color bg5, boolean underline, boolean setFG) {
        if (text != null) {
            int fontIndex;
            int n15 = fontIndex = f15 == null ? 0 : RtfGenerator.getFontIndex(this.fontList, f15) + 1;
            if (fontIndex != this.lastFontIndex) {
                this.document.append("\\f").append(fontIndex);
                this.lastFontIndex = fontIndex;
                this.lastWasControlWord = true;
            }
            if (f15 != null) {
                int fontSize = this.fixFontSize(f15.getSize2D() * 2.0f);
                if (fontSize != this.lastFontSize) {
                    this.document.append("\\fs").append(fontSize);
                    this.lastFontSize = fontSize;
                    this.lastWasControlWord = true;
                }
                if (f15.isBold() != this.lastBold) {
                    this.document.append(this.lastBold ? "\\b0" : "\\b");
                    this.lastBold = !this.lastBold;
                    this.lastWasControlWord = true;
                }
                if (f15.isItalic() != this.lastItalic) {
                    this.document.append(this.lastItalic ? "\\i0" : "\\i");
                    this.lastItalic = !this.lastItalic;
                    this.lastWasControlWord = true;
                }
            } else {
                if (this.lastFontSize != 12) {
                    this.document.append("\\fs").append(12);
                    this.lastFontSize = 12;
                    this.lastWasControlWord = true;
                }
                if (this.lastBold) {
                    this.document.append("\\b0");
                    this.lastBold = false;
                    this.lastWasControlWord = true;
                }
                if (this.lastItalic) {
                    this.document.append("\\i0");
                    this.lastItalic = false;
                    this.lastWasControlWord = true;
                }
            }
            if (underline) {
                this.document.append("\\ul");
                this.lastWasControlWord = true;
            }
            if (setFG) {
                int fgIndex = 0;
                if (fg5 != null) {
                    fgIndex = RtfGenerator.getColorIndex(this.colorList, fg5) + 1;
                }
                if (fgIndex != this.lastFGIndex) {
                    this.document.append("\\cf").append(fgIndex);
                    this.lastFGIndex = fgIndex;
                    this.lastWasControlWord = true;
                }
            }
            if (bg5 != null) {
                int pos = RtfGenerator.getColorIndex(this.colorList, bg5);
                this.document.append("\\highlight").append(pos + 1);
                this.lastWasControlWord = true;
            }
            if (this.lastWasControlWord) {
                this.document.append(' ');
                this.lastWasControlWord = false;
            }
            this.escapeAndAdd(this.document, text);
            if (bg5 != null) {
                this.document.append("\\highlight0");
                this.lastWasControlWord = true;
            }
            if (underline) {
                this.document.append("\\ul0");
                this.lastWasControlWord = true;
            }
        }
    }

    private void escapeAndAdd(StringBuilder sb5, String text) {
        int count = text.length();
        block4: for (int i15 = 0; i15 < count; ++i15) {
            char ch4 = text.charAt(i15);
            switch (ch4) {
                case '\t': {
                    sb5.append("\\tab");
                    while (++i15 < count && text.charAt(i15) == '\t') {
                        sb5.append("\\tab");
                    }
                    sb5.append(' ');
                    --i15;
                    continue block4;
                }
                case '\\': 
                case '{': 
                case '}': {
                    sb5.append('\\').append(ch4);
                    continue block4;
                }
                default: {
                    if (ch4 <= '\u007f') {
                        sb5.append(ch4);
                        continue block4;
                    }
                    sb5.append("\\u").append((int)ch4).append(' ');
                }
            }
        }
    }

    private int fixFontSize(float pointSize) {
        if (this.screenRes != 72) {
            pointSize = Math.round(pointSize * 72.0f / (float)this.screenRes);
        }
        return (int)pointSize;
    }

    private static int getColorIndex(List<Color> list2, Color item) {
        int pos = list2.indexOf(item);
        if (pos == -1) {
            list2.add(item);
            pos = list2.size() - 1;
        }
        return pos;
    }

    private String getColorTableRtf() {
        StringBuilder sb5 = new StringBuilder();
        sb5.append("{\\colortbl ;");
        for (Color c15 : this.colorList) {
            sb5.append("\\red").append(c15.getRed());
            sb5.append("\\green").append(c15.getGreen());
            sb5.append("\\blue").append(c15.getBlue());
            sb5.append(';');
        }
        sb5.append("}");
        return sb5.toString();
    }

    private static int getFontIndex(List<Font> list2, Font font) {
        String fontName = font.getFamily();
        for (int i15 = 0; i15 < list2.size(); ++i15) {
            Font font2 = list2.get(i15);
            if (!font2.getFamily().equals(fontName)) continue;
            return i15;
        }
        list2.add(font);
        return list2.size() - 1;
    }

    private String getFontTableRtf() {
        StringBuilder sb5 = new StringBuilder();
        String monoFamilyName = RtfGenerator.getMonospacedFontFamily();
        sb5.append("{\\fonttbl{\\f0\\fnil\\fcharset0 ").append(monoFamilyName).append(";}");
        for (int i15 = 0; i15 < this.fontList.size(); ++i15) {
            Font f15 = this.fontList.get(i15);
            String familyName = f15.getFamily();
            if (familyName.equals("Monospaced")) {
                familyName = monoFamilyName;
            }
            sb5.append("{\\f").append(i15 + 1).append("\\fnil\\fcharset0 ");
            sb5.append(familyName).append(";}");
        }
        sb5.append('}');
        return sb5.toString();
    }

    private static String getMonospacedFontFamily() {
        String family = FontUtil.getDefaultMonospacedFont().getFamily();
        if ("Monospaced".equals(family)) {
            family = "Courier";
        }
        return family;
    }

    public String getRtf() {
        int mainBGIndex = RtfGenerator.getColorIndex(this.colorList, this.mainBG);
        StringBuilder sb5 = new StringBuilder();
        sb5.append("{");
        sb5.append("\\rtf1\\ansi\\ansicpg1252");
        sb5.append("\\deff0");
        sb5.append("\\deflang1033");
        sb5.append("\\viewkind4");
        sb5.append("\\uc\\pard\\f0");
        sb5.append("\\fs20");
        sb5.append(this.getFontTableRtf()).append('\n');
        sb5.append(this.getColorTableRtf()).append('\n');
        int bgIndex = mainBGIndex + 1;
        sb5.append("\\cb").append(bgIndex).append(' ');
        this.lastWasControlWord = true;
        if (this.document.length() > 0) {
            this.document.append("\\line");
        }
        sb5.append((CharSequence)this.document);
        sb5.append("}");
        return sb5.toString();
    }

    public void reset() {
        this.fontList.clear();
        this.colorList.clear();
        this.document.setLength(0);
        this.lastWasControlWord = false;
        this.lastFontIndex = 0;
        this.lastFGIndex = 0;
        this.lastBold = false;
        this.lastItalic = false;
        this.lastFontSize = 12;
        this.screenRes = GraphicsEnvironment.isHeadless() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
    }
}

