/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.html.HTMLDocument;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rsyntaxtextarea.HtmlUtil;

final class TipUtil {
    private TipUtil() {
    }

    public static Color getToolTipBackground() {
        Color c15 = UIManager.getColor("ToolTip.background");
        boolean isNimbus = TipUtil.isNimbusLookAndFeel();
        if ((c15 == null || isNimbus) && ((c15 = UIManager.getColor("info")) == null || isNimbus && TipUtil.isDerivedColor(c15))) {
            c15 = SystemColor.info;
        }
        if (c15 instanceof ColorUIResource) {
            c15 = new Color(c15.getRGB());
        }
        return c15;
    }

    public static Border getToolTipBorder() {
        Border border = UIManager.getBorder("ToolTip.border");
        if ((border == null || TipUtil.isNimbusLookAndFeel()) && (border = UIManager.getBorder("nimbusBorder")) == null) {
            border = BorderFactory.createLineBorder(SystemColor.controlDkShadow);
        }
        return border;
    }

    static Color getToolTipHyperlinkForeground() {
        Color fg5 = UIManager.getColor("ToolTip.foreground");
        if (fg5 == null || TipUtil.isNimbusLookAndFeel()) {
            fg5 = new JToolTip().getForeground();
        }
        return Util.isLightForeground(fg5) ? Util.LIGHT_HYPERLINK_FG : Color.blue;
    }

    private static boolean isDerivedColor(Color c15) {
        return c15 != null && (c15.getClass().getName().endsWith(".DerivedColor") || c15.getClass().getName().endsWith(".DerivedColor$UIResource"));
    }

    private static boolean isNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getName().equals("Nimbus");
    }

    public static void tweakTipEditorPane(JEditorPane textArea) {
        boolean isNimbus = TipUtil.isNimbusLookAndFeel();
        if (isNimbus) {
            Color selBG = textArea.getSelectionColor();
            Color selFG = textArea.getSelectedTextColor();
            textArea.setUI(new BasicEditorPaneUI());
            textArea.setSelectedTextColor(selFG);
            textArea.setSelectionColor(selBG);
        }
        textArea.setEditable(false);
        textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        textArea.getCaret().setSelectionVisible(true);
        Color fg5 = UIManager.getColor("ToolTip.foreground");
        if (fg5 == null) {
            fg5 = UIManager.getColor("Label.foreground");
        }
        if (fg5 == null || isNimbus && TipUtil.isDerivedColor(fg5)) {
            fg5 = SystemColor.textText;
        }
        textArea.setForeground(fg5);
        textArea.setBackground(TipUtil.getToolTipBackground());
        Font font = UIManager.getFont("Label.font");
        if (font == null) {
            font = new Font("SansSerif", 0, 12);
        }
        HTMLDocument doc = (HTMLDocument)textArea.getDocument();
        doc.getStyleSheet().addRule("body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; color: " + HtmlUtil.getHexString(fg5) + "; }");
        Color linkFG = TipUtil.getToolTipHyperlinkForeground();
        doc.getStyleSheet().addRule("a { color: " + HtmlUtil.getHexString(linkFG) + "; }");
        URL url = TipUtil.class.getResource("bullet_black.png");
        if (url != null) {
            doc.getStyleSheet().addRule("ul { list-style-image: '" + url + "'; }");
        }
    }
}

