/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.section;

import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.section.SectionCodeAreaStructure;
import org.exbin.bined.section.layout.PositionIterator;
import org.exbin.bined.section.layout.SectionCodeAreaLayoutProfile;
import org.exbin.bined.swing.basic.BasicCodeAreaMetrics;
import org.exbin.bined.swing.section.SectionCodeAreaDimensions;
import org.exbin.bined.swing.section.SectionCodeAreaScrolling;

@ParametersAreNonnullByDefault
public class SectionCodeAreaVisibility {
    protected int splitLinePos;
    protected int skipTo;
    protected int skipToChar;
    protected int skipRestFrom;
    protected int skipRestFromChar;
    protected boolean codeSectionVisible;
    protected boolean previewSectionVisible;
    protected int codeLastCharPos;
    protected int previewCharPos;

    public void recomputeCharPositions(BasicCodeAreaMetrics metrics, SectionCodeAreaStructure structure, SectionCodeAreaDimensions dimensions, SectionCodeAreaLayoutProfile layout, SectionCodeAreaScrolling scrolling) {
        int bytesPerRow = structure.getBytesPerRow();
        int characterWidth = metrics.getCharacterWidth();
        int charsPerByte = structure.getCodeType().getMaxDigitsForByte() + 1;
        int halfSpaceWidth = characterWidth / 2;
        CodeAreaViewMode viewMode = structure.getViewMode();
        int invisibleFromLeftX = scrolling.getHorizontalScrollX(characterWidth);
        int invisibleFromRightX = invisibleFromLeftX + dimensions.getDataViewWidth();
        this.codeLastCharPos = viewMode != CodeAreaViewMode.TEXT_PREVIEW ? bytesPerRow * charsPerByte - 1 : 0;
        this.previewCharPos = viewMode == CodeAreaViewMode.DUAL ? bytesPerRow * charsPerByte : 0;
        this.skipTo = 0;
        this.skipToChar = 0;
        this.skipRestFrom = -1;
        this.skipRestFromChar = -1;
        this.codeSectionVisible = viewMode != CodeAreaViewMode.TEXT_PREVIEW;
        this.previewSectionVisible = viewMode != CodeAreaViewMode.CODE_MATRIX;
        int linePos = 0;
        PositionIterator positionIterator = layout.createPositionIterator(structure.getCodeType(), structure.getViewMode(), structure.getBytesPerRow());
        int halfCharPos = 0;
        while (!positionIterator.isEndReached()) {
            int positionX;
            int nextSpaceSize = positionIterator.nextSpaceType().getHalfCharSize();
            if (viewMode == CodeAreaViewMode.DUAL && positionIterator.getBytePosition() == 0 && positionIterator.getSection() == BasicCodeAreaSection.TEXT_PREVIEW) {
                linePos = layout.computePositionX(halfCharPos + 2, characterWidth, halfSpaceWidth) + layout.computePositionX(nextSpaceSize, characterWidth, halfSpaceWidth) / 2;
            }
            if ((positionX = layout.computePositionX(halfCharPos += 2 + nextSpaceSize, characterWidth, halfSpaceWidth)) < invisibleFromLeftX) {
                ++this.skipTo;
                this.skipToChar = positionIterator.getHalfCharPosition() / 2;
                if (positionIterator.getSection() != BasicCodeAreaSection.TEXT_PREVIEW && !positionIterator.isEndReached()) continue;
                this.codeSectionVisible = false;
                continue;
            }
            if (this.skipRestFrom != -1 || positionX <= invisibleFromRightX) continue;
            this.skipRestFrom = positionIterator.getPosition();
            this.skipRestFromChar = (positionIterator.getHalfCharPosition() + 1) / 2;
            if (viewMode != CodeAreaViewMode.DUAL && positionIterator.getSection() != BasicCodeAreaSection.CODE_MATRIX) continue;
            this.previewSectionVisible = false;
        }
        if (this.skipRestFromChar == -1) {
            this.skipRestFromChar = (positionIterator.getHalfCharPosition() + 1) / 2;
        }
        this.splitLinePos = linePos;
    }

    public int getSplitLinePos() {
        return this.splitLinePos;
    }

    public int getSkipTo() {
        return this.skipTo;
    }

    public int getSkipToChar() {
        return this.skipToChar;
    }

    public int getSkipRestFrom() {
        return this.skipRestFrom;
    }

    public int getSkipRestFromChar() {
        return this.skipRestFromChar;
    }

    public boolean isCodeSectionVisible() {
        return this.codeSectionVisible;
    }

    public boolean isPreviewSectionVisible() {
        return this.previewSectionVisible;
    }

    public int getMaxRowDataChars() {
        return this.skipRestFromChar - this.skipToChar;
    }

    public int getCodeLastCharPos() {
        return this.codeLastCharPos;
    }

    public int getPreviewCharPos() {
        return this.previewCharPos;
    }
}

