/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.basic.BasicCodeAreaLayout;
import org.exbin.bined.basic.BasicCodeAreaScrolling;
import org.exbin.bined.basic.BasicCodeAreaStructure;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.swing.basic.BasicCodeAreaDimensions;
import org.exbin.bined.swing.basic.BasicCodeAreaMetrics;

@ParametersAreNonnullByDefault
public class BasicCodeAreaVisibility {
    protected int splitLinePos;
    protected int skipToCode;
    protected int skipToChar;
    protected int skipToPreview;
    protected int skipRestFromCode;
    protected int skipRestFromChar;
    protected int skipRestFromPreview;
    protected boolean codeSectionVisible;
    protected boolean previewSectionVisible;
    protected int charactersPerCodeSection;
    protected int codeLastCharPos;
    protected int previewCharPos;
    protected int previewRelativeX;

    public void recomputeCharPositions(BasicCodeAreaMetrics metrics, BasicCodeAreaStructure structure, BasicCodeAreaDimensions dimensions, BasicCodeAreaLayout layout, BasicCodeAreaScrolling scrolling) {
        int bytesPerRow = structure.getBytesPerRow();
        int characterWidth = metrics.getCharacterWidth();
        int charsPerByte = structure.getCodeType().getMaxDigitsForByte() + 1;
        CodeAreaViewMode viewMode = structure.getViewMode();
        int invisibleFromLeftX = scrolling.getHorizontalScrollX(characterWidth);
        int invisibleFromRightX = invisibleFromLeftX + dimensions.getDataViewWidth();
        this.charactersPerCodeSection = layout.computeFirstCodeCharacterPos(structure, bytesPerRow);
        this.codeLastCharPos = viewMode != CodeAreaViewMode.TEXT_PREVIEW ? bytesPerRow * charsPerByte - 1 : 0;
        this.previewCharPos = viewMode == CodeAreaViewMode.DUAL ? bytesPerRow * charsPerByte : 0;
        this.previewRelativeX = this.previewCharPos * characterWidth;
        this.skipToCode = 0;
        this.skipToChar = 0;
        this.skipToPreview = 0;
        this.skipRestFromCode = -1;
        this.skipRestFromChar = -1;
        this.skipRestFromPreview = -1;
        this.codeSectionVisible = viewMode != CodeAreaViewMode.TEXT_PREVIEW;
        boolean bl4 = this.previewSectionVisible = viewMode != CodeAreaViewMode.CODE_MATRIX;
        if (viewMode == CodeAreaViewMode.DUAL || viewMode == CodeAreaViewMode.CODE_MATRIX) {
            this.skipToChar = invisibleFromLeftX / characterWidth;
            if (this.skipToChar < 0) {
                this.skipToChar = 0;
            }
            this.skipRestFromChar = (invisibleFromRightX + characterWidth - 1) / characterWidth;
            if (this.skipRestFromChar > structure.getCharactersPerRow()) {
                this.skipRestFromChar = structure.getCharactersPerRow();
            }
            this.skipToCode = structure.computePositionByte(this.skipToChar);
            this.skipRestFromCode = structure.computePositionByte(this.skipRestFromChar - 1) + 1;
            if (this.skipRestFromCode > bytesPerRow) {
                this.skipRestFromCode = bytesPerRow;
            }
        }
        if (viewMode == CodeAreaViewMode.DUAL || viewMode == CodeAreaViewMode.TEXT_PREVIEW) {
            this.skipToPreview = invisibleFromLeftX / characterWidth - this.previewCharPos;
            if (this.skipToPreview < 0) {
                this.skipToPreview = 0;
            }
            if (this.skipToPreview > 0) {
                this.skipToChar = this.skipToPreview + this.previewCharPos;
            }
            this.skipRestFromPreview = (invisibleFromRightX + characterWidth - 1) / characterWidth - this.previewCharPos;
            if (this.skipRestFromPreview > bytesPerRow) {
                this.skipRestFromPreview = bytesPerRow;
            }
            if (this.skipRestFromPreview >= 0) {
                this.skipRestFromChar = this.skipRestFromPreview + this.previewCharPos;
            }
        }
    }

    public int getSplitLinePos() {
        return this.splitLinePos;
    }

    public int getSkipToCode() {
        return this.skipToCode;
    }

    public int getSkipToChar() {
        return this.skipToChar;
    }

    public int getSkipToPreview() {
        return this.skipToPreview;
    }

    public int getSkipRestFromCode() {
        return this.skipRestFromCode;
    }

    public int getSkipRestFromChar() {
        return this.skipRestFromChar;
    }

    public int getSkipRestFromPreview() {
        return this.skipRestFromPreview;
    }

    public boolean isCodeSectionVisible() {
        return this.codeSectionVisible;
    }

    public boolean isPreviewSectionVisible() {
        return this.previewSectionVisible;
    }

    public int getMaxRowDataChars() {
        return this.skipRestFromChar - this.skipToChar;
    }

    public int getCharactersPerCodeSection() {
        return this.charactersPerCodeSection;
    }

    public int getCodeLastCharPos() {
        return this.codeLastCharPos;
    }

    public int getPreviewCharPos() {
        return this.previewCharPos;
    }

    public int getPreviewRelativeX() {
        return this.previewRelativeX;
    }
}

