/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.highlight.swing;

import java.awt.Color;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.color.CodeAreaBasicColors;
import org.exbin.bined.highlight.swing.color.CodeAreaColorizationColorType;
import org.exbin.bined.swing.CodeAreaColorAssessor;
import org.exbin.bined.swing.CodeAreaPaintState;
import org.exbin.bined.swing.basic.color.CodeAreaColorsProfile;

@ParametersAreNonnullByDefault
public class NonAsciiCodeAreaColorAssessor
implements CodeAreaColorAssessor {
    protected final CodeAreaColorAssessor parentAssessor;
    @Nullable
    protected Color controlCodesColor;
    @Nullable
    protected Color controlCodesBackground;
    @Nullable
    protected Color upperCodesColor;
    @Nullable
    protected Color upperCodesBackground;
    @Nullable
    protected Color textColor;
    protected boolean nonAsciiHighlightingEnabled = true;
    protected long dataSize;
    protected BinaryData contentData;

    public NonAsciiCodeAreaColorAssessor(@Nullable CodeAreaColorAssessor parentAssessor) {
        this.parentAssessor = parentAssessor;
    }

    @Override
    public void startPaint(CodeAreaPaintState codeAreaPaintState) {
        CodeAreaColorsProfile colorsProfile = codeAreaPaintState.getColorsProfile();
        this.dataSize = codeAreaPaintState.getDataSize();
        this.contentData = codeAreaPaintState.getContentData();
        this.textColor = colorsProfile.getColor(CodeAreaBasicColors.TEXT_COLOR);
        if (this.textColor == null) {
            this.textColor = Color.BLACK;
        }
        this.controlCodesColor = colorsProfile.getColor(CodeAreaColorizationColorType.CONTROL_CODES_COLOR);
        if (this.controlCodesColor == null) {
            int controlCodesRed = this.textColor.getRed();
            int controlCodesRedDiff = 0;
            if (controlCodesRed > 32) {
                if (controlCodesRed > 192) {
                    controlCodesRedDiff = controlCodesRed - 192;
                }
                controlCodesRed = 255;
            } else {
                controlCodesRed += 224;
            }
            int controlCodesBlue = this.textColor.getBlue();
            int controlCodesBlueDiff = 0;
            if (controlCodesBlue > 32) {
                if (controlCodesBlue > 192) {
                    controlCodesBlueDiff = controlCodesBlue - 192;
                }
                controlCodesBlue = 255;
            } else {
                controlCodesBlue += 224;
            }
            this.controlCodesColor = new Color(controlCodesRed, NonAsciiCodeAreaColorAssessor.downShift(this.textColor.getGreen(), controlCodesBlueDiff + controlCodesRedDiff), controlCodesBlue);
        }
        this.controlCodesBackground = colorsProfile.getColor(CodeAreaColorizationColorType.CONTROL_CODES_BACKGROUND);
        this.upperCodesColor = colorsProfile.getColor(CodeAreaColorizationColorType.UPPER_CODES_COLOR);
        if (this.upperCodesColor == null) {
            int upperCodesGreen = this.textColor.getGreen();
            int upperCodesGreenDiff = 0;
            if (upperCodesGreen > 64) {
                if (upperCodesGreen > 192) {
                    upperCodesGreenDiff = upperCodesGreen - 192;
                }
                upperCodesGreen = 255;
            } else {
                upperCodesGreen += 192;
            }
            int upperCodesBlue = this.textColor.getBlue();
            int upperCodesBlueDiff = 0;
            if (upperCodesBlue > 64) {
                if (upperCodesBlue > 192) {
                    upperCodesBlueDiff = upperCodesBlue - 192;
                }
                upperCodesBlue = 255;
            } else {
                upperCodesBlue += 192;
            }
            this.upperCodesColor = new Color(NonAsciiCodeAreaColorAssessor.downShift(this.textColor.getRed(), upperCodesGreenDiff + upperCodesBlueDiff), upperCodesGreen, upperCodesBlue);
        }
        this.upperCodesBackground = colorsProfile.getColor(CodeAreaColorizationColorType.UPPER_CODES_BACKGROUND);
        if (this.parentAssessor != null) {
            this.parentAssessor.startPaint(codeAreaPaintState);
        }
    }

    @Override
    @Nullable
    public Color getPositionTextColor(long rowDataPosition, int byteOnRow, int charOnRow, @Nonnull CodeAreaSection section, boolean inSelection) {
        long dataPosition;
        Color color;
        Color color2 = color = this.parentAssessor != null ? this.parentAssessor.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection) : null;
        if (this.nonAsciiHighlightingEnabled && section == BasicCodeAreaSection.CODE_MATRIX && (color == null || color.equals(this.textColor)) && (dataPosition = rowDataPosition + (long)byteOnRow) < this.dataSize) {
            byte value = this.contentData.getByte(dataPosition);
            if (value < 0) {
                color = this.upperCodesColor;
            } else if (value < 32) {
                color = this.controlCodesColor;
            }
        }
        return color;
    }

    @Override
    @Nullable
    public Color getPositionBackgroundColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean inSelection) {
        long dataPosition;
        Color color;
        Color color2 = color = this.parentAssessor != null ? this.parentAssessor.getPositionBackgroundColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection) : null;
        if ((this.upperCodesBackground != null || this.controlCodesBackground != null) && this.nonAsciiHighlightingEnabled && section == BasicCodeAreaSection.CODE_MATRIX && (color == null || color.equals(this.textColor)) && (dataPosition = rowDataPosition + (long)byteOnRow) < this.dataSize) {
            byte value = this.contentData.getByte(dataPosition);
            if (this.upperCodesBackground != null && value < 0) {
                color = this.upperCodesBackground;
            } else if (this.controlCodesBackground != null && value < 32) {
                color = this.controlCodesBackground;
            }
        }
        return color;
    }

    @Override
    @Nonnull
    public Optional<CodeAreaColorAssessor> getParentColorAssessor() {
        return Optional.ofNullable(this.parentAssessor);
    }

    public boolean isNonAsciiHighlightingEnabled() {
        return this.nonAsciiHighlightingEnabled;
    }

    public void setNonAsciiHighlightingEnabled(boolean nonAsciiHighlightingEnabled) {
        this.nonAsciiHighlightingEnabled = nonAsciiHighlightingEnabled;
    }

    protected static int downShift(int color, int diff) {
        if (color < diff) {
            return 0;
        }
        return color - diff;
    }
}

