/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.build.AbstractStreamBuilder;

public class ProxyOutputStream
extends FilterOutputStream {
    ProxyOutputStream(Builder builder) throws IOException {
        super(builder.getOutputStream());
    }

    public ProxyOutputStream(OutputStream delegate2) {
        super(delegate2);
    }

    protected void afterWrite(int n15) throws IOException {
    }

    protected void beforeWrite(int n15) throws IOException {
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.out, this::handleIOException);
    }

    @Override
    public void flush() throws IOException {
        try {
            this.out.flush();
        }
        catch (IOException e15) {
            this.handleIOException(e15);
        }
    }

    protected void handleIOException(IOException e15) throws IOException {
        throw e15;
    }

    public ProxyOutputStream setReference(OutputStream out) {
        this.out = out;
        return this;
    }

    OutputStream unwrap() {
        return this.out;
    }

    @Override
    public void write(byte[] b15) throws IOException {
        try {
            int len = IOUtils.length(b15);
            this.beforeWrite(len);
            this.out.write(b15);
            this.afterWrite(len);
        }
        catch (IOException e15) {
            this.handleIOException(e15);
        }
    }

    @Override
    public void write(byte[] b15, int off, int len) throws IOException {
        try {
            this.beforeWrite(len);
            this.out.write(b15, off, len);
            this.afterWrite(len);
        }
        catch (IOException e15) {
            this.handleIOException(e15);
        }
    }

    @Override
    public void write(int b15) throws IOException {
        try {
            this.beforeWrite(1);
            this.out.write(b15);
            this.afterWrite(1);
        }
        catch (IOException e15) {
            this.handleIOException(e15);
        }
    }

    public void writeRepeat(byte[] b15, int off, int len, long repeat) throws IOException {
        long remains = repeat;
        while (remains-- > 0L) {
            this.write(b15, off, len);
        }
    }

    public void writeRepeat(byte[] b15, long repeat) throws IOException {
        long remains = repeat;
        while (remains-- > 0L) {
            this.write(b15);
        }
    }

    public void writeRepeat(int b15, long repeat) throws IOException {
        long remains = repeat;
        while (remains-- > 0L) {
            this.write(b15);
        }
    }

    public static class Builder
    extends AbstractStreamBuilder<ProxyOutputStream, Builder> {
        @Override
        public ProxyOutputStream get() throws IOException {
            return new ProxyOutputStream(this);
        }
    }
}

