/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Comparator;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.AnnotationArgumentsRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererModifier;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.Nullable;

public class MemberComparator
implements Comparator<DeclarationDescriptor> {
    public static final MemberComparator INSTANCE = new MemberComparator();
    private static final DescriptorRenderer RENDERER = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)new Function1<DescriptorRendererOptions, Unit>(){

        @Override
        public Unit invoke(DescriptorRendererOptions options) {
            options.setWithDefinedIn(false);
            options.setVerbose(true);
            options.setAnnotationArgumentsRenderingPolicy(AnnotationArgumentsRenderingPolicy.UNLESS_EMPTY);
            options.setModifiers(DescriptorRendererModifier.ALL);
            return Unit.INSTANCE;
        }
    });

    private MemberComparator() {
    }

    @Override
    public int compare(DeclarationDescriptor o15, DeclarationDescriptor o25) {
        int renderDiff;
        Integer typeAndNameCompareResult = NameAndTypeMemberComparator.compareInternal(o15, o25);
        if (typeAndNameCompareResult != null) {
            return typeAndNameCompareResult;
        }
        if (o15 instanceof TypeAliasDescriptor && o25 instanceof TypeAliasDescriptor) {
            String r25;
            TypeAliasDescriptor ta12 = (TypeAliasDescriptor)o15;
            TypeAliasDescriptor ta22 = (TypeAliasDescriptor)o25;
            String r15 = RENDERER.renderType(ta12.getUnderlyingType());
            int underlyingTypesCompareTo = r15.compareTo(r25 = RENDERER.renderType(ta22.getUnderlyingType()));
            if (underlyingTypesCompareTo != 0) {
                return underlyingTypesCompareTo;
            }
        } else if (o15 instanceof CallableDescriptor && o25 instanceof CallableDescriptor) {
            String r26;
            String r16;
            int receiversCompareTo;
            CallableDescriptor c15 = (CallableDescriptor)o15;
            CallableDescriptor c25 = (CallableDescriptor)o25;
            ReceiverParameterDescriptor c1ReceiverParameter = c15.getExtensionReceiverParameter();
            ReceiverParameterDescriptor c2ReceiverParameter = c25.getExtensionReceiverParameter();
            assert (c1ReceiverParameter != null == (c2ReceiverParameter != null));
            if (c1ReceiverParameter != null && (receiversCompareTo = (r16 = RENDERER.renderType(c1ReceiverParameter.getType())).compareTo(r26 = RENDERER.renderType(c2ReceiverParameter.getType()))) != 0) {
                return receiversCompareTo;
            }
            List<ValueParameterDescriptor> c1ValueParameters = c15.getValueParameters();
            List<ValueParameterDescriptor> c2ValueParameters = c25.getValueParameters();
            for (int i15 = 0; i15 < Math.min(c1ValueParameters.size(), c2ValueParameters.size()); ++i15) {
                String p25;
                String p15 = RENDERER.renderType(c1ValueParameters.get(i15).getType());
                int parametersCompareTo = p15.compareTo(p25 = RENDERER.renderType(c2ValueParameters.get(i15).getType()));
                if (parametersCompareTo == 0) continue;
                return parametersCompareTo;
            }
            int valueParametersNumberCompareTo = c1ValueParameters.size() - c2ValueParameters.size();
            if (valueParametersNumberCompareTo != 0) {
                return valueParametersNumberCompareTo;
            }
            List<TypeParameterDescriptor> c1TypeParameters = c15.getTypeParameters();
            List<TypeParameterDescriptor> c2TypeParameters = c25.getTypeParameters();
            for (int i16 = 0; i16 < Math.min(c1TypeParameters.size(), c2TypeParameters.size()); ++i16) {
                List<KotlinType> c1Bounds = c1TypeParameters.get(i16).getUpperBounds();
                List<KotlinType> c2Bounds = c2TypeParameters.get(i16).getUpperBounds();
                int boundsCountCompareTo = c1Bounds.size() - c2Bounds.size();
                if (boundsCountCompareTo != 0) {
                    return boundsCountCompareTo;
                }
                for (int j15 = 0; j15 < c1Bounds.size(); ++j15) {
                    String b25;
                    String b15 = RENDERER.renderType(c1Bounds.get(j15));
                    int boundCompareTo = b15.compareTo(b25 = RENDERER.renderType(c2Bounds.get(j15)));
                    if (boundCompareTo == 0) continue;
                    return boundCompareTo;
                }
            }
            int typeParametersCompareTo = c1TypeParameters.size() - c2TypeParameters.size();
            if (typeParametersCompareTo != 0) {
                return typeParametersCompareTo;
            }
            if (c15 instanceof CallableMemberDescriptor && c25 instanceof CallableMemberDescriptor) {
                CallableMemberDescriptor.Kind c1Kind = ((CallableMemberDescriptor)c15).getKind();
                CallableMemberDescriptor.Kind c2Kind = ((CallableMemberDescriptor)c25).getKind();
                int kindsCompareTo = c1Kind.ordinal() - c2Kind.ordinal();
                if (kindsCompareTo != 0) {
                    return kindsCompareTo;
                }
            }
        } else if (o15 instanceof ClassDescriptor && o25 instanceof ClassDescriptor) {
            ClassDescriptor class1 = (ClassDescriptor)o15;
            ClassDescriptor class2 = (ClassDescriptor)o25;
            if (class1.getKind().ordinal() != class2.getKind().ordinal()) {
                return class1.getKind().ordinal() - class2.getKind().ordinal();
            }
            if (class1.isCompanionObject() != class2.isCompanionObject()) {
                return class1.isCompanionObject() ? 1 : -1;
            }
        } else {
            throw new AssertionError((Object)String.format("Unsupported pair of descriptors:\n'%s' Class: %s\n%s' Class: %s", o15, o15.getClass(), o25, o25.getClass()));
        }
        if ((renderDiff = RENDERER.render(o15).compareTo(RENDERER.render(o25))) != 0) {
            return renderDiff;
        }
        Name firstModuleName = DescriptorUtils.getContainingModule(o15).getName();
        Name secondModuleName = DescriptorUtils.getContainingModule(o25).getName();
        return firstModuleName.compareTo(secondModuleName);
    }

    public static class NameAndTypeMemberComparator
    implements Comparator<DeclarationDescriptor> {
        public static final NameAndTypeMemberComparator INSTANCE = new NameAndTypeMemberComparator();

        private NameAndTypeMemberComparator() {
        }

        private static int getDeclarationPriority(DeclarationDescriptor descriptor2) {
            if (DescriptorUtils.isEnumEntry(descriptor2)) {
                return 8;
            }
            if (descriptor2 instanceof ConstructorDescriptor) {
                return 7;
            }
            if (descriptor2 instanceof PropertyDescriptor) {
                if (((PropertyDescriptor)descriptor2).getExtensionReceiverParameter() == null) {
                    return 6;
                }
                return 5;
            }
            if (descriptor2 instanceof FunctionDescriptor) {
                if (((FunctionDescriptor)descriptor2).getExtensionReceiverParameter() == null) {
                    return 4;
                }
                return 3;
            }
            if (descriptor2 instanceof ClassDescriptor) {
                return 2;
            }
            if (descriptor2 instanceof TypeAliasDescriptor) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compare(DeclarationDescriptor o15, DeclarationDescriptor o25) {
            Integer compareInternal = NameAndTypeMemberComparator.compareInternal(o15, o25);
            return compareInternal != null ? compareInternal : 0;
        }

        @Nullable
        private static Integer compareInternal(DeclarationDescriptor o15, DeclarationDescriptor o25) {
            int prioritiesCompareTo = NameAndTypeMemberComparator.getDeclarationPriority(o25) - NameAndTypeMemberComparator.getDeclarationPriority(o15);
            if (prioritiesCompareTo != 0) {
                return prioritiesCompareTo;
            }
            if (DescriptorUtils.isEnumEntry(o15) && DescriptorUtils.isEnumEntry(o25)) {
                return 0;
            }
            int namesCompareTo = o15.getName().compareTo(o25.getName());
            if (namesCompareTo != 0) {
                return namesCompareTo;
            }
            return null;
        }
    }
}

