/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.search.providers;

import jadx.api.resources.ResourceContentType;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.InvalidDataException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class ResourceFilter {
    private static final ResourceFilter ANY = new ResourceFilter(Set.of(), Set.of());
    private static final String VAR_TEXT = "$TEXT";
    private static final String VAR_BIN = "$BIN";
    public static final String DEFAULT_STR = "$TEXT";
    private final boolean anyFile;
    private final Set<ResourceContentType> contentTypes;
    private final Set<String> extSet;

    public static ResourceFilter parse(String filterStr) {
        String[] parts;
        String str = filterStr.trim();
        if (str.isEmpty() || str.equals("*")) {
            return ANY;
        }
        EnumSet<ResourceContentType> contentTypes = EnumSet.noneOf(ResourceContentType.class);
        LinkedHashSet<String> extSet = new LinkedHashSet<String>();
        for (String part : parts = filterStr.split("[|, ]")) {
            if (part.isEmpty()) continue;
            if (part.startsWith("$")) {
                switch (part) {
                    case "$TEXT": {
                        contentTypes.add(ResourceContentType.CONTENT_TEXT);
                        break;
                    }
                    case "$BIN": {
                        contentTypes.add(ResourceContentType.CONTENT_BINARY);
                        break;
                    }
                    default: {
                        throw new InvalidDataException("Unknown var name: " + part);
                    }
                }
                continue;
            }
            extSet.add(part);
        }
        return new ResourceFilter(contentTypes, extSet);
    }

    public static String format(ResourceFilter filter) {
        if (filter.isAnyFile()) {
            return "*";
        }
        ArrayList<String> list2 = new ArrayList<String>();
        Set<ResourceContentType> types = filter.getContentTypes();
        if (types.contains((Object)ResourceContentType.CONTENT_TEXT)) {
            list2.add("$TEXT");
        }
        if (types.contains((Object)ResourceContentType.CONTENT_BINARY)) {
            list2.add(VAR_BIN);
        }
        list2.addAll(filter.getExtSet());
        return Utils.listToString(list2, "|");
    }

    public static String withContentType(String filterStr, Set<ResourceContentType> contentTypes) {
        ResourceFilter filter = ResourceFilter.parse(filterStr);
        return ResourceFilter.format(new ResourceFilter(contentTypes, filter.getExtSet()));
    }

    private ResourceFilter(Set<ResourceContentType> contentTypes, Set<String> extSet) {
        this.anyFile = contentTypes.isEmpty() && extSet.isEmpty();
        this.contentTypes = contentTypes.isEmpty() ? Set.of() : contentTypes;
        this.extSet = extSet.isEmpty() ? Set.of() : extSet;
    }

    public boolean isAnyFile() {
        return this.anyFile;
    }

    public Set<ResourceContentType> getContentTypes() {
        return this.contentTypes;
    }

    public Set<String> getExtSet() {
        return this.extSet;
    }

    public String toString() {
        return ResourceFilter.format(this);
    }
}

