/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocks;

import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.EmptyBitSet;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class DominatorTree {
    public static void compute(MethodNode mth) {
        List<BlockNode> sorted2 = DominatorTree.sortBlocks(mth);
        BlockNode[] doms = DominatorTree.build(sorted2, BlockNode::getPredecessors);
        DominatorTree.apply(sorted2, doms);
    }

    private static List<BlockNode> sortBlocks(MethodNode mth) {
        int blocksCount = mth.getBasicBlocks().size();
        ArrayList<BlockNode> sorted2 = new ArrayList<BlockNode>(blocksCount);
        BlockUtils.visitDFS(mth, sorted2::add);
        if (sorted2.size() != blocksCount) {
            throw new JadxRuntimeException("Found unreachable blocks");
        }
        mth.setBasicBlocks(sorted2);
        return sorted2;
    }

    static BlockNode[] build(List<BlockNode> sorted2, Function<BlockNode, List<BlockNode>> predFunc) {
        int blocksCount = sorted2.size();
        BlockNode[] doms = new BlockNode[blocksCount];
        doms[0] = sorted2.get(0);
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int blockId = 1; blockId < blocksCount; ++blockId) {
                BlockNode b15 = sorted2.get(blockId);
                List<BlockNode> preds = predFunc.apply(b15);
                int pickedPred = -1;
                BlockNode newIDom = null;
                for (BlockNode pred : preds) {
                    int id5 = pred.getId();
                    if (doms[id5] == null) continue;
                    newIDom = pred;
                    pickedPred = id5;
                    break;
                }
                if (newIDom == null) {
                    throw new JadxRuntimeException("No immediate dominator for block: " + String.valueOf(b15));
                }
                for (BlockNode predBlock : preds) {
                    int predId = predBlock.getId();
                    if (predId == pickedPred || doms[predId] == null) continue;
                    newIDom = DominatorTree.intersect(sorted2, doms, predBlock, newIDom);
                }
                if (doms[blockId] == newIDom) continue;
                doms[blockId] = newIDom;
                changed = true;
            }
        }
        return doms;
    }

    private static BlockNode intersect(List<BlockNode> sorted2, BlockNode[] doms, BlockNode b15, BlockNode b25) {
        int f15 = b15.getId();
        int f25 = b25.getId();
        while (f15 != f25) {
            while (f15 > f25) {
                f15 = doms[f15].getId();
            }
            while (f25 > f15) {
                f25 = doms[f25].getId();
            }
        }
        return sorted2.get(f15);
    }

    private static void apply(List<BlockNode> sorted2, BlockNode[] doms) {
        BlockNode enterBlock = sorted2.get(0);
        enterBlock.setDoms(EmptyBitSet.EMPTY);
        enterBlock.setIDom(null);
        int blocksCount = sorted2.size();
        for (int i15 = 1; i15 < blocksCount; ++i15) {
            BlockNode block = sorted2.get(i15);
            BlockNode idom = doms[i15];
            block.setIDom(idom);
            idom.addDominatesOn(block);
            BitSet domBS = DominatorTree.collectDoms(doms, idom);
            domBS.clear(i15);
            block.setDoms(domBS);
        }
    }

    static BitSet collectDoms(BlockNode[] doms, BlockNode idom) {
        int id5;
        BitSet domBS = new BitSet(doms.length);
        BlockNode nextIDom = idom;
        while (!domBS.get(id5 = nextIDom.getId())) {
            domBS.set(id5);
            BitSet curDoms = nextIDom.getDoms();
            if (curDoms != null) {
                domBS.or(curDoms);
                break;
            }
            nextIDom = doms[id5];
        }
        return domBS;
    }

    public static void computeDominanceFrontier(MethodNode mth) {
        List<BlockNode> blocks = mth.getBasicBlocks();
        for (BlockNode block : blocks) {
            block.setDomFrontier(null);
        }
        int blocksCount = blocks.size();
        for (BlockNode block : blocks) {
            List<BlockNode> preds = block.getPredecessors();
            if (preds.size() < 2) continue;
            BlockNode idom = block.getIDom();
            Iterator<BlockNode> iterator2 = preds.iterator();
            while (iterator2.hasNext()) {
                BlockNode pred;
                for (BlockNode runner = pred = iterator2.next(); runner != idom; runner = runner.getIDom()) {
                    DominatorTree.addToDF(runner, block, blocksCount);
                }
            }
        }
        for (BlockNode block : blocks) {
            BitSet df5 = block.getDomFrontier();
            if (df5 != null && !df5.isEmpty()) continue;
            block.setDomFrontier(EmptyBitSet.EMPTY);
        }
    }

    private static void addToDF(BlockNode block, BlockNode dfBlock, int blocksCount) {
        BitSet df5 = block.getDomFrontier();
        if (df5 == null) {
            df5 = new BitSet(blocksCount);
            block.setDomFrontier(df5);
        }
        df5.set(dfBlock.getId());
    }
}

