/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleUsing<T, U>
extends Single<T> {
    final Supplier<U> resourceSupplier;
    final Function<? super U, ? extends SingleSource<? extends T>> singleFunction;
    final Consumer<? super U> disposer;
    final boolean eager;

    public SingleUsing(Supplier<U> resourceSupplier, Function<? super U, ? extends SingleSource<? extends T>> singleFunction, Consumer<? super U> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.singleFunction = singleFunction;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        SingleSource<T> source;
        U resource;
        try {
            resource = this.resourceSupplier.get();
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            EmptyDisposable.error(ex4, observer);
            return;
        }
        try {
            source = Objects.requireNonNull(this.singleFunction.apply(resource), "The singleFunction returned a null SingleSource");
        }
        catch (Throwable ex52) {
            CompositeException ex52;
            Exceptions.throwIfFatal(ex52);
            if (this.eager) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    ex52 = new CompositeException(ex52, exc);
                }
            }
            EmptyDisposable.error((Throwable)ex52, observer);
            if (!this.eager) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    RxJavaPlugins.onError(exc);
                }
            }
            return;
        }
        source.subscribe(new UsingSingleObserver<T, U>(observer, resource, this.eager, this.disposer));
    }

    static final class UsingSingleObserver<T, U>
    extends AtomicReference<Object>
    implements SingleObserver<T>,
    Disposable {
        private static final long serialVersionUID = -5331524057054083935L;
        final SingleObserver<? super T> downstream;
        final Consumer<? super U> disposer;
        final boolean eager;
        Disposable upstream;

        UsingSingleObserver(SingleObserver<? super T> actual, U resource, boolean eager, Consumer<? super U> disposer) {
            super(resource);
            this.downstream = actual;
            this.eager = eager;
            this.disposer = disposer;
        }

        @Override
        public void dispose() {
            if (this.eager) {
                this.disposeResource();
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
            } else {
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
                this.disposeResource();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingSingleObserver u15 = this.getAndSet(this);
                if (u15 != this) {
                    try {
                        this.disposer.accept(u15);
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.downstream.onError(ex4);
                        return;
                    }
                } else {
                    return;
                }
            }
            this.downstream.onSuccess(value);
            if (!this.eager) {
                this.disposeResource();
            }
        }

        @Override
        public void onError(Throwable e15) {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingSingleObserver u15 = this.getAndSet(this);
                if (u15 != this) {
                    try {
                        this.disposer.accept(u15);
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        e15 = new CompositeException(e15, ex4);
                    }
                } else {
                    return;
                }
            }
            this.downstream.onError(e15);
            if (!this.eager) {
                this.disposeResource();
            }
        }

        void disposeResource() {
            UsingSingleObserver u15 = this.getAndSet(this);
            if (u15 != this) {
                try {
                    this.disposer.accept(u15);
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    RxJavaPlugins.onError(ex4);
                }
            }
        }
    }
}

