/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.operators.observable.ObservableWindowSubscribeIntercept;
import io.reactivex.rxjava3.subjects.UnicastSubject;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableWindow<T>
extends AbstractObservableWithUpstream<T, Observable<T>> {
    final long count;
    final long skip;
    final int capacityHint;

    public ObservableWindow(ObservableSource<T> source, long count, long skip, int capacityHint) {
        super(source);
        this.count = count;
        this.skip = skip;
        this.capacityHint = capacityHint;
    }

    @Override
    public void subscribeActual(Observer<? super Observable<T>> t15) {
        if (this.count == this.skip) {
            this.source.subscribe(new WindowExactObserver(t15, this.count, this.capacityHint));
        } else {
            this.source.subscribe(new WindowSkipObserver(t15, this.count, this.skip, this.capacityHint));
        }
    }

    static final class WindowSkipObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = 3366976432059579510L;
        final Observer<? super Observable<T>> downstream;
        final long count;
        final long skip;
        final int capacityHint;
        final ArrayDeque<UnicastSubject<T>> windows;
        final AtomicBoolean cancelled;
        long index;
        long firstEmission;
        Disposable upstream;

        WindowSkipObserver(Observer<? super Observable<T>> actual, long count, long skip, int capacityHint) {
            this.downstream = actual;
            this.count = count;
            this.skip = skip;
            this.capacityHint = capacityHint;
            this.windows = new ArrayDeque();
            this.cancelled = new AtomicBoolean();
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            ArrayDeque<UnicastSubject<T>> ws4 = this.windows;
            long i15 = this.index;
            long s15 = this.skip;
            ObservableWindowSubscribeIntercept intercept = null;
            if (i15 % s15 == 0L && !this.cancelled.get()) {
                this.getAndIncrement();
                UnicastSubject w15 = UnicastSubject.create(this.capacityHint, this);
                intercept = new ObservableWindowSubscribeIntercept(w15);
                ws4.offer(w15);
                this.downstream.onNext(intercept);
            }
            long c15 = this.firstEmission + 1L;
            for (UnicastSubject<T> w16 : ws4) {
                w16.onNext(t15);
            }
            if (c15 >= this.count) {
                ws4.poll().onComplete();
                if (ws4.isEmpty() && this.cancelled.get()) {
                    return;
                }
                this.firstEmission = c15 - s15;
            } else {
                this.firstEmission = c15;
            }
            this.index = i15 + 1L;
            if (intercept != null && intercept.tryAbandon()) {
                intercept.window.onComplete();
            }
        }

        @Override
        public void onError(Throwable t15) {
            ArrayDeque<UnicastSubject<T>> ws4 = this.windows;
            while (!ws4.isEmpty()) {
                ws4.poll().onError(t15);
            }
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            ArrayDeque<UnicastSubject<T>> ws4 = this.windows;
            while (!ws4.isEmpty()) {
                ws4.poll().onComplete();
            }
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled.get();
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.dispose();
            }
        }
    }

    static final class WindowExactObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = -7481782523886138128L;
        final Observer<? super Observable<T>> downstream;
        final long count;
        final int capacityHint;
        final AtomicBoolean cancelled;
        long size;
        Disposable upstream;
        UnicastSubject<T> window;

        WindowExactObserver(Observer<? super Observable<T>> actual, long count, int capacityHint) {
            this.downstream = actual;
            this.count = count;
            this.capacityHint = capacityHint;
            this.cancelled = new AtomicBoolean();
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            UnicastSubject<T> w15 = this.window;
            ObservableWindowSubscribeIntercept<T> intercept = null;
            if (w15 == null && !this.cancelled.get()) {
                this.getAndIncrement();
                w15 = UnicastSubject.create(this.capacityHint, this);
                this.window = w15;
                intercept = new ObservableWindowSubscribeIntercept<T>(w15);
                this.downstream.onNext(intercept);
            }
            if (w15 != null) {
                w15.onNext(t15);
                if (++this.size >= this.count) {
                    this.size = 0L;
                    this.window = null;
                    w15.onComplete();
                }
                if (intercept != null && intercept.tryAbandon()) {
                    this.window = null;
                    w15.onComplete();
                    w15 = null;
                }
            }
        }

        @Override
        public void onError(Throwable t15) {
            UnicastSubject<T> w15 = this.window;
            if (w15 != null) {
                this.window = null;
                w15.onError(t15);
            }
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            UnicastSubject<T> w15 = this.window;
            if (w15 != null) {
                this.window = null;
                w15.onComplete();
            }
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled.get();
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.dispose();
            }
        }
    }
}

