/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableMap;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.HalfSerializer;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableWithLatestFromMany<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    @Nullable
    final Publisher<?>[] otherArray;
    @Nullable
    final Iterable<? extends Publisher<?>> otherIterable;
    final Function<? super Object[], R> combiner;

    public FlowableWithLatestFromMany(@NonNull Flowable<T> source, @NonNull Publisher<?>[] otherArray, Function<? super Object[], R> combiner) {
        super(source);
        this.otherArray = otherArray;
        this.otherIterable = null;
        this.combiner = combiner;
    }

    public FlowableWithLatestFromMany(@NonNull Flowable<T> source, @NonNull Iterable<? extends Publisher<?>> otherIterable, @NonNull Function<? super Object[], R> combiner) {
        super(source);
        this.otherArray = null;
        this.otherIterable = otherIterable;
        this.combiner = combiner;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        Publisher<?>[] others = this.otherArray;
        int n15 = 0;
        if (others == null) {
            others = new Publisher[8];
            try {
                for (Publisher<?> p15 : this.otherIterable) {
                    if (n15 == others.length) {
                        others = Arrays.copyOf(others, n15 + (n15 >> 1));
                    }
                    others[n15++] = p15;
                }
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                EmptySubscription.error(ex4, s15);
                return;
            }
        } else {
            n15 = others.length;
        }
        if (n15 == 0) {
            new FlowableMap(this.source, new SingletonArrayFunc()).subscribeActual(s15);
            return;
        }
        WithLatestFromSubscriber parent = new WithLatestFromSubscriber(s15, this.combiner, n15);
        s15.onSubscribe(parent);
        parent.subscribe(others, n15);
        this.source.subscribe(parent);
    }

    final class SingletonArrayFunc
    implements Function<T, R> {
        SingletonArrayFunc() {
        }

        @Override
        public R apply(T t15) throws Throwable {
            return Objects.requireNonNull(FlowableWithLatestFromMany.this.combiner.apply((Object[])new Object[]{t15}), "The combiner returned a null value");
        }
    }

    static final class WithLatestInnerSubscriber
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<Object> {
        private static final long serialVersionUID = 3256684027868224024L;
        final WithLatestFromSubscriber<?, ?> parent;
        final int index;
        boolean hasValue;

        WithLatestInnerSubscriber(WithLatestFromSubscriber<?, ?> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            SubscriptionHelper.setOnce(this, s15, Long.MAX_VALUE);
        }

        @Override
        public void onNext(Object t15) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.parent.innerNext(this.index, t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.innerError(this.index, t15);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this.index, this.hasValue);
        }

        void dispose() {
            SubscriptionHelper.cancel(this);
        }
    }

    static final class WithLatestFromSubscriber<T, R>
    extends AtomicInteger
    implements ConditionalSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 1577321883966341961L;
        final Subscriber<? super R> downstream;
        final Function<? super Object[], R> combiner;
        final WithLatestInnerSubscriber[] subscribers;
        final AtomicReferenceArray<Object> values;
        final AtomicReference<Subscription> upstream;
        final AtomicLong requested;
        final AtomicThrowable error;
        volatile boolean done;

        WithLatestFromSubscriber(Subscriber<? super R> actual, Function<? super Object[], R> combiner, int n15) {
            this.downstream = actual;
            this.combiner = combiner;
            WithLatestInnerSubscriber[] s15 = new WithLatestInnerSubscriber[n15];
            for (int i15 = 0; i15 < n15; ++i15) {
                s15[i15] = new WithLatestInnerSubscriber(this, i15);
            }
            this.subscribers = s15;
            this.values = new AtomicReferenceArray(n15);
            this.upstream = new AtomicReference();
            this.requested = new AtomicLong();
            this.error = new AtomicThrowable();
        }

        void subscribe(Publisher<?>[] others, int n15) {
            WithLatestInnerSubscriber[] subscribers = this.subscribers;
            AtomicReference<Subscription> upstream = this.upstream;
            for (int i15 = 0; i15 < n15; ++i15) {
                if (upstream.get() == SubscriptionHelper.CANCELLED) {
                    return;
                }
                others[i15].subscribe(subscribers[i15]);
            }
        }

        @Override
        public void onSubscribe(Subscription s15) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, s15);
        }

        @Override
        public void onNext(T t15) {
            if (!this.tryOnNext(t15) && !this.done) {
                this.upstream.get().request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            R v15;
            if (this.done) {
                return false;
            }
            AtomicReferenceArray<Object> ara = this.values;
            int n15 = ara.length();
            Object[] objects = new Object[n15 + 1];
            objects[0] = t15;
            for (int i15 = 0; i15 < n15; ++i15) {
                Object o15 = ara.get(i15);
                if (o15 == null) {
                    return false;
                }
                objects[i15 + 1] = o15;
            }
            try {
                v15 = Objects.requireNonNull(this.combiner.apply((Object[])objects), "The combiner returned a null value");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.cancel();
                this.onError(ex4);
                return false;
            }
            HalfSerializer.onNext(this.downstream, v15, (AtomicInteger)this, this.error);
            return true;
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.cancelAllBut(-1);
            HalfSerializer.onError(this.downstream, t15, (AtomicInteger)this, this.error);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.cancelAllBut(-1);
                HalfSerializer.onComplete(this.downstream, (AtomicInteger)this, this.error);
            }
        }

        @Override
        public void request(long n15) {
            SubscriptionHelper.deferredRequest(this.upstream, this.requested, n15);
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
            for (WithLatestInnerSubscriber s15 : this.subscribers) {
                s15.dispose();
            }
        }

        void innerNext(int index, Object o15) {
            this.values.set(index, o15);
        }

        void innerError(int index, Throwable t15) {
            this.done = true;
            SubscriptionHelper.cancel(this.upstream);
            this.cancelAllBut(index);
            HalfSerializer.onError(this.downstream, t15, (AtomicInteger)this, this.error);
        }

        void innerComplete(int index, boolean nonEmpty) {
            if (!nonEmpty) {
                this.done = true;
                SubscriptionHelper.cancel(this.upstream);
                this.cancelAllBut(index);
                HalfSerializer.onComplete(this.downstream, (AtomicInteger)this, this.error);
            }
        }

        void cancelAllBut(int index) {
            WithLatestInnerSubscriber[] subscribers = this.subscribers;
            for (int i15 = 0; i15 < subscribers.length; ++i15) {
                if (i15 == index) continue;
                subscribers[i15].dispose();
            }
        }
    }
}

