/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowablePublishMulticast<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super Flowable<T>, ? extends Publisher<? extends R>> selector;
    final int prefetch;
    final boolean delayError;

    public FlowablePublishMulticast(Flowable<T> source, Function<? super Flowable<T>, ? extends Publisher<? extends R>> selector, int prefetch, boolean delayError) {
        super(source);
        this.selector = selector;
        this.prefetch = prefetch;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        Publisher<R> other;
        MulticastProcessor mp4 = new MulticastProcessor(this.prefetch, this.delayError);
        try {
            other = Objects.requireNonNull(this.selector.apply(mp4), "selector returned a null Publisher");
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            EmptySubscription.error(ex4, s15);
            return;
        }
        OutputCanceller<? super R> out = new OutputCanceller<R>(s15, mp4);
        other.subscribe(out);
        this.source.subscribe(mp4);
    }

    static final class MulticastSubscription<T>
    extends AtomicLong
    implements Subscription {
        private static final long serialVersionUID = 8664815189257569791L;
        final Subscriber<? super T> downstream;
        final MulticastProcessor<T> parent;
        long emitted;

        MulticastSubscription(Subscriber<? super T> actual, MulticastProcessor<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.addCancel(this, n15);
                this.parent.drain();
            }
        }

        @Override
        public void cancel() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
                this.parent.drain();
            }
        }

        public boolean isCancelled() {
            return this.get() == Long.MIN_VALUE;
        }
    }

    static final class MulticastProcessor<T>
    extends Flowable<T>
    implements FlowableSubscriber<T> {
        static final MulticastSubscription[] EMPTY = new MulticastSubscription[0];
        static final MulticastSubscription[] TERMINATED = new MulticastSubscription[0];
        final AtomicInteger wip;
        final AtomicReference<MulticastSubscription<T>[]> subscribers;
        final int prefetch;
        final int limit;
        final boolean delayError;
        final AtomicReference<Subscription> upstream;
        volatile SimpleQueue<T> queue;
        int sourceMode;
        volatile boolean done;
        Throwable error;
        int consumed;

        MulticastProcessor(int prefetch, boolean delayError) {
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.delayError = delayError;
            this.wip = new AtomicInteger();
            this.upstream = new AtomicReference();
            this.subscribers = new AtomicReference<MulticastSubscription[]>(EMPTY);
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.setOnce(this.upstream, s15)) {
                if (s15 instanceof QueueSubscription) {
                    QueueSubscription qs4 = (QueueSubscription)s15;
                    int m15 = qs4.requestFusion(3);
                    if (m15 == 1) {
                        this.sourceMode = m15;
                        this.queue = qs4;
                        this.done = true;
                        this.drain();
                        return;
                    }
                    if (m15 == 2) {
                        this.sourceMode = m15;
                        this.queue = qs4;
                        QueueDrainHelper.request(s15, this.prefetch);
                        return;
                    }
                }
                this.queue = QueueDrainHelper.createQueue(this.prefetch);
                QueueDrainHelper.request(s15, this.prefetch);
            }
        }

        void dispose() {
            if (!this.done) {
                SimpleQueue<T> q15;
                SubscriptionHelper.cancel(this.upstream);
                if (this.wip.getAndIncrement() == 0 && (q15 = this.queue) != null) {
                    q15.clear();
                }
            }
        }

        boolean isDisposed() {
            return this.upstream.get() == SubscriptionHelper.CANCELLED;
        }

        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 0 && !this.queue.offer(t15)) {
                this.upstream.get().cancel();
                this.onError(MissingBackpressureException.createDefault());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.error = t15;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.drain();
            }
        }

        boolean add(MulticastSubscription<T> s15) {
            MulticastSubscription[] next;
            MulticastSubscription<T>[] current;
            do {
                if ((current = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int n15 = current.length;
                next = new MulticastSubscription[n15 + 1];
                System.arraycopy(current, 0, next, 0, n15);
                next[n15] = s15;
            } while (!this.subscribers.compareAndSet(current, next));
            return true;
        }

        void remove(MulticastSubscription<T> s15) {
            MulticastSubscription[] next;
            MulticastSubscription<T>[] current;
            do {
                int n15;
                if ((n15 = (current = this.subscribers.get()).length) == 0) {
                    return;
                }
                int j15 = -1;
                for (int i15 = 0; i15 < n15; ++i15) {
                    if (current[i15] != s15) continue;
                    j15 = i15;
                    break;
                }
                if (j15 < 0) {
                    return;
                }
                if (n15 == 1) {
                    next = EMPTY;
                    continue;
                }
                next = new MulticastSubscription[n15 - 1];
                System.arraycopy(current, 0, next, 0, j15);
                System.arraycopy(current, j15 + 1, next, j15, n15 - j15 - 1);
            } while (!this.subscribers.compareAndSet(current, next));
        }

        @Override
        protected void subscribeActual(Subscriber<? super T> s15) {
            MulticastSubscription<T> ms4 = new MulticastSubscription<T>(s15, this);
            s15.onSubscribe(ms4);
            if (this.add(ms4)) {
                if (ms4.isCancelled()) {
                    this.remove(ms4);
                    return;
                }
                this.drain();
            } else {
                Throwable ex4 = this.error;
                if (ex4 != null) {
                    s15.onError(ex4);
                } else {
                    s15.onComplete();
                }
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SimpleQueue<T> q15 = this.queue;
            int upstreamConsumed = this.consumed;
            int localLimit = this.limit;
            boolean canRequest = this.sourceMode != 1;
            AtomicReference<MulticastSubscription<T>[]> subs = this.subscribers;
            MulticastSubscription<T>[] array = subs.get();
            block2: while (true) {
                int n15 = array.length;
                if (q15 != null && n15 != 0) {
                    long r15 = Long.MAX_VALUE;
                    for (MulticastSubscription<T> ms4 : array) {
                        long u15 = ms4.get() - ms4.emitted;
                        if (u15 != Long.MIN_VALUE) {
                            if (r15 <= u15) continue;
                            r15 = u15;
                            continue;
                        }
                        --n15;
                    }
                    if (n15 == 0) {
                        r15 = 0L;
                    }
                    while (r15 != 0L) {
                        boolean empty;
                        T v15;
                        Throwable ex4;
                        if (this.isDisposed()) {
                            q15.clear();
                            return;
                        }
                        boolean d15 = this.done;
                        if (d15 && !this.delayError && (ex4 = this.error) != null) {
                            this.errorAll(ex4);
                            return;
                        }
                        try {
                            v15 = q15.poll();
                        }
                        catch (Throwable ex5) {
                            Exceptions.throwIfFatal(ex5);
                            SubscriptionHelper.cancel(this.upstream);
                            this.errorAll(ex5);
                            return;
                        }
                        boolean bl4 = empty = v15 == null;
                        if (d15 && empty) {
                            Throwable ex6 = this.error;
                            if (ex6 != null) {
                                this.errorAll(ex6);
                            } else {
                                this.completeAll();
                            }
                            return;
                        }
                        if (empty) break;
                        boolean subscribersChange = false;
                        for (MulticastSubscription<T> ms5 : array) {
                            long msr = ms5.get();
                            if (msr != Long.MIN_VALUE) {
                                if (msr != Long.MAX_VALUE) {
                                    ++ms5.emitted;
                                }
                                ms5.downstream.onNext(v15);
                                continue;
                            }
                            subscribersChange = true;
                        }
                        --r15;
                        if (canRequest && ++upstreamConsumed == localLimit) {
                            upstreamConsumed = 0;
                            this.upstream.get().request(localLimit);
                        }
                        MulticastSubscription<T>[] freshArray = subs.get();
                        if (!subscribersChange && freshArray == array) continue;
                        array = freshArray;
                        continue block2;
                    }
                    if (r15 == 0L) {
                        Throwable ex7;
                        if (this.isDisposed()) {
                            q15.clear();
                            return;
                        }
                        boolean d16 = this.done;
                        if (d16 && !this.delayError && (ex7 = this.error) != null) {
                            this.errorAll(ex7);
                            return;
                        }
                        if (d16 && q15.isEmpty()) {
                            ex = this.error;
                            if (ex != null) {
                                this.errorAll(ex);
                            } else {
                                this.completeAll();
                            }
                            return;
                        }
                    }
                }
                this.consumed = upstreamConsumed;
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
                if (q15 == null) {
                    q15 = this.queue;
                }
                array = subs.get();
            }
        }

        void errorAll(Throwable ex4) {
            for (MulticastSubscription ms4 : this.subscribers.getAndSet(TERMINATED)) {
                if (ms4.get() == Long.MIN_VALUE) continue;
                ms4.downstream.onError(ex4);
            }
        }

        void completeAll() {
            for (MulticastSubscription ms4 : this.subscribers.getAndSet(TERMINATED)) {
                if (ms4.get() == Long.MIN_VALUE) continue;
                ms4.downstream.onComplete();
            }
        }
    }

    static final class OutputCanceller<R>
    implements FlowableSubscriber<R>,
    Subscription {
        final Subscriber<? super R> downstream;
        final MulticastProcessor<?> processor;
        Subscription upstream;

        OutputCanceller(Subscriber<? super R> actual, MulticastProcessor<?> processor) {
            this.downstream = actual;
            this.processor = processor;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(R t15) {
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.downstream.onError(t15);
            this.processor.dispose();
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
            this.processor.dispose();
        }

        @Override
        public void request(long n15) {
            this.upstream.request(n15);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.processor.dispose();
        }
    }
}

