/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscribers.SinglePostCompleteSubscriber;
import java.util.Objects;
import org.reactivestreams.Subscriber;

public final class FlowableMapNotification<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends R> onNextMapper;
    final Function<? super Throwable, ? extends R> onErrorMapper;
    final Supplier<? extends R> onCompleteSupplier;

    public FlowableMapNotification(Flowable<T> source, Function<? super T, ? extends R> onNextMapper, Function<? super Throwable, ? extends R> onErrorMapper, Supplier<? extends R> onCompleteSupplier) {
        super(source);
        this.onNextMapper = onNextMapper;
        this.onErrorMapper = onErrorMapper;
        this.onCompleteSupplier = onCompleteSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        this.source.subscribe(new MapNotificationSubscriber<T, R>(s15, this.onNextMapper, this.onErrorMapper, this.onCompleteSupplier));
    }

    static final class MapNotificationSubscriber<T, R>
    extends SinglePostCompleteSubscriber<T, R> {
        private static final long serialVersionUID = 2757120512858778108L;
        final Function<? super T, ? extends R> onNextMapper;
        final Function<? super Throwable, ? extends R> onErrorMapper;
        final Supplier<? extends R> onCompleteSupplier;

        MapNotificationSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends R> onNextMapper, Function<? super Throwable, ? extends R> onErrorMapper, Supplier<? extends R> onCompleteSupplier) {
            super(actual);
            this.onNextMapper = onNextMapper;
            this.onErrorMapper = onErrorMapper;
            this.onCompleteSupplier = onCompleteSupplier;
        }

        @Override
        public void onNext(T t15) {
            R p15;
            try {
                p15 = Objects.requireNonNull(this.onNextMapper.apply(t15), "The onNext publisher returned is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.downstream.onError(e15);
                return;
            }
            ++this.produced;
            this.downstream.onNext(p15);
        }

        @Override
        public void onError(Throwable t15) {
            R p15;
            try {
                p15 = Objects.requireNonNull(this.onErrorMapper.apply(t15), "The onError publisher returned is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.downstream.onError(new CompositeException(t15, e15));
                return;
            }
            this.complete(p15);
        }

        @Override
        public void onComplete() {
            R p15;
            try {
                p15 = Objects.requireNonNull(this.onCompleteSupplier.get(), "The onComplete publisher returned is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.downstream.onError(e15);
                return;
            }
            this.complete(p15);
        }
    }
}

