/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableEmitter;
import io.reactivex.rxjava3.core.FlowableOnSubscribe;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.Cancellable;
import io.reactivex.rxjava3.internal.disposables.CancellableDisposable;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableCreate<T>
extends Flowable<T> {
    final FlowableOnSubscribe<T> source;
    final BackpressureStrategy backpressure;

    public FlowableCreate(FlowableOnSubscribe<T> source, BackpressureStrategy backpressure) {
        this.source = source;
        this.backpressure = backpressure;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> t15) {
        BaseEmitter emitter;
        switch (this.backpressure) {
            case MISSING: {
                emitter = new MissingEmitter<T>(t15);
                break;
            }
            case ERROR: {
                emitter = new ErrorAsyncEmitter<T>(t15);
                break;
            }
            case DROP: {
                emitter = new DropAsyncEmitter<T>(t15);
                break;
            }
            case LATEST: {
                emitter = new LatestAsyncEmitter<T>(t15);
                break;
            }
            default: {
                emitter = new BufferAsyncEmitter<T>(t15, FlowableCreate.bufferSize());
            }
        }
        t15.onSubscribe(emitter);
        try {
            this.source.subscribe(emitter);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            emitter.onError(ex4);
        }
    }

    static final class LatestAsyncEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 4023437720691792495L;
        final AtomicReference<T> queue = new AtomicReference();
        Throwable error;
        volatile boolean done;
        final AtomicInteger wip = new AtomicInteger();

        LatestAsyncEmitter(Subscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onNext(T t15) {
            if (this.done || this.isCancelled()) {
                return;
            }
            if (t15 == null) {
                this.onError(ExceptionHelper.createNullPointerException("onNext called with a null value."));
                return;
            }
            this.queue.set(t15);
            this.drain();
        }

        @Override
        public boolean signalError(Throwable e15) {
            if (this.done || this.isCancelled()) {
                return false;
            }
            this.error = e15;
            this.done = true;
            this.drain();
            return true;
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequested() {
            this.drain();
        }

        @Override
        void onUnsubscribed() {
            if (this.wip.getAndIncrement() == 0) {
                this.queue.lazySet(null);
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a15 = this.downstream;
            AtomicReference<T> q15 = this.queue;
            do {
                boolean d15;
                long e15;
                long r15 = this.get();
                for (e15 = 0L; e15 != r15; ++e15) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q15.lazySet(null);
                        return;
                    }
                    d15 = this.done;
                    Object o15 = q15.getAndSet(null);
                    boolean bl4 = empty = o15 == null;
                    if (d15 && empty) {
                        Throwable ex4 = this.error;
                        if (ex4 != null) {
                            this.errorDownstream(ex4);
                        } else {
                            this.completeDownstream();
                        }
                        return;
                    }
                    if (empty) break;
                    a15.onNext(o15);
                }
                if (e15 == r15) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q15.lazySet(null);
                        return;
                    }
                    d15 = this.done;
                    boolean bl5 = empty = q15.get() == null;
                    if (d15 && empty) {
                        Throwable ex5 = this.error;
                        if (ex5 != null) {
                            this.errorDownstream(ex5);
                        } else {
                            this.completeDownstream();
                        }
                        return;
                    }
                }
                if (e15 == 0L) continue;
                BackpressureHelper.produced(this, e15);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static final class BufferAsyncEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 2427151001689639875L;
        final SpscLinkedArrayQueue<T> queue;
        Throwable error;
        volatile boolean done;
        final AtomicInteger wip;

        BufferAsyncEmitter(Subscriber<? super T> actual, int capacityHint) {
            super(actual);
            this.queue = new SpscLinkedArrayQueue(capacityHint);
            this.wip = new AtomicInteger();
        }

        @Override
        public void onNext(T t15) {
            if (this.done || this.isCancelled()) {
                return;
            }
            if (t15 == null) {
                this.onError(ExceptionHelper.createNullPointerException("onNext called with a null value."));
                return;
            }
            this.queue.offer(t15);
            this.drain();
        }

        @Override
        public boolean signalError(Throwable e15) {
            if (this.done || this.isCancelled()) {
                return false;
            }
            this.error = e15;
            this.done = true;
            this.drain();
            return true;
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequested() {
            this.drain();
        }

        @Override
        void onUnsubscribed() {
            if (this.wip.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a15 = this.downstream;
            SpscLinkedArrayQueue<T> q15 = this.queue;
            do {
                boolean d15;
                long e15;
                long r15 = this.get();
                for (e15 = 0L; e15 != r15; ++e15) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q15.clear();
                        return;
                    }
                    d15 = this.done;
                    T o15 = q15.poll();
                    boolean bl4 = empty = o15 == null;
                    if (d15 && empty) {
                        Throwable ex4 = this.error;
                        if (ex4 != null) {
                            this.errorDownstream(ex4);
                        } else {
                            this.completeDownstream();
                        }
                        return;
                    }
                    if (empty) break;
                    a15.onNext(o15);
                }
                if (e15 == r15) {
                    if (this.isCancelled()) {
                        q15.clear();
                        return;
                    }
                    d15 = this.done;
                    boolean empty = q15.isEmpty();
                    if (d15 && empty) {
                        Throwable ex5 = this.error;
                        if (ex5 != null) {
                            this.errorDownstream(ex5);
                        } else {
                            this.completeDownstream();
                        }
                        return;
                    }
                }
                if (e15 == 0L) continue;
                BackpressureHelper.produced(this, e15);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static final class ErrorAsyncEmitter<T>
    extends NoOverflowBaseAsyncEmitter<T> {
        private static final long serialVersionUID = 338953216916120960L;

        ErrorAsyncEmitter(Subscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        void onOverflow() {
            this.onError(new MissingBackpressureException("create: Could not emit value due to lack of requests"));
        }
    }

    static final class DropAsyncEmitter<T>
    extends NoOverflowBaseAsyncEmitter<T> {
        private static final long serialVersionUID = 8360058422307496563L;

        DropAsyncEmitter(Subscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        void onOverflow() {
        }
    }

    static abstract class NoOverflowBaseAsyncEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 4127754106204442833L;

        NoOverflowBaseAsyncEmitter(Subscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public final void onNext(T t15) {
            if (this.isCancelled()) {
                return;
            }
            if (t15 == null) {
                this.onError(ExceptionHelper.createNullPointerException("onNext called with a null value."));
                return;
            }
            if (this.get() != 0L) {
                this.downstream.onNext(t15);
                BackpressureHelper.produced(this, 1L);
            } else {
                this.onOverflow();
            }
        }

        abstract void onOverflow();
    }

    static final class MissingEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 3776720187248809713L;

        MissingEmitter(Subscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onNext(T t15) {
            long r15;
            if (this.isCancelled()) {
                return;
            }
            if (t15 != null) {
                this.downstream.onNext(t15);
            } else {
                this.onError(ExceptionHelper.createNullPointerException("onNext called with a null value."));
                return;
            }
            while ((r15 = this.get()) != 0L && !this.compareAndSet(r15, r15 - 1L)) {
            }
        }
    }

    static abstract class BaseEmitter<T>
    extends AtomicLong
    implements FlowableEmitter<T>,
    Subscription {
        private static final long serialVersionUID = 7326289992464377023L;
        final Subscriber<? super T> downstream;
        final SequentialDisposable serial;

        BaseEmitter(Subscriber<? super T> downstream) {
            this.downstream = downstream;
            this.serial = new SequentialDisposable();
        }

        @Override
        public void onComplete() {
            this.completeDownstream();
        }

        protected void completeDownstream() {
            if (this.isCancelled()) {
                return;
            }
            try {
                this.downstream.onComplete();
            }
            finally {
                this.serial.dispose();
            }
        }

        @Override
        public final void onError(Throwable e15) {
            if (e15 == null) {
                e15 = ExceptionHelper.createNullPointerException("onError called with a null Throwable.");
            }
            if (!this.signalError(e15)) {
                RxJavaPlugins.onError(e15);
            }
        }

        @Override
        public final boolean tryOnError(Throwable e15) {
            if (e15 == null) {
                e15 = ExceptionHelper.createNullPointerException("tryOnError called with a null Throwable.");
            }
            return this.signalError(e15);
        }

        public boolean signalError(Throwable e15) {
            return this.errorDownstream(e15);
        }

        protected boolean errorDownstream(Throwable e15) {
            if (this.isCancelled()) {
                return false;
            }
            try {
                this.downstream.onError(e15);
            }
            finally {
                this.serial.dispose();
            }
            return true;
        }

        @Override
        public final void cancel() {
            this.serial.dispose();
            this.onUnsubscribed();
        }

        void onUnsubscribed() {
        }

        @Override
        public final boolean isCancelled() {
            return this.serial.isDisposed();
        }

        @Override
        public final void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this, n15);
                this.onRequested();
            }
        }

        void onRequested() {
        }

        @Override
        public final void setDisposable(Disposable d15) {
            this.serial.update(d15);
        }

        @Override
        public final void setCancellable(Cancellable c15) {
            this.setDisposable(new CancellableDisposable(c15));
        }

        @Override
        public final long requested() {
            return this.get();
        }

        @Override
        public final FlowableEmitter<T> serialize() {
            return new SerializedEmitter(this);
        }

        @Override
        public String toString() {
            return String.format("%s{%s}", this.getClass().getSimpleName(), super.toString());
        }
    }

    static final class SerializedEmitter<T>
    extends AtomicInteger
    implements FlowableEmitter<T> {
        private static final long serialVersionUID = 4883307006032401862L;
        final BaseEmitter<T> emitter;
        final AtomicThrowable errors;
        final SimplePlainQueue<T> queue;
        volatile boolean done;

        SerializedEmitter(BaseEmitter<T> emitter) {
            this.emitter = emitter;
            this.errors = new AtomicThrowable();
            this.queue = new SpscLinkedArrayQueue(16);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t15) {
            if (this.emitter.isCancelled() || this.done) {
                return;
            }
            if (t15 == null) {
                this.onError(ExceptionHelper.createNullPointerException("onNext called with a null value."));
                return;
            }
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.emitter.onNext(t15);
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimplePlainQueue<T> q15;
                SimplePlainQueue<T> simplePlainQueue = q15 = this.queue;
                synchronized (simplePlainQueue) {
                    q15.offer(t15);
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t15) {
            if (!this.tryOnError(t15)) {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public boolean tryOnError(Throwable t15) {
            if (this.emitter.isCancelled() || this.done) {
                return false;
            }
            if (t15 == null) {
                t15 = ExceptionHelper.createNullPointerException("onError called with a null Throwable.");
            }
            if (this.errors.tryAddThrowable(t15)) {
                this.done = true;
                this.drain();
                return true;
            }
            return false;
        }

        @Override
        public void onComplete() {
            if (this.emitter.isCancelled() || this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            BaseEmitter<T> e15 = this.emitter;
            SimplePlainQueue<T> q15 = this.queue;
            AtomicThrowable errors = this.errors;
            int missed = 1;
            while (true) {
                boolean empty;
                if (e15.isCancelled()) {
                    q15.clear();
                    return;
                }
                if (errors.get() != null) {
                    q15.clear();
                    errors.tryTerminateConsumer(e15);
                    return;
                }
                boolean d15 = this.done;
                T v15 = q15.poll();
                boolean bl4 = empty = v15 == null;
                if (d15 && empty) {
                    e15.onComplete();
                    return;
                }
                if (!empty) {
                    e15.onNext(v15);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void setDisposable(Disposable d15) {
            this.emitter.setDisposable(d15);
        }

        @Override
        public void setCancellable(Cancellable c15) {
            this.emitter.setCancellable(c15);
        }

        @Override
        public long requested() {
            return this.emitter.requested();
        }

        @Override
        public boolean isCancelled() {
            return this.emitter.isCancelled();
        }

        @Override
        public FlowableEmitter<T> serialize() {
            return this;
        }

        @Override
        public String toString() {
            return this.emitter.toString();
        }
    }
}

