/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

abstract class AbstractBackpressureThrottlingSubscriber<T, R>
extends AtomicInteger
implements FlowableSubscriber<T>,
Subscription {
    private static final long serialVersionUID = -5050301752721603566L;
    final Subscriber<? super R> downstream;
    Subscription upstream;
    volatile boolean done;
    Throwable error;
    volatile boolean cancelled;
    final AtomicLong requested = new AtomicLong();
    final AtomicReference<R> current = new AtomicReference();

    AbstractBackpressureThrottlingSubscriber(Subscriber<? super R> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(Subscription s15) {
        if (SubscriptionHelper.validate(this.upstream, s15)) {
            this.upstream = s15;
            this.downstream.onSubscribe(this);
            s15.request(Long.MAX_VALUE);
        }
    }

    @Override
    public abstract void onNext(T var1);

    @Override
    public void onError(Throwable t15) {
        this.error = t15;
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    public void request(long n15) {
        if (SubscriptionHelper.validate(n15)) {
            BackpressureHelper.add(this.requested, n15);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.upstream.cancel();
            if (this.getAndIncrement() == 0) {
                this.current.lazySet(null);
            }
        }
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        Subscriber<R> a15 = this.downstream;
        int missed = 1;
        AtomicLong r15 = this.requested;
        AtomicReference<R> q15 = this.current;
        do {
            long e15;
            for (e15 = 0L; e15 != r15.get(); ++e15) {
                boolean empty;
                boolean d15 = this.done;
                Object v15 = q15.getAndSet(null);
                boolean bl4 = empty = v15 == null;
                if (this.checkTerminated(d15, empty, a15, q15)) {
                    return;
                }
                if (empty) break;
                a15.onNext(v15);
            }
            if (e15 == r15.get() && this.checkTerminated(this.done, q15.get() == null, a15, q15)) {
                return;
            }
            if (e15 == 0L) continue;
            BackpressureHelper.produced(r15, e15);
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    boolean checkTerminated(boolean d15, boolean empty, Subscriber<?> a15, AtomicReference<R> q15) {
        if (this.cancelled) {
            q15.lazySet(null);
            return true;
        }
        if (d15) {
            Throwable e15 = this.error;
            if (e15 != null) {
                q15.lazySet(null);
                a15.onError(e15);
                return true;
            }
            if (empty) {
                a15.onComplete();
                return true;
            }
        }
        return false;
    }
}

