/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableMergeArray
extends Completable {
    final CompletableSource[] sources;

    public CompletableMergeArray(CompletableSource[] sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(CompletableObserver observer) {
        CompositeDisposable set = new CompositeDisposable();
        AtomicBoolean once = new AtomicBoolean();
        InnerCompletableObserver shared = new InnerCompletableObserver(observer, once, set, this.sources.length + 1);
        observer.onSubscribe(shared);
        for (CompletableSource c15 : this.sources) {
            if (set.isDisposed()) {
                return;
            }
            if (c15 == null) {
                set.dispose();
                NullPointerException npe = new NullPointerException("A completable source is null");
                shared.onError(npe);
                return;
            }
            c15.subscribe(shared);
        }
        shared.onComplete();
    }

    static final class InnerCompletableObserver
    extends AtomicInteger
    implements CompletableObserver,
    Disposable {
        private static final long serialVersionUID = -8360547806504310570L;
        final CompletableObserver downstream;
        final AtomicBoolean once;
        final CompositeDisposable set;

        InnerCompletableObserver(CompletableObserver actual, AtomicBoolean once, CompositeDisposable set, int n15) {
            this.downstream = actual;
            this.once = once;
            this.set = set;
            this.lazySet(n15);
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.set.add(d15);
        }

        @Override
        public void onError(Throwable e15) {
            this.set.dispose();
            if (this.once.compareAndSet(false, true)) {
                this.downstream.onError(e15);
            } else {
                RxJavaPlugins.onError(e15);
            }
        }

        @Override
        public void onComplete() {
            if (this.decrementAndGet() == 0) {
                this.downstream.onComplete();
            }
        }

        @Override
        public void dispose() {
            this.set.dispose();
            this.once.set(true);
        }

        @Override
        public boolean isDisposed() {
            return this.set.isDisposed();
        }
    }
}

