/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.disasm.api;

import io.github.skylot.raung.disasm.api.IRaungDisasm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public enum RaungDisasmPreset implements Consumer<IRaungDisasm>
{
    DEFAULT("default", "Balanced options for read and edit"){

        @Override
        public void accept(IRaungDisasm args) {
            args.saveCatchNumber(false);
            args.autoFrames(false);
            args.autoSwitch(false);
        }
    }
    ,
    REBUILD("rebuild", "Save additional data for rebuild result stability"){

        @Override
        public void accept(IRaungDisasm args) {
            args.saveCatchNumber(true);
            args.autoFrames(false);
            args.autoSwitch(false);
        }
    }
    ,
    AUTO("auto", "Omit information that can be calculated automatically (maxs, frames, switches)"){

        @Override
        public void accept(IRaungDisasm args) {
            args.saveCatchNumber(false);
            args.autoFrames(true);
            args.autoSwitch(true);
        }
    };

    private final String name;
    private final String description;
    private static final Map<String, RaungDisasmPreset> MAP;

    private RaungDisasmPreset(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static RaungDisasmPreset getByName(String name) {
        RaungDisasmPreset preset = MAP.get(name);
        if (preset == null) {
            throw new IllegalArgumentException("Unknown preset name: '" + name + "', possible values:\n" + RaungDisasmPreset.buildFormattedList());
        }
        return preset;
    }

    public static String buildFormattedList() {
        RaungDisasmPreset[] values2 = RaungDisasmPreset.values();
        ArrayList<String> lines = new ArrayList<String>(values2.length);
        for (RaungDisasmPreset preset : values2) {
            lines.add(String.format(" %s - %s", preset.name, preset.description));
        }
        return String.join((CharSequence)"\n", lines);
    }

    static {
        RaungDisasmPreset[] values2 = RaungDisasmPreset.values();
        HashMap<String, RaungDisasmPreset> map = new HashMap<String, RaungDisasmPreset>(values2.length);
        for (RaungDisasmPreset preset : values2) {
            map.put(preset.name, preset);
        }
        MAP = map;
    }
}

