/*
 * Decompiled with CFR 0.152.
 */
package dev.dirs;

import dev.dirs.Constants;
import dev.dirs.UnsupportedOperatingSystemException;
import dev.dirs.impl.Linux;
import dev.dirs.impl.Util;
import dev.dirs.impl.Windows;
import java.util.function.Supplier;

public final class BaseDirectories {
    public final String homeDir;
    public final String cacheDir;
    public final String configDir;
    public final String dataDir;
    public final String dataLocalDir;
    public final String executableDir;
    public final String preferenceDir;
    public final String runtimeDir;

    public static BaseDirectories get() {
        return new BaseDirectories(Windows.getDefaultSupplier());
    }

    public static BaseDirectories get(Supplier<Windows> supplier) {
        return new BaseDirectories(supplier);
    }

    private BaseDirectories(Supplier<Windows> supplier) {
        switch (Constants.operatingSystem) {
            case 'a': 
            case 'b': 
            case 'i': 
            case 'l': 
            case 's': {
                this.homeDir = System.getProperty("user.home");
                this.cacheDir = Util.defaultIfNullOrEmpty(System.getenv("XDG_CACHE_HOME"), this.homeDir, "/.cache");
                this.configDir = Util.defaultIfNullOrEmpty(System.getenv("XDG_CONFIG_HOME"), this.homeDir, "/.config");
                this.dataLocalDir = this.dataDir = Util.defaultIfNullOrEmpty(System.getenv("XDG_DATA_HOME"), this.homeDir, "/.local/share");
                this.executableDir = Linux.executableDir(this.homeDir, this.dataDir);
                this.preferenceDir = this.configDir;
                this.runtimeDir = Linux.runtimeDir(null);
                break;
            }
            case 'm': {
                this.homeDir = System.getProperty("user.home");
                this.cacheDir = this.homeDir + "/Library/Caches/";
                this.dataDir = this.configDir = this.homeDir + "/Library/Application Support/";
                this.dataLocalDir = this.configDir;
                this.executableDir = null;
                this.preferenceDir = this.homeDir + "/Library/Preferences/";
                this.runtimeDir = null;
                break;
            }
            case 'w': {
                String[] stringArray = supplier.get().winDirs("5E6C858F-0E22-4760-9AFE-EA3317B67173", "3EB685DB-65F9-4CF6-A03A-E3EF65729F3D", "F1B32785-6FBA-4FCF-9D55-7B8E7F157091");
                this.homeDir = stringArray[0];
                this.dataDir = stringArray[1];
                this.dataLocalDir = stringArray[2];
                this.configDir = this.dataDir;
                this.cacheDir = this.dataLocalDir;
                this.executableDir = null;
                this.preferenceDir = this.configDir;
                this.runtimeDir = null;
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Base directories are not supported on " + Constants.operatingSystemName);
            }
        }
    }

    public String toString() {
        return "BaseDirectories (" + Constants.operatingSystemName + "):\n  homeDir       = '" + this.homeDir + "'\n  cacheDir      = '" + this.cacheDir + "'\n  configDir     = '" + this.configDir + "'\n  dataDir       = '" + this.dataDir + "'\n  dataLocalDir  = '" + this.dataLocalDir + "'\n  executableDir = '" + this.executableDir + "'\n  preferenceDir = '" + this.preferenceDir + "'\n  runtimeDir    = '" + this.runtimeDir + "'\n";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BaseDirectories baseDirectories = (BaseDirectories)object;
        if (this.homeDir != null ? !this.homeDir.equals(baseDirectories.homeDir) : baseDirectories.homeDir != null) {
            return false;
        }
        if (this.cacheDir != null ? !this.cacheDir.equals(baseDirectories.cacheDir) : baseDirectories.cacheDir != null) {
            return false;
        }
        if (this.configDir != null ? !this.configDir.equals(baseDirectories.configDir) : baseDirectories.configDir != null) {
            return false;
        }
        if (this.dataDir != null ? !this.dataDir.equals(baseDirectories.dataDir) : baseDirectories.dataDir != null) {
            return false;
        }
        if (this.dataLocalDir != null ? !this.dataLocalDir.equals(baseDirectories.dataLocalDir) : baseDirectories.dataLocalDir != null) {
            return false;
        }
        if (this.executableDir != null ? !this.executableDir.equals(baseDirectories.executableDir) : baseDirectories.executableDir != null) {
            return false;
        }
        if (this.preferenceDir != null ? !this.preferenceDir.equals(baseDirectories.preferenceDir) : baseDirectories.preferenceDir != null) {
            return false;
        }
        return !(this.runtimeDir != null ? !this.runtimeDir.equals(baseDirectories.runtimeDir) : baseDirectories.runtimeDir != null);
    }

    public int hashCode() {
        int n15 = 0;
        n15 = 31 * n15 + (this.homeDir != null ? this.homeDir.hashCode() : 0);
        n15 = 31 * n15 + (this.cacheDir != null ? this.cacheDir.hashCode() : 0);
        n15 = 31 * n15 + (this.configDir != null ? this.configDir.hashCode() : 0);
        n15 = 31 * n15 + (this.dataDir != null ? this.dataDir.hashCode() : 0);
        n15 = 31 * n15 + (this.dataLocalDir != null ? this.dataLocalDir.hashCode() : 0);
        n15 = 31 * n15 + (this.executableDir != null ? this.executableDir.hashCode() : 0);
        n15 = 31 * n15 + (this.preferenceDir != null ? this.preferenceDir.hashCode() : 0);
        n15 = 31 * n15 + (this.runtimeDir != null ? this.runtimeDir.hashCode() : 0);
        return n15;
    }
}

