/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.AbstractCachedSeekableStream;
import com.twelvemonkeys.lang.Validate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public final class FileCacheSeekableStream
extends AbstractCachedSeekableStream {
    private byte[] buffer = new byte[1024];

    public FileCacheSeekableStream(InputStream inputStream) throws IOException {
        this(inputStream, "iocache", null);
    }

    public FileCacheSeekableStream(InputStream inputStream, String string) throws IOException {
        this(inputStream, string, null);
    }

    public FileCacheSeekableStream(InputStream inputStream, String string, File file2) throws IOException {
        this(Validate.notNull(inputStream, "stream"), FileCacheSeekableStream.createTempFile(string, file2));
    }

    static File createTempFile(String string, File file2) throws IOException {
        Validate.notNull(string, "tempBaseName");
        File file3 = File.createTempFile(string, null, file2);
        file3.deleteOnExit();
        return file3;
    }

    FileCacheSeekableStream(InputStream inputStream, File file2) throws FileNotFoundException {
        super(inputStream, new FileCache(file2));
    }

    @Override
    public final boolean isCachedMemory() {
        return false;
    }

    @Override
    public final boolean isCachedFile() {
        return true;
    }

    @Override
    protected void closeImpl() throws IOException {
        super.closeImpl();
        this.buffer = null;
    }

    @Override
    public int read() throws IOException {
        int n15;
        this.checkOpen();
        if (this.position == this.streamPosition) {
            n15 = this.readAhead(this.buffer, 0, this.buffer.length);
            if (n15 >= 0) {
                n15 = this.buffer[0] & 0xFF;
            }
        } else {
            this.syncPosition();
            n15 = this.getCache().read();
        }
        if (n15 != -1) {
            ++this.position;
        }
        return n15;
    }

    @Override
    public int read(byte[] byArray, int n15, int n16) throws IOException {
        int n17;
        this.checkOpen();
        if (this.position == this.streamPosition) {
            n17 = this.readAhead(byArray, n15, n16);
        } else {
            this.syncPosition();
            n17 = this.getCache().read(byArray, n15, (int)Math.min((long)n16, this.streamPosition - this.position));
        }
        if (n17 > 0) {
            this.position += (long)n17;
        }
        return n17;
    }

    private int readAhead(byte[] byArray, int n15, int n16) throws IOException {
        int n17 = this.stream.read(byArray, n15, n16);
        if (n17 > 0) {
            this.streamPosition += (long)n17;
            this.getCache().write(byArray, n15, n17);
        }
        return n17;
    }

    static final class FileCache
    extends AbstractCachedSeekableStream.StreamCache {
        private RandomAccessFile cacheFile;

        public FileCache(File file2) throws FileNotFoundException {
            Validate.notNull(file2, "file");
            this.cacheFile = new RandomAccessFile(file2, "rw");
        }

        @Override
        public void write(int n15) throws IOException {
            this.cacheFile.write(n15);
        }

        @Override
        public void write(byte[] byArray, int n15, int n16) throws IOException {
            this.cacheFile.write(byArray, n15, n16);
        }

        @Override
        public int read() throws IOException {
            return this.cacheFile.read();
        }

        @Override
        public int read(byte[] byArray, int n15, int n16) throws IOException {
            return this.cacheFile.read(byArray, n15, n16);
        }

        @Override
        public void seek(long l15) throws IOException {
            this.cacheFile.seek(l15);
        }

        @Override
        public long getPosition() throws IOException {
            return this.cacheFile.getFilePointer();
        }

        @Override
        void close() throws IOException {
            this.cacheFile.close();
        }
    }
}

