/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.EmptyReader;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompoundReader
extends Reader {
    private Reader current;
    private List<Reader> readers;
    protected final Object finalLock;
    protected final boolean markSupported;
    private int currentReader;
    private int markedReader;
    private long mark;
    private long next;

    public CompoundReader(Iterator<Reader> iterator2) {
        super(Validate.notNull(iterator2, "readers"));
        this.finalLock = iterator2;
        this.readers = new ArrayList<Reader>();
        boolean bl4 = true;
        while (iterator2.hasNext()) {
            Reader reader = iterator2.next();
            if (reader == null) {
                throw new NullPointerException("readers cannot contain null-elements");
            }
            this.readers.add(reader);
            bl4 = bl4 && reader.markSupported();
        }
        this.markSupported = bl4;
        this.current = this.nextReader();
    }

    protected final Reader nextReader() {
        this.current = this.currentReader >= this.readers.size() ? new EmptyReader() : this.readers.get(this.currentReader++);
        this.next = 0L;
        return this.current;
    }

    protected final void ensureOpen() throws IOException {
        if (this.readers == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void close() throws IOException {
        for (Reader reader : this.readers) {
            reader.close();
        }
        this.readers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n15) throws IOException {
        if (n15 < 0) {
            throw new IllegalArgumentException("Read limit < 0");
        }
        Object object = this.finalLock;
        synchronized (object) {
            this.ensureOpen();
            this.mark = this.next;
            this.markedReader = this.currentReader;
            this.current.mark(n15);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.finalLock;
        synchronized (object) {
            this.ensureOpen();
            if (this.currentReader != this.markedReader) {
                for (int i15 = this.currentReader; i15 >= this.markedReader; --i15) {
                    this.readers.get(i15).reset();
                }
                this.currentReader = this.markedReader - 1;
                this.nextReader();
            }
            this.current.reset();
            this.next = this.mark;
        }
    }

    @Override
    public boolean markSupported() {
        return this.markSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.finalLock;
        synchronized (object) {
            int n15 = this.current.read();
            if (n15 < 0 && this.currentReader < this.readers.size()) {
                this.nextReader();
                return this.read();
            }
            ++this.next;
            return n15;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n15, int n16) throws IOException {
        Object object = this.finalLock;
        synchronized (object) {
            int n17 = this.current.read(cArray, n15, n16);
            if (n17 < 0 && this.currentReader < this.readers.size()) {
                this.nextReader();
                return this.read(cArray, n15, n16);
            }
            this.next += (long)n17;
            return n17;
        }
    }

    @Override
    public boolean ready() throws IOException {
        return this.current.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l15) throws IOException {
        Object object = this.finalLock;
        synchronized (object) {
            long l16 = this.current.skip(l15);
            if (l16 == 0L && this.currentReader < this.readers.size()) {
                this.nextReader();
                return this.skip(l15);
            }
            this.next += l16;
            return l16;
        }
    }
}

