/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.SeekableInputStream;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.io.InputStream;

abstract class AbstractCachedSeekableStream
extends SeekableInputStream {
    protected final InputStream stream;
    protected long streamPosition;
    private StreamCache cache;

    protected AbstractCachedSeekableStream(InputStream inputStream, StreamCache streamCache) {
        Validate.notNull(inputStream, "stream");
        Validate.notNull(streamCache, "cache");
        this.stream = inputStream;
        this.cache = streamCache;
    }

    protected final StreamCache getCache() {
        return this.cache;
    }

    @Override
    public int available() throws IOException {
        long l15 = this.streamPosition - this.position + (long)this.stream.available();
        return l15 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l15;
    }

    @Override
    public int read() throws IOException {
        int n15;
        this.checkOpen();
        if (this.position == this.streamPosition) {
            n15 = this.stream.read();
            if (n15 >= 0) {
                ++this.streamPosition;
                this.cache.write(n15);
            }
        } else {
            this.syncPosition();
            n15 = this.cache.read();
        }
        if (n15 != -1) {
            ++this.position;
        }
        return n15;
    }

    @Override
    public int read(byte[] byArray, int n15, int n16) throws IOException {
        int n17;
        this.checkOpen();
        if (this.position == this.streamPosition) {
            n17 = this.stream.read(byArray, n15, n16);
            if (n17 > 0) {
                this.streamPosition += (long)n17;
                this.cache.write(byArray, n15, n17);
            }
        } else {
            this.syncPosition();
            n17 = this.cache.read(byArray, n15, n16);
        }
        if (n17 > 0) {
            this.position += (long)n17;
        }
        return n17;
    }

    protected final void syncPosition() throws IOException {
        if (this.cache.getPosition() != this.position) {
            this.cache.seek(this.position);
        }
    }

    @Override
    public final boolean isCached() {
        return true;
    }

    @Override
    public abstract boolean isCachedMemory();

    @Override
    public abstract boolean isCachedFile();

    @Override
    protected void seekImpl(long l15) throws IOException {
        if (this.streamPosition < l15) {
            long l16;
            if (this.cache.getPosition() != this.streamPosition) {
                this.cache.seek(this.streamPosition);
            }
            int n15 = (l16 = l15 - this.streamPosition) > 1024L ? 1024 : (int)l16;
            byte[] byArray = new byte[n15];
            while (l16 > 0L) {
                int n16 = (long)byArray.length < l16 ? byArray.length : (int)l16;
                int n17 = this.stream.read(byArray, 0, n16);
                if (n17 > 0) {
                    this.cache.write(byArray, 0, n17);
                    this.streamPosition += (long)n17;
                    l16 -= (long)n17;
                    continue;
                }
                if (n17 >= 0) continue;
                break;
            }
        } else {
            this.cache.seek(l15);
        }
    }

    @Override
    protected void flushBeforeImpl(long l15) {
        this.cache.flush(l15);
    }

    @Override
    protected void closeImpl() throws IOException {
        this.cache.close();
        this.cache = null;
        this.stream.close();
    }

    static abstract class StreamCache {
        StreamCache() {
        }

        abstract void write(int var1) throws IOException;

        void write(byte[] byArray, int n15, int n16) throws IOException {
            for (int i15 = 0; i15 < n16; ++i15) {
                this.write(byArray[n15 + i15]);
            }
        }

        abstract int read() throws IOException;

        int read(byte[] byArray, int n15, int n16) throws IOException {
            int n17;
            int n18 = 0;
            for (int i15 = 0; i15 < n16 && (n17 = this.read()) >= 0; ++i15) {
                byArray[n15 + i15] = (byte)n17;
                ++n18;
            }
            return n18;
        }

        abstract void seek(long var1) throws IOException;

        void flush(long l15) {
        }

        abstract long getPosition() throws IOException;

        abstract void close() throws IOException;
    }
}

