/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import javax.imageio.stream.ImageInputStreamImpl;

public final class ByteArrayImageInputStream
extends ImageInputStreamImpl {
    private final byte[] data;
    private final int dataOffset;
    private final int dataLength;

    public ByteArrayImageInputStream(byte[] byArray) {
        this(byArray, 0, byArray != null ? byArray.length : -1);
    }

    public ByteArrayImageInputStream(byte[] byArray, int n15, int n16) {
        this.data = Validate.notNull(byArray, "data");
        this.dataOffset = ByteArrayImageInputStream.isMax(byArray.length, n15, "offset");
        this.dataLength = ByteArrayImageInputStream.isMax(byArray.length - n15, n16, "length");
    }

    private static int isMax(int n15, int n16, String string) {
        return Validate.isTrue(n16 >= 0 && n16 <= n15, n16, String.format("%s out of range [0, %d]: %d", string, n15, n16));
    }

    @Override
    public int read() throws IOException {
        if (this.streamPos >= (long)this.dataLength) {
            return -1;
        }
        this.bitOffset = 0;
        return this.data[(int)this.streamPos++ + this.dataOffset] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n15, int n16) throws IOException {
        if (this.streamPos >= (long)this.dataLength) {
            return -1;
        }
        int n17 = (int)Math.min((long)this.dataLength - this.streamPos, (long)n16);
        this.bitOffset = 0;
        System.arraycopy(this.data, (int)this.streamPos + this.dataOffset, byArray, n15, n17);
        this.streamPos += (long)n17;
        return n17;
    }

    @Override
    public long length() {
        return this.dataLength;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedMemory() {
        return true;
    }
}

