/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.FieldInfo;
import com.google.protobuf.FieldType;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.Message;
import com.google.protobuf.MessageInfo;
import com.google.protobuf.MessageInfoFactory;
import com.google.protobuf.OneofInfo;
import com.google.protobuf.ProtoSyntax;
import com.google.protobuf.SchemaUtil;
import com.google.protobuf.StructuralMessageInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;

final class DescriptorMessageInfoFactory
implements MessageInfoFactory {
    private static final String GET_DEFAULT_INSTANCE_METHOD_NAME = "getDefaultInstance";
    private static final DescriptorMessageInfoFactory instance = new DescriptorMessageInfoFactory();
    private static final Set<String> specialFieldNames = new HashSet<String>(Arrays.asList("Class", "DefaultInstanceForType", "ParserForType", "SerializedSize", "AllFields", "DescriptorForType", "InitializationErrorString", "UnknownFields", "CachedSize"));
    private static IsInitializedCheckAnalyzer isInitializedCheckAnalyzer = new IsInitializedCheckAnalyzer();

    private DescriptorMessageInfoFactory() {
    }

    public static DescriptorMessageInfoFactory getInstance() {
        return instance;
    }

    @Override
    public boolean isSupported(Class<?> messageType) {
        return GeneratedMessageV3.class.isAssignableFrom(messageType);
    }

    @Override
    public MessageInfo messageInfoFor(Class<?> messageType) {
        if (!GeneratedMessageV3.class.isAssignableFrom(messageType)) {
            throw new IllegalArgumentException("Unsupported message type: " + messageType.getName());
        }
        return DescriptorMessageInfoFactory.convert(messageType, DescriptorMessageInfoFactory.descriptorForType(messageType));
    }

    private static Message getDefaultInstance(Class<?> messageType) {
        try {
            Method method = messageType.getDeclaredMethod(GET_DEFAULT_INSTANCE_METHOD_NAME, new Class[0]);
            return (Message)method.invoke(null, new Object[0]);
        }
        catch (Exception e15) {
            throw new IllegalArgumentException("Unable to get default instance for message class " + messageType.getName(), e15);
        }
    }

    private static Descriptors.Descriptor descriptorForType(Class<?> messageType) {
        return DescriptorMessageInfoFactory.getDefaultInstance(messageType).getDescriptorForType();
    }

    private static ProtoSyntax convertSyntax(Descriptors.FileDescriptor.Syntax syntax) {
        switch (syntax) {
            case PROTO2: {
                return ProtoSyntax.PROTO2;
            }
            case PROTO3: {
                return ProtoSyntax.PROTO3;
            }
            case EDITIONS: {
                return ProtoSyntax.EDITIONS;
            }
        }
        throw new IllegalArgumentException("Unsupported syntax: " + (Object)((Object)syntax));
    }

    private static MessageInfo convert(Class<?> messageType, Descriptors.Descriptor messageDescriptor) {
        List<Descriptors.FieldDescriptor> fieldDescriptors = messageDescriptor.getFields();
        StructuralMessageInfo.Builder builder = StructuralMessageInfo.newBuilder(fieldDescriptors.size());
        builder.withDefaultInstance(DescriptorMessageInfoFactory.getDefaultInstance(messageType));
        builder.withSyntax(DescriptorMessageInfoFactory.convertSyntax(messageDescriptor.getFile().getSyntax()));
        builder.withMessageSetWireFormat(messageDescriptor.getOptions().getMessageSetWireFormat());
        OneofState oneofState = new OneofState();
        int bitFieldIndex = 0;
        int presenceMask = 1;
        Field bitField = null;
        for (int i15 = 0; i15 < fieldDescriptors.size(); ++i15) {
            final Descriptors.FieldDescriptor fd5 = fieldDescriptors.get(i15);
            boolean enforceUtf8 = fd5.needsUtf8Check();
            Internal.EnumVerifier enumVerifier = null;
            if (fd5.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM && fd5.legacyEnumFieldTreatedAsClosed()) {
                enumVerifier = new Internal.EnumVerifier(){

                    @Override
                    public boolean isInRange(int number) {
                        return fd5.getEnumType().findValueByNumber(number) != null;
                    }
                };
            }
            if (fd5.getRealContainingOneof() != null) {
                builder.withField(DescriptorMessageInfoFactory.buildOneofMember(messageType, fd5, oneofState, enforceUtf8, enumVerifier));
                continue;
            }
            Field field = DescriptorMessageInfoFactory.field(messageType, fd5);
            int number = fd5.getNumber();
            FieldType type = DescriptorMessageInfoFactory.getFieldType(fd5);
            if (!fd5.hasPresence()) {
                FieldInfo fieldImplicitPresence;
                if (fd5.isMapField()) {
                    final Descriptors.FieldDescriptor valueField = fd5.getMessageType().findFieldByNumber(2);
                    if (valueField.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM && valueField.legacyEnumFieldTreatedAsClosed()) {
                        enumVerifier = new Internal.EnumVerifier(){

                            @Override
                            public boolean isInRange(int number) {
                                return valueField.getEnumType().findValueByNumber(number) != null;
                            }
                        };
                    }
                    fieldImplicitPresence = FieldInfo.forMapField(field, number, SchemaUtil.getMapDefaultEntry(messageType, fd5.getName()), enumVerifier);
                } else {
                    fieldImplicitPresence = fd5.isRepeated() && fd5.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? FieldInfo.forRepeatedMessageField(field, number, type, DescriptorMessageInfoFactory.getTypeForRepeatedMessageField(messageType, fd5)) : (fd5.isPacked() ? (enumVerifier != null ? FieldInfo.forPackedFieldWithEnumVerifier(field, number, type, enumVerifier, DescriptorMessageInfoFactory.cachedSizeField(messageType, fd5)) : FieldInfo.forPackedField(field, number, type, DescriptorMessageInfoFactory.cachedSizeField(messageType, fd5))) : (enumVerifier != null ? FieldInfo.forFieldWithEnumVerifier(field, number, type, enumVerifier) : FieldInfo.forField(field, number, type, enforceUtf8)));
                }
                builder.withField(fieldImplicitPresence);
                continue;
            }
            if (bitField == null) {
                bitField = DescriptorMessageInfoFactory.bitField(messageType, bitFieldIndex);
            }
            FieldInfo fieldExplicitPresence = fd5.isRequired() ? FieldInfo.forLegacyRequiredField(field, number, type, bitField, presenceMask, enforceUtf8, enumVerifier) : FieldInfo.forExplicitPresenceField(field, number, type, bitField, presenceMask, enforceUtf8, enumVerifier);
            builder.withField(fieldExplicitPresence);
            if ((presenceMask <<= 1) != 0) continue;
            bitField = null;
            presenceMask = 1;
            ++bitFieldIndex;
        }
        ArrayList<Integer> fieldsToCheckIsInitialized = new ArrayList<Integer>();
        for (int i16 = 0; i16 < fieldDescriptors.size(); ++i16) {
            Descriptors.FieldDescriptor fd6 = fieldDescriptors.get(i16);
            if (!fd6.isRequired() && (fd6.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE || !DescriptorMessageInfoFactory.needsIsInitializedCheck(fd6.getMessageType()))) continue;
            fieldsToCheckIsInitialized.add(fd6.getNumber());
        }
        int[] numbers = new int[fieldsToCheckIsInitialized.size()];
        for (int i17 = 0; i17 < fieldsToCheckIsInitialized.size(); ++i17) {
            numbers[i17] = (Integer)fieldsToCheckIsInitialized.get(i17);
        }
        if (numbers.length > 0) {
            builder.withCheckInitialized(numbers);
        }
        return builder.build();
    }

    private static boolean needsIsInitializedCheck(Descriptors.Descriptor descriptor2) {
        return isInitializedCheckAnalyzer.needsIsInitializedCheck(descriptor2);
    }

    private static FieldInfo buildOneofMember(Class<?> messageType, Descriptors.FieldDescriptor fd5, OneofState oneofState, boolean enforceUtf8, Internal.EnumVerifier enumVerifier) {
        OneofInfo oneof = oneofState.getOneof(messageType, fd5.getContainingOneof());
        FieldType type = DescriptorMessageInfoFactory.getFieldType(fd5);
        Class<?> oneofStoredType = DescriptorMessageInfoFactory.getOneofStoredType(messageType, fd5, type);
        return FieldInfo.forOneofMemberField(fd5.getNumber(), type, oneof, oneofStoredType, enforceUtf8, enumVerifier);
    }

    private static Class<?> getOneofStoredType(Class<?> messageType, Descriptors.FieldDescriptor fd5, FieldType type) {
        switch (type.getJavaType()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case BYTE_STRING: {
                return ByteString.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case ENUM: 
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case STRING: {
                return String.class;
            }
            case MESSAGE: {
                return DescriptorMessageInfoFactory.getOneofStoredTypeForMessage(messageType, fd5);
            }
        }
        throw new IllegalArgumentException("Invalid type for oneof: " + (Object)((Object)type));
    }

    private static FieldType getFieldType(Descriptors.FieldDescriptor fd5) {
        switch (fd5.getType()) {
            case BOOL: {
                if (!fd5.isRepeated()) {
                    return FieldType.BOOL;
                }
                return fd5.isPacked() ? FieldType.BOOL_LIST_PACKED : FieldType.BOOL_LIST;
            }
            case BYTES: {
                return fd5.isRepeated() ? FieldType.BYTES_LIST : FieldType.BYTES;
            }
            case DOUBLE: {
                if (!fd5.isRepeated()) {
                    return FieldType.DOUBLE;
                }
                return fd5.isPacked() ? FieldType.DOUBLE_LIST_PACKED : FieldType.DOUBLE_LIST;
            }
            case ENUM: {
                if (!fd5.isRepeated()) {
                    return FieldType.ENUM;
                }
                return fd5.isPacked() ? FieldType.ENUM_LIST_PACKED : FieldType.ENUM_LIST;
            }
            case FIXED32: {
                if (!fd5.isRepeated()) {
                    return FieldType.FIXED32;
                }
                return fd5.isPacked() ? FieldType.FIXED32_LIST_PACKED : FieldType.FIXED32_LIST;
            }
            case FIXED64: {
                if (!fd5.isRepeated()) {
                    return FieldType.FIXED64;
                }
                return fd5.isPacked() ? FieldType.FIXED64_LIST_PACKED : FieldType.FIXED64_LIST;
            }
            case FLOAT: {
                if (!fd5.isRepeated()) {
                    return FieldType.FLOAT;
                }
                return fd5.isPacked() ? FieldType.FLOAT_LIST_PACKED : FieldType.FLOAT_LIST;
            }
            case GROUP: {
                return fd5.isRepeated() ? FieldType.GROUP_LIST : FieldType.GROUP;
            }
            case INT32: {
                if (!fd5.isRepeated()) {
                    return FieldType.INT32;
                }
                return fd5.isPacked() ? FieldType.INT32_LIST_PACKED : FieldType.INT32_LIST;
            }
            case INT64: {
                if (!fd5.isRepeated()) {
                    return FieldType.INT64;
                }
                return fd5.isPacked() ? FieldType.INT64_LIST_PACKED : FieldType.INT64_LIST;
            }
            case MESSAGE: {
                if (fd5.isMapField()) {
                    return FieldType.MAP;
                }
                return fd5.isRepeated() ? FieldType.MESSAGE_LIST : FieldType.MESSAGE;
            }
            case SFIXED32: {
                if (!fd5.isRepeated()) {
                    return FieldType.SFIXED32;
                }
                return fd5.isPacked() ? FieldType.SFIXED32_LIST_PACKED : FieldType.SFIXED32_LIST;
            }
            case SFIXED64: {
                if (!fd5.isRepeated()) {
                    return FieldType.SFIXED64;
                }
                return fd5.isPacked() ? FieldType.SFIXED64_LIST_PACKED : FieldType.SFIXED64_LIST;
            }
            case SINT32: {
                if (!fd5.isRepeated()) {
                    return FieldType.SINT32;
                }
                return fd5.isPacked() ? FieldType.SINT32_LIST_PACKED : FieldType.SINT32_LIST;
            }
            case SINT64: {
                if (!fd5.isRepeated()) {
                    return FieldType.SINT64;
                }
                return fd5.isPacked() ? FieldType.SINT64_LIST_PACKED : FieldType.SINT64_LIST;
            }
            case STRING: {
                return fd5.isRepeated() ? FieldType.STRING_LIST : FieldType.STRING;
            }
            case UINT32: {
                if (!fd5.isRepeated()) {
                    return FieldType.UINT32;
                }
                return fd5.isPacked() ? FieldType.UINT32_LIST_PACKED : FieldType.UINT32_LIST;
            }
            case UINT64: {
                if (!fd5.isRepeated()) {
                    return FieldType.UINT64;
                }
                return fd5.isPacked() ? FieldType.UINT64_LIST_PACKED : FieldType.UINT64_LIST;
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + (Object)((Object)fd5.getType()));
    }

    private static Field bitField(Class<?> messageType, int index) {
        return DescriptorMessageInfoFactory.field(messageType, "bitField" + index + "_");
    }

    private static Field field(Class<?> messageType, Descriptors.FieldDescriptor fd5) {
        return DescriptorMessageInfoFactory.field(messageType, DescriptorMessageInfoFactory.getFieldName(fd5));
    }

    private static Field cachedSizeField(Class<?> messageType, Descriptors.FieldDescriptor fd5) {
        return DescriptorMessageInfoFactory.field(messageType, DescriptorMessageInfoFactory.getCachedSizeFieldName(fd5));
    }

    private static Field field(Class<?> messageType, String fieldName) {
        try {
            return messageType.getDeclaredField(fieldName);
        }
        catch (Exception e15) {
            throw new IllegalArgumentException("Unable to find field " + fieldName + " in message class " + messageType.getName());
        }
    }

    static String getFieldName(Descriptors.FieldDescriptor fd5) {
        String name = fd5.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fd5.getMessageType().getName() : fd5.getName();
        String upperCamelCaseName = DescriptorMessageInfoFactory.snakeCaseToUpperCamelCase(name);
        String suffix = specialFieldNames.contains(upperCamelCaseName) ? "__" : "_";
        return DescriptorMessageInfoFactory.snakeCaseToLowerCamelCase(name) + suffix;
    }

    private static String getCachedSizeFieldName(Descriptors.FieldDescriptor fd5) {
        return DescriptorMessageInfoFactory.snakeCaseToLowerCamelCase(fd5.getName()) + "MemoizedSerializedSize";
    }

    private static String snakeCaseToLowerCamelCase(String snakeCase) {
        return DescriptorMessageInfoFactory.snakeCaseToCamelCase(snakeCase, false);
    }

    private static String snakeCaseToUpperCamelCase(String snakeCase) {
        return DescriptorMessageInfoFactory.snakeCaseToCamelCase(snakeCase, true);
    }

    private static String snakeCaseToCamelCase(String snakeCase, boolean capFirst) {
        StringBuilder sb5 = new StringBuilder(snakeCase.length() + 1);
        boolean capNext = capFirst;
        for (int ctr = 0; ctr < snakeCase.length(); ++ctr) {
            char next = snakeCase.charAt(ctr);
            if (next == '_') {
                capNext = true;
                continue;
            }
            if (Character.isDigit(next)) {
                sb5.append(next);
                capNext = true;
                continue;
            }
            if (capNext) {
                sb5.append(Character.toUpperCase(next));
                capNext = false;
                continue;
            }
            if (ctr == 0) {
                sb5.append(Character.toLowerCase(next));
                continue;
            }
            sb5.append(next);
        }
        return sb5.toString();
    }

    private static Class<?> getOneofStoredTypeForMessage(Class<?> messageType, Descriptors.FieldDescriptor fd5) {
        try {
            String name = fd5.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fd5.getMessageType().getName() : fd5.getName();
            Method getter = messageType.getDeclaredMethod(DescriptorMessageInfoFactory.getterForField(name), new Class[0]);
            return getter.getReturnType();
        }
        catch (Exception e15) {
            throw new RuntimeException(e15);
        }
    }

    private static Class<?> getTypeForRepeatedMessageField(Class<?> messageType, Descriptors.FieldDescriptor fd5) {
        try {
            String name = fd5.getType() == Descriptors.FieldDescriptor.Type.GROUP ? fd5.getMessageType().getName() : fd5.getName();
            Method getter = messageType.getDeclaredMethod(DescriptorMessageInfoFactory.getterForField(name), Integer.TYPE);
            return getter.getReturnType();
        }
        catch (Exception e15) {
            throw new RuntimeException(e15);
        }
    }

    private static String getterForField(String snakeCase) {
        String camelCase = DescriptorMessageInfoFactory.snakeCaseToLowerCamelCase(snakeCase);
        StringBuilder builder = new StringBuilder("get");
        builder.append(Character.toUpperCase(camelCase.charAt(0)));
        builder.append(camelCase.substring(1, camelCase.length()));
        return builder.toString();
    }

    private static final class OneofState {
        private OneofInfo[] oneofs = new OneofInfo[2];

        private OneofState() {
        }

        OneofInfo getOneof(Class<?> messageType, Descriptors.OneofDescriptor desc) {
            OneofInfo info;
            int index = desc.getIndex();
            if (index >= this.oneofs.length) {
                this.oneofs = Arrays.copyOf(this.oneofs, index * 2);
            }
            if ((info = this.oneofs[index]) == null) {
                this.oneofs[index] = info = OneofState.newInfo(messageType, desc);
            }
            return info;
        }

        private static OneofInfo newInfo(Class<?> messageType, Descriptors.OneofDescriptor desc) {
            String camelCase = DescriptorMessageInfoFactory.snakeCaseToLowerCamelCase(desc.getName());
            String valueFieldName = camelCase + "_";
            String caseFieldName = camelCase + "Case_";
            return new OneofInfo(desc.getIndex(), DescriptorMessageInfoFactory.field(messageType, caseFieldName), DescriptorMessageInfoFactory.field(messageType, valueFieldName));
        }
    }

    static class IsInitializedCheckAnalyzer {
        private final Map<Descriptors.Descriptor, Boolean> resultCache = new ConcurrentHashMap<Descriptors.Descriptor, Boolean>();
        private int index = 0;
        private final Stack<Node> stack = new Stack();
        private final Map<Descriptors.Descriptor, Node> nodeCache = new HashMap<Descriptors.Descriptor, Node>();

        IsInitializedCheckAnalyzer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean needsIsInitializedCheck(Descriptors.Descriptor descriptor2) {
            Boolean cachedValue = this.resultCache.get(descriptor2);
            if (cachedValue != null) {
                return cachedValue;
            }
            IsInitializedCheckAnalyzer isInitializedCheckAnalyzer = this;
            synchronized (isInitializedCheckAnalyzer) {
                cachedValue = this.resultCache.get(descriptor2);
                if (cachedValue != null) {
                    return cachedValue;
                }
                return this.dfs((Descriptors.Descriptor)descriptor2).component.needsIsInitializedCheck;
            }
        }

        private Node dfs(Descriptors.Descriptor descriptor2) {
            Node result = new Node(descriptor2, this.index++);
            this.stack.push(result);
            this.nodeCache.put(descriptor2, result);
            for (Descriptors.FieldDescriptor field : descriptor2.getFields()) {
                if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                Node child = this.nodeCache.get(field.getMessageType());
                if (child == null) {
                    child = this.dfs(field.getMessageType());
                    result.lowLink = Math.min(result.lowLink, child.lowLink);
                    continue;
                }
                if (child.component != null) continue;
                result.lowLink = Math.min(result.lowLink, child.lowLink);
            }
            if (result.index == result.lowLink) {
                Node node;
                StronglyConnectedComponent component = new StronglyConnectedComponent();
                do {
                    node = this.stack.pop();
                    node.component = component;
                    component.messages.add(node.descriptor);
                } while (node != result);
                this.analyze(component);
            }
            return result;
        }

        private void analyze(StronglyConnectedComponent component) {
            boolean needsIsInitializedCheck = false;
            block0: for (Descriptors.Descriptor descriptor2 : component.messages) {
                if (descriptor2.isExtendable()) {
                    needsIsInitializedCheck = true;
                    break;
                }
                for (Descriptors.FieldDescriptor field : descriptor2.getFields()) {
                    if (field.isRequired()) {
                        needsIsInitializedCheck = true;
                        break block0;
                    }
                    if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                    Node node = this.nodeCache.get(field.getMessageType());
                    if (node.component == component || !node.component.needsIsInitializedCheck) continue;
                    needsIsInitializedCheck = true;
                    break block0;
                }
            }
            component.needsIsInitializedCheck = needsIsInitializedCheck;
            for (Descriptors.Descriptor descriptor2 : component.messages) {
                this.resultCache.put(descriptor2, component.needsIsInitializedCheck);
            }
        }

        private static class StronglyConnectedComponent {
            final List<Descriptors.Descriptor> messages = new ArrayList<Descriptors.Descriptor>();
            boolean needsIsInitializedCheck = false;

            private StronglyConnectedComponent() {
            }
        }

        private static class Node {
            final Descriptors.Descriptor descriptor;
            final int index;
            int lowLink;
            StronglyConnectedComponent component;

            Node(Descriptors.Descriptor descriptor2, int index) {
                this.descriptor = descriptor2;
                this.index = index;
                this.lowLink = index;
                this.component = null;
            }
        }
    }
}

