/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Strings;
import com.google.common.base.VerifyException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.jspecify.annotations.Nullable;

@GwtCompatible
public final class Verify {
    public static void verify(boolean expression) {
        if (!expression) {
            throw new VerifyException();
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, char p15) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p15)));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, int p15) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, long p15) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, @Nullable Object p15) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, char p15, char p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p15), Character.valueOf(p25)));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, int p15, char p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15, Character.valueOf(p25)));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, long p15, char p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15, Character.valueOf(p25)));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, @Nullable Object p15, char p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15, Character.valueOf(p25)));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, char p15, int p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p15), p25));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, int p15, int p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15, p25));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, long p15, int p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15, p25));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, @Nullable Object p15, int p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15, p25));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, char p15, long p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p15), p25));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, int p15, long p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15, p25));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, long p15, long p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15, p25));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, @Nullable Object p15, long p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15, p25));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, char p15, @Nullable Object p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p15), p25));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, int p15, @Nullable Object p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15, p25));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, long p15, @Nullable Object p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15, p25));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, @Nullable Object p15, @Nullable Object p25) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15, p25));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, @Nullable Object p15, @Nullable Object p25, @Nullable Object p35) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15, p25, p35));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, @Nullable Object p15, @Nullable Object p25, @Nullable Object p35, @Nullable Object p45) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p15, p25, p35, p45));
        }
    }

    @CanIgnoreReturnValue
    public static <T> T verifyNotNull(@Nullable T reference) {
        return Verify.verifyNotNull(reference, "expected a non-null reference", new Object[0]);
    }

    @CanIgnoreReturnValue
    public static <T> T verifyNotNull(@Nullable T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    private Verify() {
    }
}

