/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.parser.LoaderContext;
import com.github.weisj.jsvg.parser.XMLInput;
import com.github.weisj.jsvg.parser.impl.StaxSVGLoader;
import com.github.weisj.jsvg.parser.impl.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SVGLoader {
    static final Logger LOGGER = Logger.getLogger(SVGLoader.class.getName());
    private final StaxSVGLoader loader = new StaxSVGLoader();

    @Nullable
    public SVGDocument load(@NotNull URL xmlBase) {
        return this.load(xmlBase, LoaderContext.createDefault());
    }

    @Nullable
    public SVGDocument load(@NotNull URL xmlBase, @NotNull LoaderContext loaderContext) {
        try {
            URI uri = xmlBase.toURI();
            return this.load(xmlBase.openStream(), uri, loaderContext);
        }
        catch (IOException | URISyntaxException e15) {
            LOGGER.log(Level.WARNING, String.format("Could not read %s", xmlBase), e15);
            return null;
        }
    }

    @Nullable
    public SVGDocument load(@NotNull InputStream inputStream, @Nullable URI xmlBase, @NotNull LoaderContext loaderContext) {
        SVGDocument sVGDocument;
        block8: {
            InputStream is4 = StreamUtil.createDocumentInputStream(inputStream);
            try {
                sVGDocument = this.load(this.loader.createXMLInput(is4), xmlBase, loaderContext);
                if (is4 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is4 != null) {
                        try {
                            is4.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e15) {
                    LOGGER.log(Level.WARNING, "Could not wrap input stream", e15);
                    return null;
                }
            }
            is4.close();
        }
        return sVGDocument;
    }

    @Nullable
    public SVGDocument load(@NotNull XMLInput xmlInput, @Nullable URI xmlBase, @NotNull LoaderContext loaderContext) {
        try {
            return this.loader.load(xmlInput, xmlBase, loaderContext);
        }
        catch (Exception e15) {
            LOGGER.log(Level.WARNING, "Could not load SVG", e15);
            return null;
        }
    }
}

