/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatTableHeaderUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class FlatTableHeaderBorder
extends FlatEmptyBorder {
    protected Color separatorColor = UIManager.getColor("TableHeader.separatorColor");
    protected Color bottomSeparatorColor = UIManager.getColor("TableHeader.bottomSeparatorColor");
    protected boolean showTrailingVerticalLine = UIManager.getBoolean("TableHeader.showTrailingVerticalLine");

    public FlatTableHeaderBorder() {
        super(UIManager.getInsets("TableHeader.cellMargins"));
    }

    @Override
    public Insets getBorderInsets(Component c15, Insets insets) {
        JTableHeader header = (JTableHeader)SwingUtilities.getAncestorOfClass(JTableHeader.class, c15);
        if (header != null && header.getUI() instanceof FlatTableHeaderUI) {
            FlatTableHeaderUI ui4 = (FlatTableHeaderUI)header.getUI();
            if (ui4.cellMargins != null) {
                Insets m15 = ui4.cellMargins;
                return FlatTableHeaderBorder.scaleInsets(c15, insets, m15.top, m15.left, m15.bottom, m15.right);
            }
        }
        return super.getBorderInsets(c15, insets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
        JTableHeader header = (JTableHeader)SwingUtilities.getAncestorOfClass(JTableHeader.class, c15);
        boolean leftToRight = (header != null ? header : c15).getComponentOrientation().isLeftToRight();
        boolean paintLeft = !leftToRight;
        boolean paintRight = leftToRight;
        Color separatorColor = this.separatorColor;
        Color bottomSeparatorColor = this.bottomSeparatorColor;
        if (header != null) {
            int hx4 = SwingUtilities.convertPoint((Component)c15, (int)x15, (int)y15, (Component)header).x;
            if (this.isDraggedColumn(header, hx4)) {
                paintRight = true;
                paintLeft = true;
            } else {
                if (hx4 <= 0 && !leftToRight && this.hideTrailingVerticalLine(header)) {
                    paintLeft = false;
                }
                if (hx4 + width >= header.getWidth() && leftToRight && this.hideTrailingVerticalLine(header)) {
                    paintRight = false;
                }
            }
            if (header.getUI() instanceof FlatTableHeaderUI) {
                FlatTableHeaderUI ui4 = (FlatTableHeaderUI)header.getUI();
                if (ui4.separatorColor != null) {
                    separatorColor = ui4.separatorColor;
                }
                if (ui4.bottomSeparatorColor != null) {
                    bottomSeparatorColor = ui4.bottomSeparatorColor;
                }
            }
        }
        float lineWidth = UIScale.scale(1.0f);
        Graphics2D g25 = (Graphics2D)g15.create();
        try {
            FlatUIUtils.setRenderingHints(g25);
            g25.setColor(separatorColor);
            if (paintLeft) {
                g25.fill(new Rectangle2D.Float(x15, y15, lineWidth, (float)height - lineWidth));
            }
            if (paintRight) {
                g25.fill(new Rectangle2D.Float((float)(x15 + width) - lineWidth, y15, lineWidth, (float)height - lineWidth));
            }
            g25.setColor(bottomSeparatorColor);
            g25.fill(new Rectangle2D.Float(x15, (float)(y15 + height) - lineWidth, width, lineWidth));
        }
        finally {
            g25.dispose();
        }
    }

    protected boolean isDraggedColumn(JTableHeader header, int x15) {
        TableColumn draggedColumn = header.getDraggedColumn();
        if (draggedColumn == null) {
            return false;
        }
        int draggedDistance = header.getDraggedDistance();
        if (draggedDistance == 0) {
            return false;
        }
        int columnCount = header.getColumnModel().getColumnCount();
        for (int i15 = 0; i15 < columnCount; ++i15) {
            if (header.getHeaderRect((int)i15).x + draggedDistance != x15) continue;
            return true;
        }
        return false;
    }

    protected boolean hideTrailingVerticalLine(JTableHeader header) {
        Container viewportParent;
        if (header.getUI() instanceof FlatTableHeaderUI) {
            FlatTableHeaderUI ui4 = (FlatTableHeaderUI)header.getUI();
            if (ui4.showTrailingVerticalLine != null) {
                return ui4.showTrailingVerticalLine == false;
            }
        }
        if (this.showTrailingVerticalLine) {
            return false;
        }
        Container viewport = header.getParent();
        Container container = viewportParent = viewport != null ? viewport.getParent() : null;
        if (!(viewportParent instanceof JScrollPane)) {
            return false;
        }
        JScrollPane scrollPane = (JScrollPane)viewportParent;
        JViewport columnHeader = scrollPane.getColumnHeader();
        if (viewport != columnHeader) {
            return false;
        }
        JScrollBar vsb = scrollPane.getVerticalScrollBar();
        if (vsb == null || !vsb.isVisible()) {
            return true;
        }
        return vsb.getY() == viewport.getY();
    }
}

