/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.builder;

import com.android.tools.smali.dexlib2.base.reference.BaseTypeReference;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.util.MethodUtil;
import com.android.tools.smali.dexlib2.writer.builder.BuilderAnnotationSet;
import com.android.tools.smali.dexlib2.writer.builder.BuilderEncodedValues;
import com.android.tools.smali.dexlib2.writer.builder.BuilderField;
import com.android.tools.smali.dexlib2.writer.builder.BuilderMethod;
import com.android.tools.smali.dexlib2.writer.builder.BuilderStringReference;
import com.android.tools.smali.dexlib2.writer.builder.BuilderTypeList;
import com.android.tools.smali.dexlib2.writer.builder.BuilderTypeReference;
import com.android.tools.smali.util.ArraySortedSet;
import com.android.tools.smali.util.CollectionUtils;
import com.android.tools.smali.util.IteratorUtils;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BuilderClassDef
extends BaseTypeReference
implements ClassDef {
    @Nonnull
    final BuilderTypeReference type;
    final int accessFlags;
    @Nullable
    final BuilderTypeReference superclass;
    @Nonnull
    final BuilderTypeList interfaces;
    @Nullable
    final BuilderStringReference sourceFile;
    @Nonnull
    final BuilderAnnotationSet annotations;
    @Nonnull
    final SortedSet<BuilderField> staticFields;
    @Nonnull
    final SortedSet<BuilderField> instanceFields;
    @Nonnull
    final SortedSet<BuilderMethod> directMethods;
    @Nonnull
    final SortedSet<BuilderMethod> virtualMethods;
    @Nullable
    final BuilderEncodedValues.BuilderArrayEncodedValue staticInitializers;
    int classDefIndex = -1;
    int annotationDirectoryOffset = 0;

    BuilderClassDef(@Nonnull BuilderTypeReference type, int accessFlags, @Nullable BuilderTypeReference superclass, @Nonnull BuilderTypeList interfaces, @Nullable BuilderStringReference sourceFile, @Nonnull BuilderAnnotationSet annotations, @Nullable SortedSet<BuilderField> staticFields, @Nullable SortedSet<BuilderField> instanceFields, @Nullable Iterable<? extends BuilderMethod> methods2, @Nullable BuilderEncodedValues.BuilderArrayEncodedValue staticInitializers) {
        if (methods2 == null) {
            methods2 = Collections.emptyList();
        }
        if (staticFields == null) {
            staticFields = Collections.emptySortedSet();
        }
        if (instanceFields == null) {
            instanceFields = Collections.emptySortedSet();
        }
        this.type = type;
        this.accessFlags = accessFlags;
        this.superclass = superclass;
        this.interfaces = interfaces;
        this.sourceFile = sourceFile;
        this.annotations = annotations;
        this.staticFields = staticFields;
        this.instanceFields = instanceFields;
        this.directMethods = ArraySortedSet.copyOf(CollectionUtils.naturalOrdering(), IteratorUtils.toList(IteratorUtils.filter(methods2, MethodUtil.METHOD_IS_DIRECT)));
        this.virtualMethods = ArraySortedSet.copyOf(CollectionUtils.naturalOrdering(), IteratorUtils.toList(IteratorUtils.filter(methods2, MethodUtil.METHOD_IS_VIRTUAL)));
        this.staticInitializers = staticInitializers;
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return this.superclass == null ? null : this.superclass.getType();
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return this.sourceFile == null ? null : this.sourceFile.getString();
    }

    @Nonnull
    public BuilderAnnotationSet getAnnotations() {
        return this.annotations;
    }

    @Nonnull
    public SortedSet<BuilderField> getStaticFields() {
        return this.staticFields;
    }

    @Nonnull
    public SortedSet<BuilderField> getInstanceFields() {
        return this.instanceFields;
    }

    @Nonnull
    public SortedSet<BuilderMethod> getDirectMethods() {
        return this.directMethods;
    }

    @Nonnull
    public SortedSet<BuilderMethod> getVirtualMethods() {
        return this.virtualMethods;
    }

    @Override
    @Nonnull
    public List<String> getInterfaces() {
        return this.interfaces.stream().map(iface -> iface.toString()).collect(Collectors.toList());
    }

    @Nonnull
    public Collection<BuilderField> getFields() {
        return new AbstractCollection<BuilderField>(){

            @Override
            @Nonnull
            public Iterator<BuilderField> iterator() {
                ArrayList<BuilderField> fields2 = new ArrayList<BuilderField>(BuilderClassDef.this.staticFields);
                fields2.addAll(BuilderClassDef.this.instanceFields);
                Collections.sort(fields2, CollectionUtils.naturalOrdering());
                return fields2.iterator();
            }

            @Override
            public int size() {
                return BuilderClassDef.this.staticFields.size() + BuilderClassDef.this.instanceFields.size();
            }
        };
    }

    @Nonnull
    public Collection<BuilderMethod> getMethods() {
        return new AbstractCollection<BuilderMethod>(){

            @Override
            @Nonnull
            public Iterator<BuilderMethod> iterator() {
                ArrayList<BuilderMethod> methods2 = new ArrayList<BuilderMethod>(BuilderClassDef.this.directMethods);
                methods2.addAll(BuilderClassDef.this.virtualMethods);
                Collections.sort(methods2, CollectionUtils.naturalOrdering());
                return methods2.iterator();
            }

            @Override
            public int size() {
                return BuilderClassDef.this.directMethods.size() + BuilderClassDef.this.virtualMethods.size();
            }
        };
    }
}

