/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable.util;

import com.android.tools.smali.dexlib2.immutable.ImmutableMethodParameter;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class ParamUtil {
    private static int findTypeEnd(@Nonnull String str, int index) {
        char c15 = str.charAt(index);
        switch (c15) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return index + 1;
            }
            case 'L': {
                while (str.charAt(index++) != ';') {
                }
                return index;
            }
            case '[': {
                while (str.charAt(index++) != '[') {
                }
                return ParamUtil.findTypeEnd(str, index);
            }
        }
        throw new IllegalArgumentException(String.format("Param string \"%s\" contains invalid type prefix: %s", str, Character.toString(c15)));
    }

    @Nonnull
    public static Iterable<ImmutableMethodParameter> parseParamString(final @Nonnull String params) {
        return new Iterable<ImmutableMethodParameter>(){

            @Override
            public Iterator<ImmutableMethodParameter> iterator() {
                return new Iterator<ImmutableMethodParameter>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < params.length();
                    }

                    @Override
                    public ImmutableMethodParameter next() {
                        int end = ParamUtil.findTypeEnd(params, this.index);
                        String ret = params.substring(this.index, end);
                        this.index = end;
                        return new ImmutableMethodParameter(ret, null, null);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

