/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.raw.util;

import com.android.tools.smali.dexlib2.dexbacked.CDexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.raw.AnnotationDirectoryItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.AnnotationItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.AnnotationSetItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.AnnotationSetRefList;
import com.android.tools.smali.dexlib2.dexbacked.raw.CallSiteIdItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.CdexDebugOffsetTable;
import com.android.tools.smali.dexlib2.dexbacked.raw.ClassDataItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.ClassDefItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.CodeItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.DebugInfoItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.EncodedArrayItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.FieldIdItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.HeaderItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.HiddenApiClassDataItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.ItemType;
import com.android.tools.smali.dexlib2.dexbacked.raw.MapItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.MethodHandleItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.MethodIdItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.ProtoIdItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.SectionAnnotator;
import com.android.tools.smali.dexlib2.dexbacked.raw.StringDataItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.StringIdItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.TypeIdItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.TypeListItem;
import com.android.tools.smali.dexlib2.util.AnnotatedBytes;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DexAnnotator
extends AnnotatedBytes {
    @Nonnull
    public final DexBackedDexFile dexFile;
    private final Map<Integer, SectionAnnotator> annotators = new HashMap<Integer, SectionAnnotator>();
    private static final Map<Integer, Integer> sectionAnnotationOrder = new HashMap<Integer, Integer>();

    public DexAnnotator(@Nonnull DexBackedDexFile dexFile, int width) {
        super(width);
        this.dexFile = dexFile;
        block23: for (MapItem mapItem : dexFile.getMapItems()) {
            switch (mapItem.getType()) {
                case 0: {
                    this.annotators.put(mapItem.getType(), HeaderItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 1: {
                    this.annotators.put(mapItem.getType(), StringIdItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 2: {
                    this.annotators.put(mapItem.getType(), TypeIdItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 3: {
                    this.annotators.put(mapItem.getType(), ProtoIdItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 4: {
                    this.annotators.put(mapItem.getType(), FieldIdItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 5: {
                    this.annotators.put(mapItem.getType(), MethodIdItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 6: {
                    this.annotators.put(mapItem.getType(), ClassDefItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 4096: {
                    this.annotators.put(mapItem.getType(), MapItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 4097: {
                    this.annotators.put(mapItem.getType(), TypeListItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 4098: {
                    this.annotators.put(mapItem.getType(), AnnotationSetRefList.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 4099: {
                    this.annotators.put(mapItem.getType(), AnnotationSetItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 8192: {
                    this.annotators.put(mapItem.getType(), ClassDataItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 8193: {
                    this.annotators.put(mapItem.getType(), CodeItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 8194: {
                    this.annotators.put(mapItem.getType(), StringDataItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 8195: {
                    this.annotators.put(mapItem.getType(), DebugInfoItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 8196: {
                    this.annotators.put(mapItem.getType(), AnnotationItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 8197: {
                    this.annotators.put(mapItem.getType(), EncodedArrayItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 8198: {
                    this.annotators.put(mapItem.getType(), AnnotationDirectoryItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 7: {
                    this.annotators.put(mapItem.getType(), CallSiteIdItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 8: {
                    this.annotators.put(mapItem.getType(), MethodHandleItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
                case 61440: {
                    this.annotators.put(mapItem.getType(), HiddenApiClassDataItem.makeAnnotator(this, mapItem));
                    continue block23;
                }
            }
            throw new RuntimeException(String.format("Unrecognized item type: 0x%x", mapItem.getType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAnnotations(Writer out) throws IOException {
        List<MapItem> mapItems = this.dexFile.getMapItems();
        Comparator<MapItem> comparator = new Comparator<MapItem>(){

            @Override
            public int compare(MapItem o15, MapItem o25) {
                return Integer.compare((Integer)sectionAnnotationOrder.get(o15.getType()), (Integer)sectionAnnotationOrder.get(o25.getType()));
            }
        };
        MapItem[] mapItemsArray = mapItems.toArray(new MapItem[mapItems.size()]);
        Arrays.sort(mapItemsArray, comparator);
        try {
            if (this.dexFile instanceof CDexBackedDexFile) {
                this.moveTo(this.dexFile.getBaseDataOffset() + ((CDexBackedDexFile)this.dexFile).getDebugInfoOffsetsPos());
                CdexDebugOffsetTable.annotate(this, this.dexFile.getBuffer());
            }
            for (MapItem mapItem : mapItemsArray) {
                try {
                    SectionAnnotator annotator = this.annotators.get(mapItem.getType());
                    annotator.annotateSection(this);
                }
                catch (Exception ex4) {
                    System.err.println(String.format("There was an error while dumping the %s section", ItemType.getItemTypeName(mapItem.getType())));
                    ex4.printStackTrace(System.err);
                }
            }
        }
        finally {
            this.writeAnnotations(out, this.dexFile.getBuffer().getBuf(), this.dexFile.getBuffer().getBaseOffset());
        }
    }

    @Nullable
    public SectionAnnotator getAnnotator(int itemType) {
        return this.annotators.get(itemType);
    }

    static {
        int[] sectionOrder = new int[]{4096, 0, 1, 2, 3, 4, 5, 7, 8, 6, 8192, 8193, 8195, 4097, 4098, 4099, 8194, 8196, 8197, 8198, 61440};
        for (int i15 = 0; i15 < sectionOrder.length; ++i15) {
            sectionAnnotationOrder.put(sectionOrder[i15], i15);
        }
    }
}

