/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.io.ByteSource;
import java.util.Optional;

public final class BinaryArtProfilesInjector {
    private final Optional<ByteSource> binaryArtProfile;
    private final Optional<ByteSource> binaryArtProfileMetadata;

    public BinaryArtProfilesInjector(AppBundle appBundle) {
        this.binaryArtProfile = BinaryArtProfilesInjector.extract(appBundle.getBundleMetadata(), "baseline.prof");
        this.binaryArtProfileMetadata = BinaryArtProfilesInjector.extract(appBundle.getBundleMetadata(), "baseline.profm");
    }

    public ModuleSplit inject(ModuleSplit split) {
        if (!this.binaryArtProfileMetadata.isPresent() && !this.binaryArtProfile.isPresent()) {
            return split;
        }
        if (!BinaryArtProfilesInjector.shouldInjectBinaryArtProfile(split)) {
            return split;
        }
        ModuleSplit.Builder builder = split.toBuilder();
        this.binaryArtProfile.ifPresent(content -> builder.addEntry(ModuleEntry.builder().setForceUncompressed(true).setContent((ByteSource)content).setPath(ZipPath.create("assets/dexopt").resolve("baseline.prof")).build()));
        this.binaryArtProfileMetadata.ifPresent(content -> builder.addEntry(ModuleEntry.builder().setForceUncompressed(true).setContent((ByteSource)content).setPath(ZipPath.create("assets/dexopt").resolve("baseline.profm")).build()));
        return builder.build();
    }

    private static boolean shouldInjectBinaryArtProfile(ModuleSplit split) {
        return split.getSplitType().equals((Object)ModuleSplit.SplitType.STANDALONE) || split.isMasterSplit() && split.isBaseModuleSplit();
    }

    private static Optional<ByteSource> extract(BundleMetadata metadata, String entryName) {
        Optional<ByteSource> entry = metadata.getFileAsByteSource("com.android.tools.build.profiles", entryName);
        return entry.isPresent() ? entry : metadata.getFileAsByteSource("assets.dexopt", entryName);
    }
}

