/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.CodeAddress;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.DalvInsnList;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.util.FixedSizeList;

public final class PositionList
extends FixedSizeList {
    public static final PositionList EMPTY = new PositionList(0);
    public static final int NONE = 1;
    public static final int LINES = 2;
    public static final int IMPORTANT = 3;

    public static PositionList make(DalvInsnList insns, int howMuch) {
        SourcePosition noInfo;
        switch (howMuch) {
            case 1: {
                return EMPTY;
            }
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("bogus howMuch");
            }
        }
        SourcePosition cur = noInfo = SourcePosition.NO_INFO;
        int sz4 = insns.size();
        Entry[] arr = new Entry[sz4];
        boolean lastWasTarget = false;
        int at4 = 0;
        for (int i15 = 0; i15 < sz4; ++i15) {
            DalvInsn insn = insns.get(i15);
            if (insn instanceof CodeAddress) {
                lastWasTarget = true;
                continue;
            }
            SourcePosition pos = insn.getPosition();
            if (pos.equals(noInfo) || pos.sameLine(cur) || howMuch == 3 && !lastWasTarget) continue;
            cur = pos;
            arr[at4] = new Entry(insn.getAddress(), pos);
            ++at4;
            lastWasTarget = false;
        }
        PositionList result = new PositionList(at4);
        for (int i16 = 0; i16 < at4; ++i16) {
            result.set(i16, arr[i16]);
        }
        result.setImmutable();
        return result;
    }

    public PositionList(int size) {
        super(size);
    }

    public Entry get(int n15) {
        return (Entry)this.get0(n15);
    }

    public void set(int n15, Entry entry) {
        this.set0(n15, entry);
    }

    public static class Entry {
        private final int address;
        private final SourcePosition position;

        public Entry(int address, SourcePosition position) {
            if (address < 0) {
                throw new IllegalArgumentException("address < 0");
            }
            if (position == null) {
                throw new NullPointerException("position == null");
            }
            this.address = address;
            this.position = position;
        }

        public int getAddress() {
            return this.address;
        }

        public SourcePosition getPosition() {
            return this.position;
        }
    }
}

