/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.FixedSizeList;
import com.android.dx.util.IntList;

public final class ByteCatchList
extends FixedSizeList {
    public static final ByteCatchList EMPTY = new ByteCatchList(0);

    public ByteCatchList(int count) {
        super(count);
    }

    public int byteLength() {
        return 2 + this.size() * 8;
    }

    public Item get(int n15) {
        return (Item)this.get0(n15);
    }

    public void set(int n15, Item item) {
        if (item == null) {
            throw new NullPointerException("item == null");
        }
        this.set0(n15, item);
    }

    public void set(int n15, int startPc, int endPc, int handlerPc, CstType exceptionClass) {
        this.set0(n15, new Item(startPc, endPc, handlerPc, exceptionClass));
    }

    public ByteCatchList listFor(int pc5) {
        int sz4 = this.size();
        Item[] resultArr = new Item[sz4];
        int resultSz = 0;
        for (int i15 = 0; i15 < sz4; ++i15) {
            Item one = this.get(i15);
            if (!one.covers(pc5) || !ByteCatchList.typeNotFound(one, resultArr, resultSz)) continue;
            resultArr[resultSz] = one;
            ++resultSz;
        }
        if (resultSz == 0) {
            return EMPTY;
        }
        ByteCatchList result = new ByteCatchList(resultSz);
        for (int i16 = 0; i16 < resultSz; ++i16) {
            result.set(i16, resultArr[i16]);
        }
        result.setImmutable();
        return result;
    }

    private static boolean typeNotFound(Item item, Item[] arr, int count) {
        CstType type = item.getExceptionClass();
        for (int i15 = 0; i15 < count; ++i15) {
            CstType one = arr[i15].getExceptionClass();
            if (one != type && one != CstType.OBJECT) continue;
            return false;
        }
        return true;
    }

    public IntList toTargetList(int noException) {
        if (noException < -1) {
            throw new IllegalArgumentException("noException < -1");
        }
        boolean hasDefault = noException >= 0;
        int sz4 = this.size();
        if (sz4 == 0) {
            if (hasDefault) {
                return IntList.makeImmutable(noException);
            }
            return IntList.EMPTY;
        }
        IntList result = new IntList(sz4 + (hasDefault ? 1 : 0));
        for (int i15 = 0; i15 < sz4; ++i15) {
            result.add(this.get(i15).getHandlerPc());
        }
        if (hasDefault) {
            result.add(noException);
        }
        result.setImmutable();
        return result;
    }

    public TypeList toRopCatchList() {
        int sz4 = this.size();
        if (sz4 == 0) {
            return StdTypeList.EMPTY;
        }
        StdTypeList result = new StdTypeList(sz4);
        for (int i15 = 0; i15 < sz4; ++i15) {
            result.set(i15, this.get(i15).getExceptionClass().getClassType());
        }
        result.setImmutable();
        return result;
    }

    public static class Item {
        private final int startPc;
        private final int endPc;
        private final int handlerPc;
        private final CstType exceptionClass;

        public Item(int startPc, int endPc, int handlerPc, CstType exceptionClass) {
            if (startPc < 0) {
                throw new IllegalArgumentException("startPc < 0");
            }
            if (endPc < startPc) {
                throw new IllegalArgumentException("endPc < startPc");
            }
            if (handlerPc < 0) {
                throw new IllegalArgumentException("handlerPc < 0");
            }
            this.startPc = startPc;
            this.endPc = endPc;
            this.handlerPc = handlerPc;
            this.exceptionClass = exceptionClass;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public int getEndPc() {
            return this.endPc;
        }

        public int getHandlerPc() {
            return this.handlerPc;
        }

        public CstType getExceptionClass() {
            return this.exceptionClass != null ? this.exceptionClass : CstType.OBJECT;
        }

        public boolean covers(int pc5) {
            return pc5 >= this.startPc && pc5 < this.endPc;
        }
    }
}

