/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.List;
import org.gradle.api.artifacts.ComponentMetadataListerDetails;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.repositories.descriptor.IvyRepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.metadata.ImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolver;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ivy.IvyComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;
import org.jspecify.annotations.Nullable;

public class IvyResolver
extends ExternalResourceResolver {
    private final boolean dynamicResolve;
    private final boolean m2Compatible;
    private final IvyLocalRepositoryAccess localRepositoryAccess;
    private final IvyRemoteRepositoryAccess remoteRepositoryAccess;

    public IvyResolver(IvyRepositoryDescriptor descriptor, RepositoryTransport transport, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, boolean dynamicResolve, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, @Nullable InstantiatingAction<ComponentMetadataSupplierDetails> componentMetadataSupplierFactory, @Nullable InstantiatingAction<ComponentMetadataListerDetails> componentMetadataVersionListerFactory, ImmutableMetadataSources metadataSources, MetadataArtifactProvider metadataArtifactProvider, Instantiator injector, ChecksumService checksumService, boolean continueOnConnectionFailure) {
        super(descriptor, transport.isLocal(), transport.getRepository(), transport.getResourceAccessor(), locallyAvailableResourceFinder, artifactFileStore, metadataSources, metadataArtifactProvider, componentMetadataSupplierFactory, componentMetadataVersionListerFactory, injector, checksumService, continueOnConnectionFailure);
        this.dynamicResolve = dynamicResolve;
        this.m2Compatible = descriptor.isM2Compatible();
        this.localRepositoryAccess = new IvyLocalRepositoryAccess();
        this.remoteRepositoryAccess = new IvyRemoteRepositoryAccess();
    }

    public String toString() {
        return "Ivy repository '" + this.getName() + "'";
    }

    @Override
    public boolean isDynamicResolveMode() {
        return this.dynamicResolve;
    }

    @Override
    protected boolean isMetaDataArtifact(ArtifactType artifactType) {
        return artifactType == ArtifactType.IVY_DESCRIPTOR;
    }

    public boolean isM2compatible() {
        return this.m2Compatible;
    }

    @Override
    public ModuleComponentRepositoryAccess<ModuleComponentResolveMetadata> getLocalAccess() {
        return this.localRepositoryAccess;
    }

    @Override
    public ModuleComponentRepositoryAccess<ModuleComponentResolveMetadata> getRemoteAccess() {
        return this.remoteRepositoryAccess;
    }

    private class IvyLocalRepositoryAccess
    extends ExternalResourceResolver.LocalRepositoryAccess {
        private IvyLocalRepositoryAccess() {
        }

        @Override
        protected void resolveJavadocArtifacts(ComponentArtifactResolveMetadata module, BuildableArtifactSetResolveResult result) {
            IvyComponentArtifactResolveMetadata ivyModule = (IvyComponentArtifactResolveMetadata)module;
            List<? extends ComponentArtifactMetadata> artifacts = ivyModule.getConfigurationArtifacts("javadoc");
            if (artifacts != null) {
                result.resolved(artifacts);
            }
        }

        @Override
        protected void resolveSourceArtifacts(ComponentArtifactResolveMetadata module, BuildableArtifactSetResolveResult result) {
            IvyComponentArtifactResolveMetadata ivyModule = (IvyComponentArtifactResolveMetadata)module;
            List<? extends ComponentArtifactMetadata> artifacts = ivyModule.getConfigurationArtifacts("sources");
            if (artifacts != null) {
                result.resolved(artifacts);
            }
        }
    }

    private class IvyRemoteRepositoryAccess
    extends ExternalResourceResolver.RemoteRepositoryAccess {
        private IvyRemoteRepositoryAccess() {
        }
    }
}

