# frozen_string_literal: true

module GitlabQuality
  module TestTooling
    module FeatureReadiness
      module Concerns
        module IssueConcern
          OPERATIONAL_READINESS_CHECKLIST_LABEL = 'operational-readiness-checklist'

          def create_operation_readiness_issue(work_item_title, assignee_id, issue_client, repository_files_client)
            operational_readiness_issue = issue_client.create_issue(
              title: "Operational Readiness Checklist for: '#{work_item_title}'",
              description: repository_files_client.file_contents,
              labels: [OPERATIONAL_READINESS_CHECKLIST_LABEL],
              assignee_id: assignee_id
            )

            puts "\nCreated operational readiness issue: #{operational_readiness_issue.web_url}\n"

            operational_readiness_issue
          end

          def has_operational_readiness_issue_linked?(linked_issue_iids, issue_client)
            linked_issues(linked_issue_iids, issue_client).any? { |issue| issue.labels.intersect?([OPERATIONAL_READINESS_CHECKLIST_LABEL]) }
          end

          def linked_issues(linked_issue_iids, issue_client)
            linked_issue_iids.flat_map { |iid| issue_client.find_issues(iid: iid) }
          end
        end
      end
    end
  end
end
