---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Webエディタを使用すると、GitLab UIで直接、テキストファイルを作成、アップロード、編集できます。
title: Webエディタ
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

Webエディタは、ローカル環境をセットアップしなくてもGitLabリポジトリを編集できるブラウザベースのツールです。次のことが可能です:

- 単一のファイルを編集し、Markdownのリアルタイムプレビューを表示する。
- 新しいファイルやディレクトリを作成する。
- ファイルをアップロード、置換する。
- バージョン管理用のブランチやタグを作成する。
- 同時編集の競合を防ぐために[ファイルをロック](../file_lock.md#lock-a-file-or-directory)する。
- Gitをローカルにセットアップせずに、プロジェクトにコントリビュートする。

GitLabは、Webエディタのコミットに[プライマリメールアドレス](../../profile/_index.md#change-the-email-displayed-on-your-commits)を使用します。

複数のファイルを変更する場合は、[Web IDE](../web_ide/_index.md)を使用します。

{{< alert type="note" >}}

[保護ブランチ](branches/protected.md)内のファイルを管理するには、適切な[権限](../../permissions.md)が必要です。

{{< /alert >}}

## ファイルを管理する {#manage-files}

GitLab UIから直接、Webエディタでファイルを作成、編集、アップロード、削除できます。

### ファイルを作成する {#create-a-file}

Webエディタでテキストファイルを作成する手順は次のとおりです:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 新しいファイルを作成したいディレクトリに移動します。
1. ディレクトリ名の横にあるプラスアイコン（{{< icon name="plus" >}}）> **新しいファイル**を選択します。
1. ブランチ名の横に、ファイル名と拡張子を入力します。たとえば`my_file.md`と入力します。
1. ファイルにコンテンツを追加します。
1. **変更をコミットする**を選択します。
1. **コミットメッセージ**フィールドに、コミットの理由を入力します。
1. 次のいずれかのオプションを選択します:

   - 事前入力されたターゲットブランチにファイルを作成するには、**変更をコミットする**を選択します。
   - 新しいブランチにファイルを作成して変更をコミットするには:

     1. **新しいブランチにコミットする**を選択します。
     1. ブランチ名を入力します。
     1. **この変更に対するマージリクエストを作成**チェックボックスがオフになっていることを確認します。
     1. **変更をコミットする**を選択します。

   - 新しいブランチにファイルを作成し、変更をコミットし、マージリクエストを作成するには:

     1. **新しいブランチにコミットする**を選択します。
     1. ブランチ名を入力します。
     1. **この変更に対するマージリクエストを作成**チェックボックスがオンになっていることを確認します。
     1. **変更をコミットする**を選択します。

#### テンプレートから作成する {#from-a-template}

Webエディタでテンプレートからテキストファイルを作成する手順は次のとおりです:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 新しいファイルを作成したいディレクトリに移動します。
1. ディレクトリ名の横にあるプラスアイコン（{{< icon name="plus" >}}）> **新しいファイル**を選択します。
1. **ファイル名**に、GitLabが標準で用意しているテンプレートの名を入力します:
   - `.gitignore`
   - `.gitlab-ci.yml`
   - `LICENSE`
   - `Dockerfile`
1. **テンプレートを適用**のドロップダウンリストから、テンプレートを選択します。
1. オプション。必要に応じてテンプレートを更新します。
1. [ファイルを作成する](#create-a-file)のプロセスの手順6から続けます。

### ファイルを編集する {#edit-a-file}

Webエディタでテキストファイルを編集する手順は次のとおりです:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 編集したいファイルに移動します。
1. **編集** > **単一のファイルを編集**を選択します。
1. 変更を加えます。
1. **変更をコミットする**を選択します。
1. **コミットメッセージ**フィールドに、コミットの理由を入力します。
1. 次のいずれかのオプションを選択します:

   - 事前入力されたターゲットブランチからファイルを編集するには、**変更をコミットする**を選択します。
   - 新しいブランチからファイルを編集し、変更をコミットするには:

     1. **新しいブランチにコミットする**を選択します。
     1. ブランチ名を入力します。
     1. **この変更に対するマージリクエストを作成**チェックボックスがオフになっていることを確認します。
     1. **変更をコミットする**を選択します。

   - 新しいブランチからファイルを編集し、変更をコミットし、マージリクエストを作成するには:

     1. **新しいブランチにコミットする**を選択します。
     1. ブランチ名を入力します。
     1. **この変更に対するマージリクエストを作成**チェックボックスがオンになっていることを確認します。
     1. **変更をコミットする**を選択します。
     1. フィールドに入力し、**マージリクエストを作成**を選択します。

{{< alert type="note" >}}

編集中に他のユーザーが同じファイルを編集して変更をコミットした場合、変更をコミットすることができません。`Someone edited the file the same time you did. Please check out the file and
make sure your change will not unintentionally remove theirs.`（他のユーザーが同時にファイルを編集しました。ファイルをチェックアウトして、あなたの変更によって相手の変更が意図せず削除されないよう注意してください。）というエラーメッセージが表示されます。

{{< /alert >}}

#### Markdownプレビュー {#markdown-preview}

WebエディタでMarkdownファイルをプレビューする手順は次のとおりです:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. プレビューしたいファイルに移動します。
1. **編集** > **単一のファイルを編集**を選択します。
1. **プレビュー**タブを選択します。

コンテンツとともにライブMarkdownプレビューを表示できます。

プレビューパネルを閉じるには、**入力**タブを選択します。

#### 特定の行にリンクする {#link-to-specific-lines}

Webエディタ内の単一行または複数行にリンクするには、URLのファイル名部分にハッシュ情報を追加します。次に例を示します:

- `MY_FILE.js#L3`は、`MY_FILE.js`の3行目をハイライトします。
- `MY_FILE.js#L3-10`は、`MY_FILE.js`の3行目から10行目をハイライトします。

ファイルを編集するときに、行番号を選択して単一行にリンクすることもできます。

#### フォークされたマージリクエストでファイルを編集する {#edit-files-in-a-forked-merge-request}

前提要件:

- フォークからのマージリクエストを使って作業する必要があります。
- [アップストリーム](../merge_requests/allow_collaboration.md#allow-commits-from-upstream-members)メンバーからのコミットを許可する必要があります。

フォークされたプロジェクトからのマージリクエストを使って作業している場合は、ファイルを編集して変更をコミットできます。手順を次のとおりです:

1. マージリクエストに移動します。
1. 編集したいファイルに移動します。
1. **編集** > **単一のファイルを編集**を選択します。
1. **変更をコミットする**を選択します。
1. **コミットメッセージ**に、コミットの理由を入力します。次の情報が提供されます。`Your changes can be committed to <branch-name> because a merge request is open.`（マージリクエストが開いているため、あなたの変更を <branch-name> にコミットできます。）
1. **変更をコミットする**を選択します。

### ファイルをアップロードする {#upload-a-file}

Webエディタでファイルをアップロードする手順は次のとおりです:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. ファイルをアップロードするディレクトリに移動します。
1. ディレクトリ名の横にあるプラスアイコン（{{< icon name="plus" >}}）> **ファイルをアップロード**を選択します。
1. 追加したいファイルをドロップまたはアップロードします。
1. **コミットメッセージ**フィールドに、コミットの理由を入力します。
1. 次のいずれかのオプションを選択します:

   - 事前入力されたターゲットブランチからファイルをアップロードするには、**変更をコミットする**を選択します。
   - 新しいブランチからファイルをアップロードし、変更をコミットするには:

     1. **新しいブランチにコミットする**を選択します。
     1. ブランチ名を入力します。
     1. **この変更に対するマージリクエストを作成**チェックボックスがオフになっていることを確認します。
     1. **変更をコミットする**を選択します。

   - 新しいブランチからファイルをアップロードし、変更をコミットし、マージリクエストを作成するには:

     1. **新しいブランチにコミットする**を選択します。
     1. ブランチ名を入力します。
     1. **この変更に対するマージリクエストを作成**チェックボックスがオンになっていることを確認します。
     1. **変更をコミットする**を選択します。
     1. フィールドに入力し、**マージリクエストを作成**を選択します。

### ファイルを削除する {#delete-a-file}

Webエディタでファイルを削除する手順は次のとおりです:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 削除したいファイルに移動します。
1. **削除**を選択します。
1. **コミットメッセージ**に、コミットの理由を入力します。
1. 次のオプションから選択します:

   - 事前入力されたターゲットブランチからファイルを削除するには、**変更をコミットする**を選択します。
   - 新しいブランチからファイルを削除し、変更をコミットするには:

     1. **新しいブランチにコミットする**を選択します。
     1. ブランチ名を入力します。
     1. **この変更に対するマージリクエストを作成**チェックボックスがオフになっていることを確認します。
     1. **変更をコミットする**を選択します。

   - 新しいブランチからファイルを削除し、変更をコミットし、マージリクエストを作成するには:

     1. **新しいブランチにコミットする**を選択します。
     1. ブランチ名を入力します。
     1. **この変更に対するマージリクエストを作成**チェックボックスがオンになっていることを確認します。
     1. **変更をコミットする**を選択します。

{{< alert type="note" >}}

編集中に他のユーザーが同じファイルを編集して変更をコミットした場合、変更をコミットすることができません。`Someone edited the file the same time you did. Please check out the file and
make sure your change will not unintentionally remove theirs.`（他のユーザーが同時にファイルを編集しました。ファイルをチェックアウトして、あなたの変更によって相手の変更が意図せず削除されないよう注意してください。）というエラーメッセージが表示されます。

{{< /alert >}}

### ファイルを置換する {#replace-a-file}

Webエディタでファイルを置換する手順は次のとおりです:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 置換したいファイルに移動します。
1. **置き換える**を選択します。
1. 既存のファイルと置き換えたいファイルをドロップまたはアップロードします。
1. **コミットメッセージ**に、コミットの理由を入力します。
1. 次のオプションから選択します:

   - 事前入力されたターゲットブランチからファイルを置換するには、**変更をコミットする**を選択します。
   - 新しいブランチからファイルを置換し、変更をコミットするには:

     1. **新しいブランチにコミットする**を選択します。
     1. ブランチ名を入力します。
     1. **この変更に対するマージリクエストを作成**チェックボックスがオフになっていることを確認します。
     1. **変更をコミットする**を選択します。

   - 新しいブランチからファイルを置換し、変更をコミットし、マージリクエストを作成するには:

     1. **新しいブランチにコミットする**を選択します。
     1. ブランチ名を入力します。
     1. **この変更に対するマージリクエストを作成**チェックボックスがオンになっていることを確認します。
     1. **変更をコミットする**を選択します。

### ファイルへの変更をキャンセルする {#cancel-file-changes}

Webエディタから、ファイルの変更、編集、アップロード、削除をキャンセルする手順は次のとおりです:

1. **キャンセル**を選択します。
1. 次のいずれかを選択します:

   - 確認して変更をキャンセルする場合: **OK**を選択します。
   - 変更をキャンセルしない場合: **キャンセル**を選択します。

### アクションメニューからのファイル操作 {#file-operations-from-the-actions-menu}

{{< history >}}

- GitLab 17.10で`blob_overflow_menu`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/519325)されました。デフォルトでは無効になっています。
- GitLab 18.1で[一般公開](https://gitlab.com/gitlab-org/gitlab/-/issues/522993)になりました。機能フラグ`blob_overflow_menu`は削除されました。

{{< /history >}}

**アクション**（{{< icon name="ellipsis_v" >}}）メニューは、ファイル操作をドロップダウンリストにまとめています。このメニューから、次の操作を実行できます:

- ファイルを編集する。
- ファイルをアップロードする。
- ファイルを削除する。
- ファイルを置換する。

これらの操作を完了するには、次の手順に従います:

1. GitLabでファイルを開きます。
1. 右上隅にあるファイル名の横の**アクション**（{{< icon name="ellipsis_v" >}}）を選択します。
1. 目的の操作を選択します。

## ディレクトリを作成する {#create-a-directory}

Webエディタでディレクトリを作成する手順は次のとおりです:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 新しいディレクトリを作成したいディレクトリに移動します。
1. ディレクトリ名の横にあるプラスアイコン（{{< icon name="plus" >}}）> **新しいディレクトリ**を選択します。
1. **ディレクトリ名**フィールドに、ディレクトリ名を入力します。
1. **コミットメッセージ**に、コミットの理由を入力します。
1. 次のオプションから選択します:

   - 事前入力されたターゲットブランチからディレクトリを作成するには、**変更をコミットする**を選択します。
   - 新しいブランチからディレクトリを作成し、変更をコミットするには:

     1. **新しいブランチにコミットする**を選択します。
     1. ブランチ名を入力します。
     1. **この変更に対するマージリクエストを作成**チェックボックスがオフになっていることを確認します。
     1. **変更をコミットする**を選択します。

   - 新しいブランチからディレクトリを作成し、変更をコミットし、マージリクエストを作成するには:

     1. **新しいブランチにコミットする**を選択します。
     1. ブランチ名を入力します。
     1. **この変更に対するマージリクエストを作成**チェックボックスがオンになっていることを確認します。
     1. **変更をコミットする**を選択します。

## ブランチを作成する {#create-a-branch}

Webエディタで[ブランチ](branches/_index.md)を作成する手順は次のとおりです:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. リポジトリ名の横にあるプラスアイコン（{{< icon name="plus" >}}）> **新しいブランチ**を選択します。
1. フィールドに入力します。
1. **ブランチを作成**を選択します。

## タグを作成する {#create-a-tag}

[タグ](tags/_index.md)を作成して、本番リリースやリリース候補などのマイルストーンをマークすることができます。Webエディタでタグを作成する手順は次のとおりです:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. リポジトリ名の横にあるプラスアイコン（{{< icon name="plus" >}}）> **新しいタグ**を選択します。
1. フィールドに入力します。
1. **タグを作成**を選択します。

## 関連トピック {#related-topics}

- [マージリクエストを作成する](../merge_requests/creating_merge_requests.md)
- [ブランチ](branches/_index.md)
  - [デフォルトブランチ](branches/default.md)
  - [保護ブランチ](branches/protected.md)
- [Web IDE](../web_ide/_index.md)
