---
stage: Software Supply Chain Security
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: アカウント所有権の後継者またはアカウントマネージャーの指定
description: GitLabアカウントのアカウント所有権の後継者またはアカウントマネージャーを指定します。
ignore_in_report: true
noindex: true
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

ご自身で管理できない場合に、GitLabアカウントへのアクセス許可を個人に付与できます。これにより、作業とプロジェクトの継続性が確保されます。

## アカウントマネージャー {#account-manager}

指定されたアカウントマネージャーは、ご自身でGitLabアカウントを管理できない場合に、一時的に管理できます。アカウントマネージャーは通常、法的または医学的に無能力である場合、または仕事のサバティカル休暇中の状況で使用されます。アカウントマネージャーは、アカウントへのフルアクセスを一時的に取得できます。この期間中に実行されたすべてのアクティビティーは、ユーザー名とIDに関連付けられ、すべてのコミットまたはコメントにユーザー名が表示されます。

### アカウントマネージャーの追加 {#add-an-account-manager}

アカウントマネージャーを追加するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集**を選択します。
1. 左側のサイドバーで、**アカウント**を選択します。
1. **Add account manager**（アカウントマネージャーの追加）を選択します。
1. アカウントマネージャーの詳細を追加します。
1. **Add account manager**（アカウントマネージャーの追加）を選択します。

### アカウントマネージャーの編集 {#edit-an-account-manager}

アカウントマネージャーを編集するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集**を選択します。
1. 左側のサイドバーで、**アカウント**を選択します。
1. アカウントマネージャーの横にある**編集**（{{< icon name="pencil" >}}）を選択します。
1. アカウントマネージャーの詳細を編集します。
1. **Add account manager**（アカウントマネージャーの追加）を選択します。

### アカウントマネージャーの削除 {#delete-an-account-manager}

アカウントマネージャーを削除するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集**を選択します。
1. 左側のサイドバーで、**アカウント**を選択します。
1. アカウントマネージャーの横にある**削除**（{{< icon name="remove" >}}）を選択します。
1. **Delete account manager**（アカウントマネージャーの削除）を選択します。

## アカウント所有権の後継者 {#account-successor}

指定されたアカウント所有権の後継者は、死亡した場合に、GitLabアカウントの永続的な所有権を引き受けることができます。アカウント所有権の後継者は、アカウントへのフルアクセスを永続的に取得できます。所有権を取得した後に実行されたすべてのアクティビティーは、ユーザー名とIDに関連付けられ、すべてのコミットまたはコメントにユーザー名が表示されます。アカウント所有権の後継者を指定する場合は、自分との関係も指定する必要があります。

### アカウント所有権の後継者の追加 {#add-an-account-successor}

アカウント所有権の後継者を追加するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集**を選択します。
1. 左側のサイドバーで、**アカウント**を選択します。
1. **Add account successor**（アカウント所有権の後継者の追加）を選択します。
1. アカウント所有権の後継者の詳細を追加します。
1. **Add account successor**（アカウント所有権の後継者の追加）を選択します。

### アカウント所有権の後継者の編集 {#edit-an-account-successor}

アカウント所有権の後継者を編集するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集**を選択します。
1. 左側のサイドバーで、**アカウント**を選択します。
1. アカウント所有権の後継者の横にある**編集**（{{< icon name="pencil" >}}）を選択します。
1. アカウント所有権の後継者の詳細を編集します。
1. **Add account successor**（アカウント所有権の後継者の追加）を選択します。

### アカウント所有権の後継者の削除 {#delete-an-account-successor}

アカウント所有権の後継者を削除するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集**を選択します。
1. 左側のサイドバーで、**アカウント**を選択します。
1. アカウント所有権の後継者の横にある**削除**（{{< icon name="remove" >}}）を選択します。
1. **Delete account successor**（アカウント所有権の後継者の削除）を選択します。
