---
stage: Analytics
group: Platform Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: アプリをモニタリングして、インシデントに対応します。
title: GitLabでアプリケーションのモニタリングを始める
---

モニタリングは、アプリケーションを維持および最適化する上で重要な部分です。GitLabGitLab可観測性の機能は、エラーの追跡、アプリケーションパフォーマンスの分析、およびインシデントへの対応に役立ちます。

これらの機能は、より大規模なDevOpsワークフローの一部です:

![「アプリケーションのモニタリング」セクションが強調表示された、GitLabで行う主なことの図。](img/get_started_monitor_app_v17_3.png)

これらの機能はすべて、個別に使用できます。たとえば、エラートラッキングを使用せずに、トレーシングまたはインシデントを使用できます。ただし、最高のエクスペリエンスを得るには、これらのすべての機能を組み合わせて使用​​してください。

## ステップ1: 使用するプロジェクトを決定する {#step-1-determine-which-project-to-use}

アプリケーションのソースコードの保存に現在使用しているのと同じプロジェクトを、モニタリングに使用できます。

複数のサービスとリポジトリを持つ大規模なアプリケーションの場合は、システムのさまざまなコンポーネントから収集されたすべてのテレメトリデータを一元化するために、専用のプロジェクトを作成する必要があります。このアプローチには、いくつかの利点があります:

- データはすべての開発チームと運用チームがアクセスでき、コラボレーションが促進されます。
- さまざまなソースからのデータを1か所でクエリして相互に関連付けることができるため、調査が迅速化されます。
- すべての可観測性データに対して信頼できる唯一の情報源が提供されるため、保守と更新が容易になります。
- 単一のプロジェクトでユーザー権限を一元化することにより、管理者のアクセス管理が簡素化されます。

可観測性機能を有効にするには、プロジェクトの管理者またはオーナーのロールが必要です。

詳細については、以下を参照してください:

- [プロジェクトを作成する](../project/_index.md)

## ステップ2: エラートラッキングでアプリケーションエラーを追跡する {#step-2-track-application-errors-with-error-tracking}

エラートラッキングは、アプリケーションのエラーを特定、優先順位付け、デバッグするのに役立ちます。アプリケーションによって生成されたエラーはSentry SDKによって収集され、GitLabまたはSentryバックエンドに保存されます。

詳細については、以下を参照してください:

- [エラートラッキングの仕組み](../../operations/error_tracking.md#how-error-tracking-works)

## ステップ3: アラートとインシデントを管理する {#step-3-manage-alerts-and-incidents}

インシデント管理機能をセットアップして、問題を解決するし、インシデントを共同で解決するします。

詳細については、以下を参照してください:

- [インシデント管理](../../operations/incident_management/_index.md)

## ステップ4: 分析と改善 {#step-4-analyze-and-improve}

収集したデータとインサイトを使用して、アプリケーションとモニタリングプロセスを継続的に改善します:

1. インサイトダッシュボードを作成して、作成およびクローズされたイシューまたはインシデントを分析し、インシデント対応のパフォーマンスを評価します。
1. オンコールのエンジニアがインシデントを自律的に修正するのに役立つ、実行可能な手順書を作成します。
1. モニタリング設定を定期的にレビューし、サンプリングのしきい値を調整するか、アプリケーションの進化に合わせて新しいメトリクスを追加します。
1. インシデント後のレビューを実施して、アプリケーションとインシデント対応プロセスの両方で改善の余地がある領域を特定します。
1. モニタリングから得られたインサイトを使用して、開発の優先順位と技術的負債の削減の取り組みを知らせます。

詳細については、以下を参照してください:

- [インサイトダッシュボード](../project/insights/_index.md)
- [実行可能な手順書](../project/clusters/runbooks/_index.md)
