---
stage: AI-powered
group: Agent Foundations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 複合アイデンティティ
---

{{< history >}}

- GitLab 18.3で`duo_workflow_use_composite_identity`[フラグ](../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/554156)されました。
- GitLab 18.8で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/work_items/585273)になりました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

複合アイデンティティは、次の2つのアイデンティティを1つのトークンに結合する認証および認可のメカニズムです:

- サービスアカウント。実際のアクションを実行するマシンユーザー。
- 人間のユーザー。リクエストを開始した人。

この二重アイデンティティのアプローチは、重大な課題を解決します。エージェントは、エージェントをトリガーしたユーザーのアクセス権、またはサービスアカウントに付与されたアクセス権を超えることなくアクションを実行する必要があります。同時に、アクションが人間のユーザーによって直接実行されたのではなく、エージェントによって実行されたことを明確に示す、独立したアイデンティティを維持する必要があります。

## 複合アイデンティティが重要な理由 {#why-composite-identity-matters}

複合アイデンティティが重要なのは、次のことを確実に実現できるからです:

- トレーサビリティ: すべてのエージェントのアクティビティはサービスアカウントに明確に帰属するため、監査ログとコミット履歴において自動化されたアクションを容易に識別できます。
- セキュリティ: エージェントは、サービスアカウントとそれをトリガーしたユーザーの両方に実行が許可されているアクションのみを実行できます。この共通部分に限定されたアクセスにより、特権エスカレーションを防止します。
- 責任: 人間のユーザーのアイデンティティがトークンに埋め込まれることで、エージェントのアクションから、それをトリガーしたユーザーまで遡れる監査証跡が作成されます。

たとえば、コードのテストを作成するようエージェントに依頼すると、生成されたコミットには、サービスアカウントが依頼元のユーザーに代わって作成したものであることが示されます。

## 複合アイデンティティを使用する場面 {#where-composite-identity-is-used}

複合アイデンティティは、フローとエージェントがRunner上で実行される場合に使用されます。該当するのは、次のような場面です:

- 基本フロー。
- カスタムフロー。
- 外部エージェント。
- エンドポイント`api/v4/ai/duo_workflows/workflows`を通じて開始されるすべてのフロー。

UIおよびIDEでは、GitLab Duo Chat（エージェント）は複合アイデンティティの対象外です。

## 複合アイデンティティの仕組み {#how-composite-identity-works}

リクエストを認証するトークンは、次の2つのアイデンティティを組み合わせたものです:

- プライマリ作成者: トークンのオーナーであり、デベロッパーロールを持つ[サービスアカウント](../profile/service_accounts.md)。
- セカンダリ作成者: エージェントまたはフローを開始した人間のユーザー。人間のユーザーの`id`は、[動的スコープ](https://github.com/doorkeeper-gem/doorkeeper/pull/1739)を使用してトークンのスコープに含まれています。

この複合アイデンティティにより、GitLab Duo Agent Platformによって作成されたすべてのアクティビティが、サービスアカウントに正しく帰属されます。同時に、人間のユーザーまたはサービスアカウントによる[特権エスカレーション](https://en.wikipedia.org/wiki/Privilege_escalation)を防止できます。

## 複合アイデンティティのワークフロー {#composite-identity-workflow}

複合アイデンティティはワークフローの一部です。

1. AIカタログでフローを作成します。
   - 複合アイデンティティに関連する変更はありません。
1. トップレベルグループでフローを有効にします。
   - 有効にするには、オーナーである必要があります。
   - トップレベルグループにサービスアカウントが作成されます。（名前は`ai-flowname-groupname`のようになります）。
1. プロジェクトでフローを有効にします。
   - トップレベルグループでフローを有効にする必要があります。
   - プロジェクトで有効にするには、メンテナーである必要があります。
   - デベロッパーロールが付与されたサービスアカウントが、プロジェクトに追加されます。
1. ユーザーがフローを実行します。
   - フローは、1回限りの複合アイデンティティによって実行されます。このアイデンティティには、ユーザーのロールとサービスアカウントのデベロッパーロールの組み合わせのうち、より制限の厳しい方が適用されます。そのため、ユーザーがメンテナーであっても、サービスアカウントがデベロッパーである場合は、デベロッパーロールが使用されます。
   - フローは、次の両方の条件を満たすプロジェクトにアクセスできます:
     - ユーザーがアクセスできる。
     - サービスアカウントが追加されている。

     たとえば、サービスアカウントが他のプロジェクトに追加され、ユーザーがそれらのプロジェクトにアクセスできる場合、ユーザーが過去にそのプロジェクトでフローを使用したことがなくても、フローはそれらのプロジェクトにアクセスできます。

## AIカタログフローのトークン権限 {#token-permissions-for-ai-catalog-flows}

AIカタログフローでは、権限スコープの異なる複数のトークンタイプを使用します:

- AIワークフローにおける複合アイデンティティ用のOAuthトークンのアクセス権は、`ai_workflows`および`mcp`スコープに限定されています。このOAuthトークンは、フローを実行するためにAIゲートウェイに渡されます。
- フローの一部としてトリガーされるCIジョブトークンは、[利用可能なジョブトークン権限](../../ci/jobs/ci_job_token.md#job-token-access)によって、権限がさらに制限されます。

これらはスコープの異なる別のトークンタイプであるため、CI/CDジョブはOAuthトークンとは異なる権限を持ちます。

## マージリクエストに関するコンプライアンス上の考慮事項 {#compliance-considerations-for-merge-requests}

フローがマージリクエストを作成する場合、そのマージリクエストは、フローをトリガーした人間のユーザーではなく、サービスアカウントに帰属します。この帰属モデルは、次のような職務分掌を必要とするコンプライアンスフレームワークと競合する可能性があります:

- SOC 2（システムおよび組織管理2）
- SOX（サーベンスオクスリー法）
- ISO 27001（情報セキュリティ管理）
- FedRAMP（米国連邦情報セキュリティ管理プログラム）

これらのフレームワークでは通常、同一のユーザーがコード変更を作成し、本番環境へのデプロイに向けてその変更を承認することはできないとされています。

### 帰属モデルについて {#understanding-the-attribution-model}

サービスアカウントがコミットを作成してマージリクエストをオープンしたとしても、次の理由により、人間のユーザーが作成者と見なされます:

- 人間のユーザーが、サービスアカウントに変更の作成を指示した。
- コンプライアンスの観点では、AIシステムにコードの作成を指示することは、自らコードを記述することと同等と見なされる。
- サービスアカウントは、人間のユーザーの意図を代行するプロキシとして機能する。

コンプライアンス要件の対象となる組織は、マージリクエストを作成する[基本フローをオフにする](../gitlab_duo/turn_on_off.md#turn-gitlab-duo-on-or-off)必要があります。
