---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: セキュリティセンター
description: 複数のプロジェクトにまたがった脆弱性を表示するための設定可能なスペース。
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

セキュリティセンターは、複数のプロジェクトの脆弱性データが含まれた設定可能な個人用スペースです。自分が所属するあらゆるプロジェクトから、最大1,000個のプロジェクトをセキュリティセンターに追加できます。

> [!note] セキュリティセンターの設定ページの**プロジェクト**リストには、最大100個のプロジェクトが表示されます。最初の100個のプロジェクトに表示されないプロジェクトを見つけるには、検索フィルターを使用します。

セキュリティセンターには、以下が表示されます:

- 追加したプロジェクトのセキュリティダッシュボード。
- 追加したプロジェクトの[脆弱性レポート](../vulnerability_report/_index.md)。
- プロジェクトを追加または削除するための設定エリア。

## セキュリティセンターを表示する {#view-the-security-center}

セキュリティセンターを表示するには、次の手順に従います:

1. 上部のバーで、**検索または移動先**を選択します。
1. **あなたの作業**を選択します。
1. **セキュリティ** > **セキュリティダッシュボード**を選択します。

デフォルトでは、セキュリティセンターは空です。少なくとも1つのセキュリティスキャナーが設定されているプロジェクトを1つ以上追加する必要があります。

## セキュリティセンターにプロジェクトを追加する {#add-projects-to-the-security-center}

プロジェクトを追加するには、次の手順に従います:

1. 上部のバーで、**検索または移動先**を選択します。
1. **あなたの作業**を選択します。
1. **セキュリティ**を展開します。
1. **設定**を選択します。
1. **プロジェクトを検索**テキストボックスを使用して、プロジェクトを検索して選択します。
1. **プロジェクトを追加**を選択します。

プロジェクトを追加すると、それらのプロジェクトのデフォルトブランチで見つかった脆弱性がセキュリティダッシュボードと脆弱性レポートに表示されます。

## セキュリティセンターからプロジェクトを削除する {#remove-projects-from-the-security-center}

セキュリティセンターには最大100個のプロジェクトが表示されるため、プロジェクトを削除するには、検索機能を使用する必要がある場合があります。プロジェクトを削除するには、次の手順に従います:

1. 上部のバーで、**検索または移動先**を選択します。
1. **あなたの作業**を選択します。
1. **セキュリティ**を展開します。
1. **設定**を選択します。
1. **プロジェクトを検索**テキストボックスを使用して、プロジェクトを検索します。
1. **ダッシュボードのプロジェクトを削除**（{{< icon name="remove" >}}）を選択します。

プロジェクトを削除すると、それらのプロジェクトのデフォルトブランチで見つかった脆弱性がセキュリティダッシュボードと脆弱性レポートに表示されなくなります。

## エクスポート {#exporting}

{{< history >}}

- GitLab 18.2で`vulnerabilities_pdf_export`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/546219)されました。デフォルトで有効になっています。
- 18.5で一般提供になりました。機能フラグ`vulnerabilities_pdf_export`は削除されました。

{{< /history >}}

セキュリティダッシュボードにリストされている脆弱性の詳細が含まれたPDFファイルをエクスポートできます。

エクスポートのチャートには以下が含まれます:

- 時間経過による脆弱性の推移
- プロジェクトのセキュリティ状態
- プロジェクトのセキュリティダッシュボード

### 詳細をエクスポートする {#export-details}

セキュリティダッシュボードにリストされているすべての脆弱性の詳細をエクスポートするには、**エクスポート**を選択します。

エクスポートされた詳細が利用可能になると、GitLabからメールが届きます。エクスポートされた詳細をダウンロードするには、メール内のリンクを選択します。

## 関連トピック {#related-topics}

- [セキュリティダッシュボード](../security_dashboard/_index.md)
- [脆弱性レポート](../vulnerability_report/_index.md)
- [脆弱性ページ](../vulnerabilities/_index.md)
