---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密性の高いシークレットまたはトークンPlanetScale APIトークンの公開'
---

## 説明 {#description}

PlanetScale APIサービストークンのパターンに一致するコンテンツがレスポンス本文に含まれていることが確認されました。サービストークンは、許可されたスコープに応じて、権限を作成および割り当てられます。サービストークンへのアクセス権を持つ悪意のある攻撃者には、このサービストークンに割り当てられたものと同じ権限が付与されます。この値を公開すると、攻撃者がこのトークンによって付与されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

漏洩したキーに関するセキュリティインシデントの処理に関する一般的なガイダンスについては、GitLabドキュメントの[インターネットへの認証情報の公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)を参照してください。

サービストークンを失効するには:

- PlanetScaleアカウントにサインインし、<https://app.planetscale.com/>にアクセスします。
- 左側のメニューから、[設定]を選択します
- [設定]で、[サービストークン]を選択します
- 特定されたセキュリティトークンを見つけて、その名前を選択します
- 組織のアクセス、権限、およびスコープをメモします
- 右上隅にある[サービストークンの削除]を選択します
- プロンプトが表示されたら、[サービストークンの削除]ダイアログで[削除]を選択します

詳細については、[サービストークンに関するPlanetScaleのドキュメント](https://planetscale.com/docs/concepts/service-tokens)を参照してください。

## 詳細 {#details}

| ID | 集約 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.91 | false | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
