---
stage: Solutions Architecture
group: Solutions Architecture
info: This page is owned by the Solutions Architecture team.
description: Duoワークフローを含む、GitLab AIソリューションコンポーネントとユースケースの概要。
title: GitLab AIソリューションコンポーネント
---

このドキュメントセクションでは、GitLabによって開発および提供されたさまざまなソリューションコンポーネントについて説明します。これらのソリューションコンポーネントをダウンロードして実行するには、招待コードについてアカウントチームにお問い合わせください。

ソリューションコンポーネントの使用は、[サブスクリプション契約](https://handbook.gitlab.com/handbook/legal/subscription-agreement/)（「契約」）に従うものとし、契約で定義されているFree Softwareを構成するものとします。

## GitLab Duoワークフロー {#gitlab-duo-workflow}

GitLab Duoワークフローを使用すると、開発タスクを完了できます。GitLabコードベース、イシュー、マージリクエスト、およびパイプラインは、VS Code統合開発環境（IDE）を使用して、プロンプトからエージェントワークフローを実行できるコンテキストになります。

GitLab Duoワークフローの詳細については、[こちらのドキュメント](../../../user/duo_agent_platform/_index.md)をご覧ください。

## Duoワークフローソリューション {#duo-workflow-solution}

Duoワークフローソリューションは、さまざまなソフトウェア開発ユースケースにプロンプトとコンテキストライブラリを提供します。各ソリューションのユースケースは、プロンプトとコンテキストライブラリを使用して、定義されたワークフロー計画に基づいて、コードレビュー、コーディングの変更、問題の修正などを含む、開発タスクを自動化するために必要な自律型ワークフローをサポートします。

[エージェントワークフロー: 適用Coding Style Guide](duo_workflow_codestyle.md)
