---
stage: Data Access
group: Gitaly
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: GitalyとGeoの機能
---

データにとって、最も可用性が高く、迅速にリカバリーでき、パフォーマンスが高く、完全に回復力のあるソリューションを求めるのは当然です。ただし、トレードオフがあります。

以下の表は、要件に基づいて適切な機能を組み合わせるためのガイドとして提供することを目的としています。

## Gitalyの機能 {#gitaly-capabilities}

| 機能                | 利用可否設定                                         | リカバリー性                                            | データ復元力                  | パフォーマンス                                                                                        | リスクとトレードオフ                                                                                                                                                                                                                                 |
|:--------------------------|:-----------------------------------------------------|:----------------------------------------------------------|:---------------------------------|:---------------------------------------------------------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Gitaly Cluster (Praefect) | 非常に高い - ノードの障害に耐性があります                | 手動操作なしで10秒の単一ノードの目標リカバリー時間 | データは複数のノードに保存されます | 良好 - 書き込みは投票のためわずかに時間がかかる場合がありますが、読み取り分散により読み取り速度が向上します | トレードオフ - 冗長で強力な一貫性のあるストレージソリューションのために、書き込み速度がわずかに低下します。リスク - [スナップショットのバックアップをサポートしていません](praefect/_index.md#snapshot-backup-and-recovery)、GitLabのバックアップタスクは、大規模なデータセットの場合に時間がかかることがあります |
| Gitalyシャード             | 単一のストレージロケーションは単一障害点です | 失敗したシャードのみを復元する必要があります            | 単一障害点          | 良好 - リポジトリをシャードに割り当てて、負荷を分散できます                                          | トレードオフ - 負荷やストレージ容量のバランスを取るために、異なるシャードに手動でリポジトリを設定する必要があります。リスク - 単一障害点は、単一ノードの障害が発生した場合のリカバリープロセスに依存します                                           |

## Geoの機能 {#geo-capabilities}

可用性のニーズが複数のゾーンまたは複数の場所にまたがる場合は、[Geo](../geo/_index.md)についてお読みください。

| 機能 | 利用可否設定                                                                                                                  | リカバリー性                                                                                                                                                                                                            | データ復元力                                                                                                                                                       | パフォーマンス                                         | リスクとトレードオフ                                                                                                                                                                                                                                     |
|:-----------|:------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------------------|:-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Geo        | Geoサイトのアーキテクチャによって異なります。単一ノードと複数ノードの設定でセカンダリをデプロイできます。 | 最終的には整合性が取れます。リカバリーポイントはレプリケーションのラグに依存し、ネットワーク速度など、多くの要因に依存します。Geoは、スクリプト化可能な手動コマンドを使用して、プライマリサイトからセカンダリサイトへのフェイルオーバーをサポートします。 | Geoは、計画されたデータ型の100%をレプリケートして検証します。詳細については、[レプリケートされたデータ型の表](../geo/replication/datatypes.md#replicated-data-types)を参照してください。 | セカンダリサイトのユーザーの読み取り/クローン時間を改善します。 | Geoは、他のバックアップ/復元ソリューションの代わりに使用することを目的としていません。レプリケーションのラグと、プライマリから不良データをレプリケートする可能性があるため、顧客はプライマリサイトの定期的なバックアップを作成し、復元プロセスをテストする必要があります。 |

## 障害モードと利用可能な軽減パスのシナリオ {#scenarios-for-failure-modes-and-available-mitigation-paths}

次の表は、前の表で詳述した製品の障害モードと軽減パスの概要を示しています。Gitalyクラスタリング（Praefect）のインストールでは、3以上の奇数のレプリケーション係数を想定しています。

| Gitalyモード                                        | 単一のGitalyノードの損失                                                                                                                                     | アプリケーション/データの破損                                                                                                       | 地域的停止（インスタンスの損失）              | 備考                                                                           |
|:---------------------------------------------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------|:------------------------------------------------|:--------------------------------------------------------------------------------|
| 単一のGitalyノード                                 | 停止時間 - バックアップから復元する必要があります                                                                                                                            | 停止時間 - バックアップから復元する必要があります                                                                                                 | 停止 - 停止が終わるまで待つ必要があります          |                                                                                 |
| 単一のGitalyノード + Geoセカンダリサイト                 | 停止 - バックアップから復元する必要があり、セカンダリサイトへの手動フェイルオーバーを実行できます                                                                                | 停止 - バックアップから復元する必要があり、エラーがセカンダリサイトに伝播している可能性があります                                                      | 手動操作 - Geoセカンダリサイトにフェイルオーバーします |                                                                                 |
| シャーディングされたGitalyインストール                             | 部分的な停止 - 影響を受けるノード上のリポジトリのみが影響を受け、バックアップから復元する必要があります                                                                       | 部分的な停止 - 影響を受けるノード上のリポジトリのみが影響を受け、バックアップから復元する必要があります                                            | 停止 - 停止が終わるまで待つ必要があります          |                                                                                 |
| シャード化されたGitalyインストール + Geoセカンダリサイト             | 部分的な停止 - 影響を受けるノード上のリポジトリのみが影響を受け、バックアップから復元する必要があり、影響を受けるリポジトリのセカンダリサイトへの手動フェイルオーバーを実行できます | 部分的な停止 - 影響を受けるノード上のリポジトリのみが影響を受け、バックアップから復元する必要があり、エラーがセカンダリサイトに伝播している可能性があります | 手動操作 - Geoセカンダリサイトにフェイルオーバーします |                                                                                 |
| Gitalyクラスタリング（Praefect）インストール*                 | 停止なし - 10秒後に別のノードにリポジトリのプライマリをスワップします                                                                                        | 該当なし。すべての書き込みは、複数のGitalyクラスタリング（Praefect）ノードによって投票されます                                                 | 停止 - 停止が終わるまで待つ必要があります          | Gitalyクラスタリング（Praefect）ノードのスナップショットのバックアップは、現時点ではサポートされていません |
| Gitalyクラスタリング（Praefect）インストール* + Geoセカンダリサイト | 停止なし - 10秒後に別のノードにリポジトリのプライマリをスワップします                                                                                        | 該当なし。すべての書き込みは、複数のGitalyクラスタリング（Praefect）ノードによって投票されます                                                 | 手動操作 - Geoセカンダリサイトにフェイルオーバーします | Gitalyクラスタリング（Praefect）ノードのスナップショットのバックアップは、現時点ではサポートされていません |
