---
stage: Runtime
group: Geo
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: GitLab Geoデータベースのレプリケーションを設定、構成、管理して、プライマリサイトとセカンダリサイトの同期を維持する方法について説明します。要件、レプリケーション方法、トラブルシューティングのガイダンスが含まれています。
title: GitLab Geoデータベースレプリケーション
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab Self-Managed

{{< /details >}}

このドキュメントでは、プライマリGitLabデータベースをセカンダリサイトのデータベースにレプリケートするために必要な最小限の手順について説明します。データベースの設定やサイズなどの属性に基づいて、いくつかの値を変更する必要がある場合があります。

{{< alert type="note" >}}

GitLabのインスタンスが（Linuxパッケージのインストールによって管理されていない）外部PostgreSQLデータベースのインスタンスを使用している場合、ロールは必要なすべての設定手順を実行できません。この場合、代わりに[外部PostgreSQLデータベースを使用するGeo](external_database.md)プロセスを使用してください。

{{< /alert >}}

{{< alert type="note" >}}

設定プロセスの各ステージは、ドキュメントに記載されている順序で完了する必要があります。そうでない場合は、続行する前に[以前のすべてのステージを完了](_index.md#using-linux-package-installations)してください。

{{< /alert >}}

**セカンダリ**サイトが、**プライマリ**サイトと同じバージョンのGitLab Enterprise Editionを実行していることを確認してください。**プライマリ**サイトに、[PremiumまたはUltimateプランのサブスクリプション](https://about.gitlab.com/pricing/)のライセンスを追加したことを確認してください。

テスト環境または本番環境でこれらの手順を実行する前に、必ずすべての手順を読み、確認してください。

## データベースパスワードの整合性要件 {#database-password-consistency-requirements}

データベース関連の各パスワード・タイプは、すべてのGeoサイト（プライマリとセカンダリ）で一致する値を持っている必要があります。これには次のユーザーが含まれます:

- `postgresql['sql_replication_password']`（レプリケーションユーザーのパスワード、MD5）
- `postgresql['sql_user_password']`（GitLabデータベース・ユーザーのパスワード、MD5）
- `gitlab_rails['db_password']`（GitLabデータベース・ユーザーのパスワード、平文）
- `patroni['replication_password']`（Patroni設定の場合、平文）
- `patroni['password']`（Patroni API認証の場合、平文）
- `postgresql['pgbouncer_user_password']`（PgBouncer使用時、MD5）

たとえば、プライマリサイトで設定された`patroni['password']`の値は、すべてのセカンダリサイトの`patroni['password']`の値と同一である必要があります。

これらのパスワードは、プライマリサイトとセカンダリサイト間のデータベース認証とレプリケーションに使用されます。異なるパスワードを使用すると、レプリケーションの失敗が発生し、Geoが正常に機能しなくなります。

## 単一インスタンスのデータベースレプリケーション {#single-instance-database-replication}

単一インスタンスのデータベースレプリケーションは、設定が容易で、クラスター化された代替手段と同じGeo機能を提供します。これは、単一のマシンで実行される設定や、将来のクラスター化されたインストールのためにGeoを評価しようとする場合に役立ちます。

単一インスタンスは、HAアーキテクチャに推奨されるPatroniを使用して、クラスター化されたバージョンに展開できます。

PostgreSQLレプリケーションを単一インスタンスデータベースとして設定する方法については、以下の手順に従ってください。または、Patroniクラスターを使用したレプリケーションの設定に関する[マルチノードデータベースレプリケーション](#multi-node-database-replication)の指示を参照してください。

### PostgreSQLレプリケーション {#postgresql-replication}

書き込み操作が発生するGitLabの**プライマリ**サイトは、**プライマリ**データベース・サーバーに接続します。**セカンダリ**サイトは、独自のデータベース・サーバー（読み取り専用）に接続します。

**プライマリ**サイトが**セカンダリ**サイトの復元に必要なすべてのデータを保持するように、[PostgreSQLレプリケーションスロット](https://medium.com/@tk512/replication-slots-in-postgresql-b4b03d277c75)を使用する必要があります。詳細については、下記をご覧ください。

以下のガイドでは、以下を前提としています:

- Linuxパッケージ（PostgreSQL 12以降を使用）を使用しており、[`pg_basebackup`ツール](https://www.postgresql.org/docs/16/app-pgbasebackup.html)が含まれています。
- Linuxパッケージのインストールによって管理されているPostgreSQL（または同等のバージョン）を実行している**プライマリ**サイト（レプリケート元のGitLabサーバー）がすでに設定されており、すべてのサイトで同じ**セカンダリ**サイトが設定され、同じ[バージョンのPostgreSQL](../_index.md#requirements-for-running-geo)、OS、GitLabを使用している。

{{< alert type="warning" >}}

Geoはストリーミングレプリケーションで動作します。論理レプリケーションはサポートされていませんが、[エピック18022](https://gitlab.com/groups/gitlab-org/-/epics/18022)では、この動作を変更することを提案しています。

{{< /alert >}}

#### ステップ1: **プライマリ**サイトを設定する {#step-1-configure-the-primary-site}

1. GitLabの**プライマリ**サイトにSSHで接続し、rootとしてサインインします:

   ```shell
   sudo -i
   ```

1. GitLabのバージョンアップグレード時に意図しないダウンタイムが発生するのを防ぐため、[PostgreSQLの自動バージョンアップグレードをオプトアウト](https://docs.gitlab.com/omnibus/settings/database/#opt-out-of-automatic-postgresql-upgrades)します。既知の[GeoでPostgreSQLをバージョンアップグレードする際の注意点](https://docs.gitlab.com/omnibus/settings/database/#caveats-when-upgrading-postgresql-with-geo)に注意してください。特に大規模な環境では、PostgreSQLのバージョンアップグレードは慎重に計画および実行する必要があります。その結果、今後は、PostgreSQLのバージョンアップグレードが定期的なメンテナンス活動の一部であることを確認してください。

1. `/etc/gitlab/gitlab.rb`を編集して、サイトの**unique**（一意）の名前を追加します:

   ```ruby
   ##
   ## The unique identifier for the Geo site. See
   ## https://docs.gitlab.com/ee/administration/geo_sites.html#common-settings
   ##
   gitlab_rails['geo_node_name'] = '<site_name_here>'
   ```

1. 変更を有効にするには、**プライマリ**サイトを再設定します:

   ```shell
   gitlab-ctl reconfigure
   ```

1. サイトを**プライマリ**サイトとして定義するには、以下のコマンドを実行します:

   ```shell
   gitlab-ctl set-geo-primary-node
   ```

   このコマンドは、`/etc/gitlab/gitlab.rb`で定義された`external_url`を使用します。

1. `gitlab`データベース・ユーザーのパスワードを定義します:

   必要なパスワードのMD5ハッシュを生成します:

   ```shell
   gitlab-ctl pg-password-md5 gitlab
   # Enter password: <your_db_password_here>
   # Confirm password: <your_db_password_here>
   # fca0b89a972d69f00eb3ec98a5838484
   ```

   `/etc/gitlab/gitlab.rb`を編集します: 

   ```ruby
   # Fill with the hash generated by `gitlab-ctl pg-password-md5 gitlab`
   postgresql['sql_user_password'] = '<md5_hash_of_your_db_password>'

   # Every node that runs Puma or Sidekiq needs to have the database
   # password specified as below. If you have a high-availability setup, this
   # must be present in all application nodes.
   gitlab_rails['db_password'] = '<your_db_password_here>'
   ```

1. データベースの[レプリケーションユーザー](https://www.postgresql.org/docs/16/warm-standby.html#STREAMING-REPLICATION)のパスワードを定義します。

   `postgresql['sql_replication_user']`の`/etc/gitlab/gitlab.rb`で定義されているユーザー名を使用します。デフォルト値は`gitlab_replicator`です。ユーザー名を別のものに変更した場合は、以下の手順を調整してください。

   必要なパスワードのMD5ハッシュを生成します:

   ```shell
   gitlab-ctl pg-password-md5 gitlab_replicator
   # Enter password: <your_replication_password_here>
   # Confirm password: <your_replication_password_here>
   # 950233c0dfc2f39c64cf30457c3b7f1e
   ```

   `/etc/gitlab/gitlab.rb`を編集します: 

   ```ruby
   # Fill with the hash generated by `gitlab-ctl pg-password-md5 gitlab_replicator`
   postgresql['sql_replication_password'] = '<md5_hash_of_your_replication_password>'
   ```

   Linuxパッケージのインストールによって管理されていない外部データベースを使用している場合は、`gitlab_replicator`ユーザーを作成し、そのユーザーのパスワードを手動で定義する必要があります:

   ```sql
   --- Create a new user 'replicator'
   CREATE USER gitlab_replicator;

   --- Set/change a password and grants replication privilege
   ALTER USER gitlab_replicator WITH REPLICATION ENCRYPTED PASSWORD '<replication_password>';
   ```

1. `/etc/gitlab/gitlab.rb`を編集し、ロールを`geo_primary_role`に設定します（詳細については、[Geoロール](https://docs.gitlab.com/omnibus/roles/#gitlab-geo-roles)を参照してください）:

   ```ruby
   ## Geo Primary role
   roles(['geo_primary_role'])
   ```

1. ネットワーク・インターフェースでリッスンするようにPostgreSQLを設定します:

   セキュリティ上の理由から、PostgreSQLはデフォルトではどのネットワーク・インターフェースでもリッスンしません。ただし、Geoでは、**セカンダリ**サイトが**プライマリ**サイトのデータベースに接続できる必要があります。このため、各サイトのIPアドレスが必要です。

   {{< alert type="note" >}}

   外部PostgreSQLインスタンスについては、[追加手順](external_database.md)を参照してください。

   {{< /alert >}}

   クラウドプロバイダーを使用している場合は、各Geoサイトのアドレスをクラウドプロバイダーの管理コンソールで確認できます。

   Geoサイトのアドレスを調べるには、GeoサイトにSSHで接続して実行します:

   ```shell
   ##
   ## Private address
   ##
   ip route get 255.255.255.255 | awk '{print "Private address:", $NF; exit}'

   ##
   ## Public address
   ##
   echo "External address: $(curl --silent "ipinfo.io/ip")"
   ```

   ほとんどの場合、以下のアドレスがGitLab Geoの設定に使用されます:

   | 設定                           | アドレス                                                               |
   |:----------------------------------------|:----------------------------------------------------------------------|
   | `postgresql['listen_address']`          | **プライマリ**サイトのパブリックまたはVPCプライベート・アドレス。                     |
   | `postgresql['md5_auth_cidr_addresses']` | **プライマリ**サイトおよび**セカンダリ**サイトのパブリックまたはVPCプライベート・アドレス。 |

   Googleクラウドプロバイダー、SoftLayer、またはVirtual Private Cloud（VPC）を提供するその他のベンダーを使用している場合は、**プライマリ**サイトと**セカンダリ**サイトの「プライベート」または「内部」アドレスを`postgresql['md5_auth_cidr_addresses']`および`postgresql['listen_address']`に使用することをお勧めします。

   `listen_address`オプションは、指定されたアドレスに対応するインターフェースとのネットワーク接続に対してPostgreSQLを展開します。詳細については、[PostgreSQLのドキュメント](https://www.postgresql.org/docs/16/runtime-config-connection.html)を参照してください。

   {{< alert type="note" >}}

   `0.0.0.0`または`*`を`listen_address`として使用する必要がある場合は、Railsが`127.0.0.1`経由で接続できるように、`127.0.0.1/32`を`postgresql['md5_auth_cidr_addresses']`設定に追加する必要があります。詳細については、[issue 5258](https://gitlab.com/gitlab-org/omnibus-gitlab/-/issues/5258)を参照してください。

   {{< /alert >}}

   ネットワーク設定によっては、推奨されるアドレスが正しくない場合があります。**プライマリ**サイトと**セカンダリ**サイトがローカルエリアネットワーク、または[Amazon VPC](https://aws.amazon.com/vpc/)や[Google VPC](https://cloud.google.com/vpc/)のようなアベイラビリティーゾーンを接続する仮想ネットワーク経由で接続する場合は、`postgresql['md5_auth_cidr_addresses']`に**セカンダリ**サイトのプライベートアドレスを使用する必要があります。

   `/etc/gitlab/gitlab.rb`を編集し、IPアドレスをネットワーク設定に適したアドレスに置き換えて、以下を追加します:

   ```ruby
   ##
   ## Primary address
   ## - replace '<primary_node_ip>' with the public or VPC address of your Geo primary node
   ##
   postgresql['listen_address'] = '<primary_site_ip>'

   ##
   # Allow PostgreSQL client authentication from the primary and secondary IPs. These IPs may be
   # public or VPC addresses in CIDR format, for example ['198.51.100.1/32', '198.51.100.2/32']
   ##
   postgresql['md5_auth_cidr_addresses'] = ['<primary_site_ip>/32', '<secondary_site_ip>/32']

   ##
   ## Replication settings
   ##
   # postgresql['max_replication_slots'] = 1 # Set this to be the number of Geo secondary nodes if you have more than one
   # postgresql['max_wal_senders'] = 10
   # postgresql['wal_keep_segments'] = 10
   ```

1. PostgreSQLが再起動され、プライベートアドレスでリッスンするまで、自動データベース移行を一時的に無効にします。`/etc/gitlab/gitlab.rb`を編集し、設定をfalseに変更します:

   ```ruby
   ## Disable automatic database migrations
   gitlab_rails['auto_migrate'] = false
   ```

1. オプション。別の**セカンダリ**サイトを追加する場合は、関連する設定は次のようになります:

   ```ruby
   postgresql['md5_auth_cidr_addresses'] = ['<primary_site_ip>/32', '<secondary_site_ip>/32', '<another_secondary_site_ip>/32']
   ```

   データベースレプリケーション要件に合わせて、`wal_keep_segments`と`max_wal_senders`を編集することもできます。詳細については、[PostgreSQL - レプリケーションに関するドキュメント](https://www.postgresql.org/docs/16/runtime-config-replication.html)を参照してください。

1. ファイルを保存し、データベースのリスン変更とレプリケーションスロットの変更が適用されるようにGitLabを再設定します:

   ```shell
   gitlab-ctl reconfigure
   ```

   PostgreSQLを再起動して、変更を有効にします:

   ```shell
   gitlab-ctl restart postgresql
   ```

1. PostgreSQLが再起動され、プライベートアドレスでリッスンするようになったので、移行を再度有効にします。

   `/etc/gitlab/gitlab.rb`を編集し、設定を**変更**して`true`にします:

   ```ruby
   gitlab_rails['auto_migrate'] = true
   ```

   ファイルを保存して、GitLabを再設定します:

   ```shell
   gitlab-ctl reconfigure
   ```

1. PostgreSQLサーバーがリモート接続を受け入れるように設定されたので、`netstat -plnt | grep 5432`を実行して、PostgreSQLがポート`5432`で**プライマリ**サイトのプライベートアドレスをリッスンしていることを確認します。

1. GitLabを再設定すると、CA証明書が自動的に生成されました。これは、PostgreSQLトラフィックを盗聴者から保護するために自動的に使用されます。アクティブな（「中間者」）攻撃者から保護するには、**セカンダリ**サイトは、証明書に署名した認証局のコピーを必要とします。この自己署名証明書の場合、**プライマリ**サイトでこのコマンドを実行して、PostgreSQLの`server.crt`ファイルのコピーを作成します:

   ```shell
   cat ~gitlab-psql/data/server.crt
   ```

   出力をクリップボードまたはローカル・ファイルにコピーします。**セカンダリ**サイトの設定時に必要になります。証明書は機密データではありません。

   ただし、この証明書は汎用的な`PostgreSQL`共通名で作成されています。このため、データベースをレプリケートする際に`verify-ca`モードを使用する必要があります。そうしないと、ホスト名の不一致によってエラーが発生します。

1. オプション。生成された証明書を使用する代わりに、独自のSSL証明書を生成し、手動で[PostgreSQLのSSLを設定します](https://docs.gitlab.com/omnibus/settings/database.html#configuring-ssl)。

   少なくともSSL証明書とキーが必要です。データベースSSLのドキュメントに従って、`postgresql['ssl_cert_file']`と`postgresql['ssl_key_file']`の値をフルパスに設定します。

   これにより、データベースをレプリケートする際に`verify-full` SSLモードを使用し、CNの完全なホスト名を検証するという追加のメリットを得ることができます。

   今後は、以前に自動生成された自己署名証明書の代わりに、この証明書（`postgresql['ssl_cert_file']`にも設定されている）を使用できます。これにより、CNが一致する場合、レプリケーションエラーなしで`verify-full`を使用できます。

   プライマリデータベースで、`/etc/gitlab/gitlab.rb`を開き、`postgresql['ssl_ca_file']`（CA証明書）を検索します。後で`server.crt`に貼り付けるクリップボードに値をコピーします。

#### ステップ2: **セカンダリ**サーバーを設定する {#step-2-configure-the-secondary-server}

1. GitLabの**セカンダリ**サイトにSSHで接続し、rootとしてサインインします:

   ```shell
   sudo -i
   ```

1. GitLabのバージョンアップグレード時に意図しないダウンタイムが発生するのを防ぐため、[PostgreSQLの自動バージョンアップグレードをオプトアウト](https://docs.gitlab.com/omnibus/settings/database/#opt-out-of-automatic-postgresql-upgrades)します。既知の[GeoでPostgreSQLをバージョンアップグレードする際の注意点](https://docs.gitlab.com/omnibus/settings/database/#caveats-when-upgrading-postgresql-with-geo)に注意してください。特に大規模な環境では、PostgreSQLのバージョンアップグレードは慎重に計画および実行する必要があります。その結果、今後は、PostgreSQLのバージョンアップグレードが定期的なメンテナンス活動の一部であることを確認してください。

1. アプリケーションサーバーとSidekiqを停止します:

   ```shell
   gitlab-ctl stop puma
   gitlab-ctl stop sidekiq
   ```

   {{< alert type="note" >}}

   この手順は、サイトが完全に設定される前に何かを実行しようとしないようにするために重要です。

   {{< /alert >}}

1. [プライマリ](../../raketasks/maintenance.md)サイトのPostgreSQLサーバーへの**プライマリ**をチェックします:

   ```shell
   gitlab-rake gitlab:tcp_check[<primary_site_ip>,5432]
   ```

   {{< alert type="note" >}}

   この手順が失敗した場合は、間違ったIPアドレスを使用しているか、ファイアウォールがサイトへのアクセスを妨げている可能性があります。IPアドレスを確認し、パブリックアドレスとプライベートアドレスの違いに細心の注意を払ってください。ファイアウォールが存在する場合、**セカンダリ**サイトがポート5432で**プライマリ**サイトに接続することを許可されていることを確認してください。

   {{< /alert >}}

1. **セカンダリ**サイトにファイル`server.crt`を作成します。コンテンツは、**プライマリ**サイトの設定の最後の手順で取得したものです:

   ```shell
   editor server.crt
   ```

1. **セカンダリ**サイトでPostgreSQL TLS検証を設定します:

   `server.crt`ファイルをインストールします:

   ```shell
   install \
      -D \
      -o gitlab-psql \
      -g gitlab-psql \
      -m 0400 \
      -T server.crt ~gitlab-psql/.postgresql/root.crt
   ```

   PostgreSQLは、TLS接続を検証する際に、その正確な証明書のみを認識するようになりました。証明書は、**プライマリ**サイトに**only**（のみ）存在する秘密キーへのアクセス権を持つ人のみがレプリケートできます。

1. `gitlab-psql`ユーザーが**プライマリ**サイトのデータベースに接続できることをテストします（デフォルトのデータベース名はLinuxパッケージのインストールでは`gitlabhq_production`です）:

   ```shell
   sudo \
      -u gitlab-psql /opt/gitlab/embedded/bin/psql \
      --list \
      -U gitlab_replicator \
      -d "dbname=gitlabhq_production sslmode=verify-ca" \
      -W \
      -h <primary_site_ip>
   ```

   {{< alert type="note" >}}

   手動で生成した証明書を使用しており、完全なホスト名の検証を利用するために`sslmode=verify-full`を使用する場合は、コマンドの実行時に`verify-ca`を`verify-full`に置き換えます。

   {{< /alert >}}

   メッセージが表示されたら、最初のステップで`gitlab_replicator`ユーザー用に設定した平文パスワードを入力します。すべてが正しく機能している場合は、**プライマリ**サイトのデータベースのリストが表示されます。

   ここで接続に失敗した場合は、TLSの設定が正しくないことを示します。**プライマリ**サイトの`~gitlab-psql/data/server.crt`の内容が、**セカンダリ**サイトの`~gitlab-psql/.postgresql/root.crt`の内容と一致していることを確認してください。

1. `/etc/gitlab/gitlab.rb`を編集し、ロールを`geo_secondary_role`に設定します（詳細については、[Geoロール](https://docs.gitlab.com/omnibus/roles/#gitlab-geo-roles)を参照してください）:

   ```ruby
   ##
   ## Geo Secondary role
   ## - configure dependent flags automatically to enable Geo
   ##
   roles(['geo_secondary_role'])
   ```

1. PostgreSQLを設定する:

   この手順は、**プライマリ**インスタンスを設定した方法と似ています。これは、単一のノードを使用している場合でも、有効にする必要があります。

   {{< alert type="warning" >}}各パスワード・タイプは、すべてのGeoサイトで[一致する値](#database-password-consistency-requirements)を持っている必要があります。{{< /alert >}}

   `/etc/gitlab/gitlab.rb`を編集し、IPアドレスをネットワーク設定に適したアドレスに置き換えて、以下を追加します:

   ```ruby
   ##
   ## Secondary address
   ## - replace '<secondary_site_ip>' with the public or VPC address of your Geo secondary site
   ##
   postgresql['listen_address'] = '<secondary_site_ip>'
   postgresql['md5_auth_cidr_addresses'] = ['<secondary_site_ip>/32']

   ##
   ## Database credentials password (defined previously in primary site)
   ## - replicate same values here as defined in primary site
   ##
   postgresql['sql_replication_password'] = '<md5_hash_of_your_replication_password>'
   postgresql['sql_user_password'] = '<md5_hash_of_your_db_password>'
   gitlab_rails['db_password'] = '<your_db_password_here>'
   ```

   外部PostgreSQLインスタンスについては、[追加手順](external_database.md)を参照してください。以前の**プライマリ**サイトをオンラインに戻して**セカンダリ**サイトとして機能させる場合は、`roles(['geo_primary_role'])`または`geo_primary_role['enable'] = true`も削除する必要があります。

1. 変更を有効にするには、GitLabを再構成してください:

   ```shell
   gitlab-ctl reconfigure
   ```

1. IPの変更を有効にするには、PostgreSQLを再起動します:

   ```shell
   gitlab-ctl restart postgresql
   ```

#### ステップ3: レプリケーションプロセスを開始する {#step-3-initiate-the-replication-process}

以下は、**セカンダリ**サイトのデータベースを**プライマリ**サイトのデータベースに接続するスクリプトです。このスクリプトはデータベースをレプリケートし、ストリーミングレプリケーションに必要なファイルを作成します。

使用されるディレクトリは、Linuxパッケージのインストールで設定されているデフォルトです。デフォルトを変更した場合は、それに応じてスクリプトを設定してください（ディレクトリとパスを置き換えます）。

{{< alert type="warning" >}}

`pg_basebackup`の実行前にPostgreSQLのすべてのデータを削除するため、必ず**セカンダリ**サイトでこれを実行してください。

{{< /alert >}}

1. GitLabの**セカンダリ**サイトにSSHで接続し、rootとしてサインインします:

   ```shell
   sudo -i
   ```

1. レプリケーションスロット名として使用する**セカンダリ**サイトに使用する、[データベースに適した名前](https://www.postgresql.org/docs/16/warm-standby.html#STREAMING-REPLICATION-SLOTS-MANIPULATION)を選択してください。たとえば、ドメインが`secondary.geo.example.com`の場合、以下のコマンドに示すように、スロット名として`secondary_example`を使用します。

1. 以下のコマンドを実行して、バックアップ／復元するを開始し、レプリケーションを開始します。

   {{< alert type="warning" >}}

   各GitLab Geoの**セカンダリ**サイトには、独自のユニークなレプリケーションスロット名が必要です。2つのセカンダリ間で同じスロット名を使用すると、PostgreSQLのレプリケーションが中断されます。

   {{< /alert >}}

   {{< alert type="note" >}}

   レプリケーションスロット名には、小文字の文字、数字、アンダースコア文字のみを含める必要があります。

   {{< /alert >}}

   プロンプ​​トが表示されたら、最初の手順で`gitlab_replicator`ユーザーに設定した平文のパスワードを入力します。

   ```shell
   gitlab-ctl replicate-geo-database \
      --slot-name=<secondary_site_name> \
      --host=<primary_site_ip> \
      --sslmode=verify-ca
   ```

   {{< alert type="note" >}}

   カスタムPostgreSQL証明書を生成した場合は、追加のセキュリティのために証明書CN / SANの完全なホスト名の追加検証を利用するには、`--sslmode=verify-full`（または`sslmode`行を完全に省略）を使用する必要があります。そうでない場合、自動的に作成された証明書を`verify-full`で使用すると、一般的な`PostgreSQL` CNがあり、このコマンドの`--host`値と一致しないため、失敗します。

   {{< /alert >}}

   このコマンドは、多数の追加オプションも使用します。すべてをリストするには`--help`を使用できますが、以下にいくつかのヒントを示します:

   - プライマリサイトに単一ノードがある場合は、`--host`パラメータとしてプライマリノードホストを使用します。
   - プライマリサイトが外部PostgreSQLデータベースを使用している場合は、`--host`パラメータを調整する必要があります:
      - PgBouncerの設定では、PgBouncerのアドレスではなく、実際のPostgreSQLデータベースホストを直接ターゲットにします。
      - Patroni構成の場合は、現在のPatroniリーダーホストをターゲットにします。
      - ロードバランサー（たとえば、HAProxy）を使用する場合、ロードバランサーが常にPatroniリーダーにルーティングするように構成されている場合は、ロードバランサーのターゲットにできます。そうでない場合は、実際のデータベースホストをターゲットにする必要があります。
      - 専用のPostgreSQLノードを使用するセットアップの場合は、専用のデータベースホストを直接ターゲットにします。
   - `--slot-name`を、**プライマリ**データベースで使用されるレプリケーションスロットの名前に変更します。スクリプトは、レプリケーションスロットが存在しない場合、自動的に作成しようとします。
   - PostgreSQLが標準以外のポートでリッスンしている場合は、`--port=`を追加します。
   - データベースが大きすぎて30分で転送できない場合は、タイムアウトを増やす必要があります。たとえば、最初のレプリケーションに1時間未満かかると思われる場合は、`--backup-timeout=3600`を使用します。
   - `--sslmode=disable`を渡して、PostgreSQL TLS認証を完全にスキップします（たとえば、ネットワークパスが安全であることがわかっているか、サイト間VPNを使用している場合）。公衆インターネット上では安全**not**（ではありません）。
   - 各`sslmode`の詳細については、[PostgreSQLドキュメント](https://www.postgresql.org/docs/16/libpq-ssl.html#LIBPQ-SSL-PROTECTION)を参照してください。上記の手順は、受動的な盗聴者とアクティブな「man-in-the-middle」攻撃者の両方に対する保護を確保するために、注意深く記述されています。
   - 古いサイトをGitLab Geoの**セカンダリ**サイトに再利用する場合は、コマンドラインに`--force`を追加する必要があります。
   - 本番環境マシンにない場合は、`--skip-backup`を追加して、（必要な場合に）バックアップ手順を無効にすることができます。

レプリケーションプロセスは完了しました。

{{< alert type="note" >}}

レプリケーションプロセスは、プライマリサイトのデータベースからセカンダリサイトのデータベースにのみデータをコピーします。セカンダリサイトの設定を完了するには、[プライマリサイトにセカンダリサイトを追加](../replication/configuration.md#step-3-add-the-secondary-site)します。

{{< /alert >}}

### PgBouncerのサポート（オプション） {#pgbouncer-support-optional}

[PgBouncer](https://www.pgbouncer.org/)は、GitLab Geoで使用してPostgreSQL接続をプールすることができ、単一インスタンスインストールで使用する場合でもパフォーマンスを向上させることができます。

GitLabを高可用性構成で使用し、Geoの**プライマリ**サイトをサポートするクラスターと、Geoの**セカンダリ**サイトをサポートする他の2つのクラスターを使用する場合は、PgBouncerを使用する必要があります。2つのPgBouncerノードが必要です。メインデータベース用と、追跡データベース用です。詳細については、[関連ドキュメント](../../postgresql/replication_and_failover.md)を参照してください。

### レプリケーションパスワードの変更 {#changing-the-replication-password}

{{< alert type="warning" >}}レプリケーションパスワードを変更する場合は、**すべて**のGeoサイト（プライマリとすべてのセカンダリ）で[同じパスワード値](#database-password-consistency-requirements)に更新する必要があります。パスワードの同期を維持できないと、レプリケーションが中断します。{{< /alert >}}

Linuxパッケージのインストールによって管理されるPostgreSQLインスタンスを使用する場合に、[レプリケーションユーザー](https://www.postgresql.org/docs/16/warm-standby.html#STREAMING-REPLICATION)のパスワードを変更するには、次の手順を実行します:

GitLab Geoの**プライマリ**サイト:

1. レプリケーションユーザーのデフォルト値は`gitlab_replicator`ですが、`/etc/gitlab/gitlab.rb`の`postgresql['sql_replication_user']`設定でカスタムレプリケーションユーザーを設定した場合は、独自のユーザーに合わせて以下の手順を調整してください。

   目的のパスワードのMD5ハッシュを生成します:

   ```shell
   sudo gitlab-ctl pg-password-md5 gitlab_replicator
   # Enter password: <your_replication_password_here>
   # Confirm password: <your_replication_password_here>
   # 950233c0dfc2f39c64cf30457c3b7f1e
   ```

   `/etc/gitlab/gitlab.rb`を編集します: 

   ```ruby
   # Fill with the hash generated by `gitlab-ctl pg-password-md5 gitlab_replicator`
   postgresql['sql_replication_password'] = '<md5_hash_of_your_replication_password>'
   ```

1. ファイルを保存し、GitLabを再設定して、PostgreSQLでレプリケーションユーザーのパスワードを変更します:

   ```shell
   sudo gitlab-ctl reconfigure
   ```

1. PostgreSQLを再起動して、レプリケーションパスワードの変更を有効にします:

   ```shell
   sudo gitlab-ctl restart postgresql
   ```

パスワードがいずれかの**セカンダリ**サイトで更新されるまで、セカンダリの[PostgreSQLログ](../../logs/_index.md#postgresql-logs)に次のエラーメッセージが表示されます:

```console
FATAL:  could not connect to the primary server: FATAL:  password authentication failed for user "gitlab_replicator"
```

すべてのGitLab Geoの**セカンダリ**サイト:

1. ハッシュされた`'sql_replication_password'`がGitLab Geoの**セカンダリ**サイトで使用されていないため、最初のステップは設定の観点からは必要ありません。ただし、**セカンダリ**サイトをGitLab Geoの**プライマリ**にプロモートする必要がある場合は、**セカンダリ**サイトの設定で`'sql_replication_password'`が一致していることを確認してください。

   `/etc/gitlab/gitlab.rb`を編集します: 

   ```ruby
   # Fill with the hash generated by `gitlab-ctl pg-password-md5 gitlab_replicator` on the Geo primary
   postgresql['sql_replication_password'] = '<md5_hash_of_your_replication_password>'
   ```

1. 最初のレプリケーションセットアップ中に、`gitlab-ctl replicate-geo-database`コマンドは、レプリケーションユーザーアカウントの平文パスワードを次の2つの場所に書き込みます:

   - `gitlab-geo.conf`: PostgreSQLのレプリケーションプロセスで使用され、PostgreSQLデータディレクトリに書き込まれます。デフォルトでは、 `/var/opt/gitlab/postgresql/data/gitlab-geo.conf`にあります。
   - `.pgpass`: `gitlab-psql`ユーザーによって使用され、デフォルトでは`/var/opt/gitlab/postgresql/.pgpass`にあります。

   これらの両方のファイルで平文のパスワードを更新し、PostgreSQLを再起動します:

   ```shell
   sudo gitlab-ctl restart postgresql
   ```

## マルチノードデータベースレプリケーション {#multi-node-database-replication}

### PostgreSQLノードをPatroniに移行する {#migrating-a-single-postgresql-node-to-patroni}

Patroniが導入される前は、Geoは**セカンダリ**サイトでの高可用性構成用のLinuxパッケージのインストールをサポートしていませんでした。

Patroniを使用すると、このサポートが可能になりました。既存のPostgreSQLをPatroniに移行するには:

1. **プライマリ**サイトでセットアップした方法と同様に、セカンダリでConsulクラスターセットアップがあることを確認します。
1. [永続的なレプリケーションスロットを設定します](#step-1-configure-patroni-permanent-replication-slot-on-the-primary-site)。
1. [内部ロードバランサー](#step-2-configure-the-internal-load-balancer-on-the-primary-site)を設定する
1. [PgBouncerノードを設定します](#step-3-configure-pgbouncer-nodes-on-the-secondary-site)
1. その単一ノードマシンで[スタンバイクラスターを設定する](#step-4-configure-a-standby-cluster-on-the-secondary-site)。

単一ノードを備えた**Standby Cluster**（スタンバイクラスター）で終了します。これにより、以前にリストされた同じ手順に従って、追加のPatroniノードを追加できます。

### Patroniのサポート {#patroni-support}

Patroniは、Geoの公式レプリケーション管理ソリューションです。Patroniを使用すると、**プライマリ**と**セカンダリ** Geoサイトで、可用性の高いクラスターをビルドできます。**セカンダリ**サイトでのPatroniの使用はオプションであり、各Geoサイトで同じ数のノードを使用する必要はありません。

プライマリサイトでPatroniをセットアップする方法については、[関連ドキュメント](../../postgresql/replication_and_failover.md#patroni)を参照してください。

#### GeoのセカンダリサイトのPatroniクラスターの設定 {#configuring-patroni-cluster-for-a-geo-secondary-site}

Geoのセカンダリサイトでは、メインPostgreSQLデータベースは、プライマリサイトのPostgreSQLデータベースの読み取り専用のレプリカです。

本番環境に対応した安全なセットアップには、少なくとも次のものが必要です:

- 3つのConsulノード_(プライマリおよびセカンダリサイト)_
- 2つのPatroniノード_(プライマリおよびセカンダリサイト)_
- 1つのPgBouncerノード_(プライマリおよびセカンダリサイト)_
- 1つの内部ロードバランサー_(プライマリサイトのみ)_

内部ロードバランサーは、新しいリーダーが選択されるたびに、Patroniクラスターのリーダーに接続するためのシングルエンドポイントを提供します。ロードバランサーは、セカンダリサイトからのカスケードレプリケーションを有効にするために必要です。

必ず[パスワード認証情報](../../postgresql/replication_and_failover.md#database-authorization-for-patroni)と、他のデータベースのベストプラクティスを使用してください。

##### ステップ1: プライマリサイトでPatroniの永続的なレプリケーションスロットを設定する {#step-1-configure-patroni-permanent-replication-slot-on-the-primary-site}

プライマリデータベースからセカンダリノードのPatroniクラスターへの継続的なデータレプリケーションを保証するために、プライマリデータベースに永続的なレプリケーションスロットをセットアップします。

{{< tabs >}}

{{< tab title="Patroniクラスターを備えたプライマリ" >}}

セカンダリサイトでPatroniを使用したデータベースレプリケーションをセットアップするには、プライマリサイトのPatroniクラスターに永続的なレプリケーションスロットを設定し、パスワード認証が使用されていることを確認する必要があります。

プライマリサイトのPatroniインスタンスを実行している各ノードで、**starting on the Patroni Leader instance**（Patroniリーダーインスタンスから開始）します:

1. PatroniインスタンスにSSHで接続し、rootとしてサインインします:

   ```shell
   sudo -i
   ```

1. GitLabのバージョンアップグレード時に意図しないダウンタイムが発生するのを防ぐため、[PostgreSQLの自動バージョンアップグレードをオプトアウト](https://docs.gitlab.com/omnibus/settings/database/#opt-out-of-automatic-postgresql-upgrades)します。既知の[GeoでPostgreSQLをバージョンアップグレードする際の注意点](https://docs.gitlab.com/omnibus/settings/database/#caveats-when-upgrading-postgresql-with-geo)に注意してください。特に大規模な環境では、PostgreSQLのバージョンアップグレードは慎重に計画および実行する必要があります。その結果、今後は、PostgreSQLのバージョンアップグレードが定期的なメンテナンス活動の一部であることを確認してください。

1. `/etc/gitlab/gitlab.rb`を編集し、以下を追加します。各パスワードタイプに、すべてのGeoサイトで[一致する値](#database-password-consistency-requirements)があることを確認してください。

   ```ruby
   roles(['patroni_role'])

   consul['services'] = %w(postgresql)
   consul['configuration'] = {
     retry_join: %w[CONSUL_PRIMARY1_IP CONSUL_PRIMARY2_IP CONSUL_PRIMARY3_IP]
   }

   # You need one entry for each secondary, with a unique name following PostgreSQL slot_name constraints:
   #
   # Configuration syntax is: 'unique_slotname' => { 'type' => 'physical' },
   # We don't support setting a permanent replication slot for logical replication type
   patroni['replication_slots'] = {
     'geo_secondary' => { 'type' => 'physical' }
   }

   patroni['use_pg_rewind'] = true
   patroni['postgresql']['max_wal_senders'] = 8 # Use double of the amount of patroni/reserved slots (3 patronis + 1 reserved slot for a Geo secondary).
   patroni['postgresql']['max_replication_slots'] = 8 # Use double of the amount of patroni/reserved slots (3 patronis + 1 reserved slot for a Geo secondary).
   patroni['username'] = 'PATRONI_API_USERNAME'
   patroni['password'] = 'PATRONI_API_PASSWORD'
   patroni['replication_password'] = 'PLAIN_TEXT_POSTGRESQL_REPLICATION_PASSWORD'

   # Add all patroni nodes to the allowlist
   patroni['allowlist'] = %w[
     127.0.0.1/32
     PATRONI_PRIMARY1_IP/32 PATRONI_PRIMARY2_IP/32 PATRONI_PRIMARY3_IP/32
     PATRONI_SECONDARY1_IP/32 PATRONI_SECONDARY2_IP/32 PATRONI_SECONDARY3_IP/32
   ]

   # We list all secondary instances as they can all become a Standby Leader
   postgresql['md5_auth_cidr_addresses'] = %w[
     PATRONI_PRIMARY1_IP/32 PATRONI_PRIMARY2_IP/32 PATRONI_PRIMARY3_IP/32 PATRONI_PRIMARY_PGBOUNCER/32
     PATRONI_SECONDARY1_IP/32 PATRONI_SECONDARY2_IP/32 PATRONI_SECONDARY3_IP/32 PATRONI_SECONDARY_PGBOUNCER/32
   ]

   postgresql['pgbouncer_user_password'] = 'PGBOUNCER_PASSWORD_HASH'
   postgresql['sql_replication_password'] = 'POSTGRESQL_REPLICATION_PASSWORD_HASH'
   postgresql['sql_user_password'] = 'POSTGRESQL_PASSWORD_HASH'
   postgresql['listen_address'] = '0.0.0.0' # You can use a public or VPC address here instead
   ```

1. 変更を有効にするには、GitLabを再構成してください:

   ```shell
   gitlab-ctl reconfigure
   ```

{{< /tab >}}

{{< tab title="シングルPostgreSQLインスタンスを備えたプライマリ" >}}

1. 単一ノードインスタンスにSSHで接続し、rootとしてサインインします:

   ```shell
   sudo -i
   ```

1. GitLabのバージョンアップグレード時に意図しないダウンタイムが発生するのを防ぐため、[PostgreSQLの自動バージョンアップグレードをオプトアウト](https://docs.gitlab.com/omnibus/settings/database/#opt-out-of-automatic-postgresql-upgrades)します。既知の[GeoでPostgreSQLをバージョンアップグレードする際の注意点](https://docs.gitlab.com/omnibus/settings/database/#caveats-when-upgrading-postgresql-with-geo)に注意してください。特に大規模な環境では、PostgreSQLのバージョンアップグレードは慎重に計画および実行する必要があります。その結果、今後は、PostgreSQLのバージョンアップグレードが定期的なメンテナンス活動の一部であることを確認してください。

1. `/etc/gitlab/gitlab.rb`を編集し、以下を追加します:

   ```ruby
   postgresql['max_wal_senders'] = 2 # Use 2 per secondary site (1 temporary slot for initial Patroni replication + 1 reserved slot for a Geo secondary)
   postgresql['max_replication_slots'] = 2 # Use 2 per secondary site (1 temporary slot for initial Patroni replication + 1 reserved slot for a Geo secondary)
   ```

1. GitLabを再設定します:

   ```shell
   gitlab-ctl reconfigure
   ```

1. PostgreSQLサービスを再起動して、新しい変更を有効にします:

   ```shell
   gitlab-ctl restart postgresql
   ```

1. データベースコンソールを起動します

   ```shell
   gitlab-psql
   ```

1. プライマリサイトで永続的なレプリケーションスロットを設定します

   ```sql
   select pg_create_physical_replication_slot('geo_secondary')
   ```

1. オプション。プライマリにPgBouncerがないが、セカンダリにある場合:

   プライマリサイトで`pgbouncer`ユーザーを設定し、Linuxパッケージに含まれているPgBouncerに必要な`pg_shadow_lookup`関数を追加します。セカンダリサーバー上のPgBouncerは、セカンダリサイト上のPostgreSQLノードに引き続き接続できる必要があります。

   ```sql
   --- Create a new user 'pgbouncer'
   CREATE USER pgbouncer;

   --- Set/change a password and grants replication privilege
   ALTER USER pgbouncer WITH REPLICATION ENCRYPTED PASSWORD '<pgbouncer_password_from_secondary>';

   CREATE OR REPLACE FUNCTION public.pg_shadow_lookup(in i_username text, out username text, out password text) RETURNS record AS $$
   BEGIN
       SELECT usename, passwd FROM pg_catalog.pg_shadow
       WHERE usename = i_username INTO username, password;
       RETURN;
   END;
   $$ LANGUAGE plpgsql SECURITY DEFINER;

   REVOKE ALL ON FUNCTION public.pg_shadow_lookup(text) FROM public, pgbouncer;
   GRANT EXECUTE ON FUNCTION public.pg_shadow_lookup(text) TO pgbouncer;
   ```

{{< /tab >}}

{{< /tabs >}}

##### ステップ2: プライマリサイトで内部ロードバランサーを設定する {#step-2-configure-the-internal-load-balancer-on-the-primary-site}

プライマリサイトで新しいリーダーが選択されるたびに、セカンダリサイトでスタンバイリーダーを再設定することを回避するには、TCP内部ロードバランサーをセットアップする必要があります。このロードバランサーは、Patroniクラスターのリーダーに接続するためのシングルエンドポイントを提供します。

Linuxパッケージにロードバランサーは含まれていません。[HAProxy](https://www.haproxy.org/)を使用してこれを行う方法を次に示します。

以下のIPと名前を例として使用します:

- `10.6.0.21`: HAProxy 1 (`patroni1.internal`)
- `10.6.0.22`: HAProxy 2 (`patroni2.internal`)
- `10.6.0.23`: HAProxy 3 (`patroni3.internal`)

```plaintext
global
    log /dev/log local0
    log localhost local1 notice
    log stdout format raw local0

defaults
    log global
    default-server inter 3s fall 3 rise 2 on-marked-down shutdown-sessions

frontend internal-postgresql-tcp-in
    bind *:5432
    mode tcp
    option tcplog

    default_backend postgresql

backend postgresql
    mode tcp
    option httpchk
    http-check expect status 200

    server patroni1.internal 10.6.0.21:5432 maxconn 100 check port 8008
    server patroni2.internal 10.6.0.22:5432 maxconn 100 check port 8008
    server patroni3.internal 10.6.0.23:5432 maxconn 100 check port 8008
```

詳細なガイダンスについては、推奨されるロードバランサーのドキュメントを参照してください。

##### ステップ3: セカンダリサイトでPgBouncerノードを設定する {#step-3-configure-pgbouncer-nodes-on-the-secondary-site}

本番環境に対応した、可用性の高い設定では、少なくとも3つのConsulノードと最小限1つのPgBouncerノードが必要です。ただし、データベースノードごとに1つのPgBouncerノードを用意することをお勧めします。複数のPgBouncerサービスノードがある場合は、内部ロードバランサー（TCP）が必要です。内部ロードバランサーは、PgBouncerクラスターに接続するためのシングルエンドポイントを提供します。詳細については、[関連ドキュメント](../../postgresql/replication_and_failover.md)を参照してください。

**セカンダリ**サイトでPgBouncerインスタンスを実行している各ノードで:

1. PgBouncerノードにSSHで接続し、rootとしてサインインします:

   ```shell
   sudo -i
   ```

1. `/etc/gitlab/gitlab.rb`を編集し、以下を追加します:

   ```ruby
   # Disable all components except Pgbouncer and Consul agent
   roles(['pgbouncer_role'])

   # PgBouncer configuration
   pgbouncer['admin_users'] = %w(pgbouncer gitlab-consul)
   pgbouncer['users'] = {
   'gitlab-consul': {
      # Generate it with: `gitlab-ctl pg-password-md5 gitlab-consul`
      password: 'GITLAB_CONSUL_PASSWORD_HASH'
    },
     'pgbouncer': {
       # Generate it with: `gitlab-ctl pg-password-md5 pgbouncer`
       password: 'PGBOUNCER_PASSWORD_HASH'
     }
   }

   # Consul configuration
   consul['watchers'] = %w(postgresql)
   consul['configuration'] = {
     retry_join: %w[CONSUL_SECONDARY1_IP CONSUL_SECONDARY2_IP CONSUL_SECONDARY3_IP]
   }
   consul['monitoring_service_discovery'] =  true
   ```

1. 変更を有効にするには、GitLabを再構成してください:

   ```shell
   gitlab-ctl reconfigure
   ```

1. `.pgpass`ファイルを作成して、ConsulがPgBouncerを再読み込みできるようにします。プロンプトが表示されたら、`PLAIN_TEXT_PGBOUNCER_PASSWORD`を2回入力します:

   ```shell
   gitlab-ctl write-pgpass --host 127.0.0.1 --database pgbouncer --user pgbouncer --hostuser gitlab-consul
   ```

1. PgBouncerサービスをリロードします:

   ```shell
   gitlab-ctl hup pgbouncer
   ```

##### ステップ4: セカンダリサイトでスタンバイクラスターを設定する {#step-4-configure-a-standby-cluster-on-the-secondary-site}

{{< alert type="note" >}}

シングルPostgreSQLインスタンスを備えたセカンダリサイトをPatroniクラスターに変換する場合は、PostgreSQLインスタンスから開始する必要があります。Patroniのスタンバイリーダーインスタンスになり、必要に応じて別のレプリカに切り替えることができます。

{{< /alert >}}

セカンダリサイトでPatroniインスタンスを実行している各ノードの場合:

1. PatroniノードにSSHで接続し、rootとしてサインインします:

   ```shell
   sudo -i
   ```

1. GitLabのバージョンアップグレード時に意図しないダウンタイムが発生するのを防ぐため、[PostgreSQLの自動バージョンアップグレードをオプトアウト](https://docs.gitlab.com/omnibus/settings/database/#opt-out-of-automatic-postgresql-upgrades)します。既知の[GeoでPostgreSQLをバージョンアップグレードする際の注意点](https://docs.gitlab.com/omnibus/settings/database/#caveats-when-upgrading-postgresql-with-geo)に注意してください。特に大規模な環境では、PostgreSQLのバージョンアップグレードは慎重に計画および実行する必要があります。その結果、今後は、PostgreSQLのバージョンアップグレードが定期的なメンテナンス活動の一部であることを確認してください。

1. `/etc/gitlab/gitlab.rb`を編集し、以下を追加します:

   {{< alert type="warning" >}}各パスワード・タイプは、すべてのGeoサイトで[一致する値](#database-password-consistency-requirements)を持っている必要があります。{{< /alert >}}

   ```ruby
   roles(['consul_role', 'patroni_role'])

   consul['enable'] = true
   consul['configuration'] = {
     retry_join: %w[CONSUL_SECONDARY1_IP CONSUL_SECONDARY2_IP CONSUL_SECONDARY3_IP]
   }
   consul['services'] = %w(postgresql)

   postgresql['md5_auth_cidr_addresses'] = [
     'PATRONI_SECONDARY1_IP/32', 'PATRONI_SECONDARY2_IP/32', 'PATRONI_SECONDARY3_IP/32', 'PATRONI_SECONDARY_PGBOUNCER/32',
     # Any other instance that needs access to the database as per documentation
   ]


   # Add patroni nodes to the allowlist
   patroni['allowlist'] = %w[
     127.0.0.1/32
     PATRONI_SECONDARY1_IP/32 PATRONI_SECONDARY2_IP/32 PATRONI_SECONDARY3_IP/32
   ]

   patroni['standby_cluster']['enable'] = true
   patroni['standby_cluster']['host'] = 'INTERNAL_LOAD_BALANCER_PRIMARY_IP'
   patroni['standby_cluster']['port'] = INTERNAL_LOAD_BALANCER_PRIMARY_PORT
   patroni['standby_cluster']['primary_slot_name'] = 'geo_secondary' # Or the unique replication slot name you setup before
   patroni['username'] = 'PATRONI_API_USERNAME'
   patroni['password'] = 'PATRONI_API_PASSWORD'
   patroni['replication_password'] = 'PLAIN_TEXT_POSTGRESQL_REPLICATION_PASSWORD'
   patroni['use_pg_rewind'] = true
   patroni['postgresql']['max_wal_senders'] = 5 # A minimum of three for one replica, plus two for each additional replica
   patroni['postgresql']['max_replication_slots'] = 5 # A minimum of three for one replica, plus two for each additional replica

   postgresql['pgbouncer_user_password'] = 'PGBOUNCER_PASSWORD_HASH'
   postgresql['sql_replication_password'] = 'POSTGRESQL_REPLICATION_PASSWORD_HASH'
   postgresql['sql_user_password'] = 'POSTGRESQL_PASSWORD_HASH'
   postgresql['listen_address'] = '0.0.0.0' # You can use a public or VPC address here instead

   # GitLab Rails configuration is required for `gitlab-ctl geo-replication-pause`
   gitlab_rails['db_password'] = 'POSTGRESQL_PASSWORD'
   gitlab_rails['enable'] = true
   gitlab_rails['auto_migrate'] = false
   ```

   `patroni['standby_cluster']['host']`と`patroni['standby_cluster']['port']`を設定する場合:
   - `INTERNAL_LOAD_BALANCER_PRIMARY_IP`は、プライマリ内部ロードバランサーのIPを指している必要があります。
   - `INTERNAL_LOAD_BALANCER_PRIMARY_PORT`は、[プライマリPatroniクラスターリーダー用に設定された](#step-2-configure-the-internal-load-balancer-on-the-primary-site)フロントエンドポートを指している必要があります。PgBouncerフロントエンドポートは**Do not**（使用しないでください）。

1. 変更を有効にするには、GitLabを再構成してください。この手順は、PostgreSQLユーザーと設定をブートストラップするために必要です。

   - これがPatroniの新しいインストールの場合は:

     ```shell
     gitlab-ctl reconfigure
     ```

   - 以前に動作していたPatroniクラスターがあるGeoサイトでPatroniスタンバイクラスターを設定している場合:

     1. カスケードレプリカを含め、Patroniによって管理されているすべてのノードでPatroniを停止します:

        ```shell
        gitlab-ctl stop patroni
        ```

     1. リーダーPatroniノードで以下を実行して、スタンバイクラスターを再作成します:

        ```shell
        rm -rf /var/opt/gitlab/postgresql/data
        /opt/gitlab/embedded/bin/patronictl -c /var/opt/gitlab/patroni/patroni.yaml remove postgresql-ha
        gitlab-ctl reconfigure
        ```

     1. プライマリPostgreSQLデータベースからのレプリケーションプロセスを開始するには、リーダーPatroniノードでPatroniを開始します:

        ```shell
        gitlab-ctl start patroni
        ```

     1. Patroniクラスターのステータスを確認します:

        ```shell
        gitlab-ctl patroni members
        ```

        以下を確認します:

        - 現在のPatroniノードが出力に表示されます。
        - ロールは`Standby Leader`です。ロールは最初に`Replica`と表示される場合があります。
        - 状態は`Running`です。状態は最初に`Creating replica`と表示される場合があります。

        ノードのロールが`Standby Leader`として安定し、状態が`Running`になるまで待ちます。これには数分かかる場合があります。

     1. リーダーPatroniノードが`Standby Leader`で`Running`の場合、スタンバイクラスター内の他のPatroniノードでPatroniを開始します:

        ```shell
        gitlab-ctl start patroni
        ```

        他のPatroniノードは、レプリカとして新しいスタンバイクラスターに参加し、リーダーPatroniノードからのレプリケーションを自動的に開始します。

1. クラスターの状態を確認します:

   ```shell
   gitlab-ctl patroni members
   ```

   すべてのPatroniノードが`Running`状態でリストされていることを確認します。1つの`Standby Leader`ノードと複数の`Replica`ノードが必要です。

### 単一のトラッキングデータベースノードをPatroniに移行する {#migrating-a-single-tracking-database-node-to-patroni}

Patroniの導入前は、Geoはセカンダリサイト上の高可用性設定のLinuxパッケージインストールをサポートしていませんでした。

Patroniを使用すると、高可用性設定をサポートできるようになりました。ただし、Patroniの一部の制限により、同じマシン上で2つの異なるクラスターを管理できません。GeoのセカンダリサイトのPatroniクラスターを[設定する](#configuring-patroni-cluster-for-a-geo-secondary-site)方法を説明する同じ手順に従って、トラッキングデータベースの新しいPatroniクラスターをセットアップする必要があります。

セカンダリノードは新しいトラッキングデータベースをバックフィルし、データの同期は必要ありません。

### トラッキングPostgreSQLデータベースのPatroniクラスターの設定 {#configuring-patroni-cluster-for-the-tracking-postgresql-database}

**セカンダリ**Geoサイトは、別のPostgreSQLインストールをトラッキングデータベースとして使用して、レプリケーションのステータスを追跡し、潜在的なレプリケーションの問題から自動的に回復します。

単一のノードでGeoトラッキングデータベースを実行する場合は、[Geoセカンダリサイト](../replication/multiple_servers.md#step-2-configure-the-geo-tracking-database-on-the-geo-secondary-site)でGeoトラッキングデータベースを設定するを参照してください。

Linuxパッケージは、高可用性設定でのGeoトラッキングデータベースの実行をサポートしていません。特に、フェイルオーバーは正しく機能しません。[機能リクエストイシュー](https://gitlab.com/gitlab-org/omnibus-gitlab/-/issues/7292)を参照してください。

高可用性設定でGeoトラッキングデータベースを実行する場合は、セカンダリサイトをクラウド管理データベースなどの外部PostgreSQLデータベース、または手動で設定された[Patroni](https://patroni.readthedocs.io/en/latest/)クラスター（GitLab Linuxパッケージで管理されていない）に接続できます。[外部PostgreSQLインスタンスを使用したGeo](external_database.md#configure-the-tracking-database)に従ってください。

## トラブルシューティング {#troubleshooting}

[トラブルシューティングドキュメント](../replication/troubleshooting/_index.md)をお読みください。
